/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.registry.GameRegistry$ObjectHolder;
import cpw.mods.fml.common.registry.ObjectHolderRef;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public enum ObjectHolderRegistry {
    INSTANCE;

    private List<ObjectHolderRef> objectHolders = Lists.newArrayList();

    public void findObjectHolders(ASMDataTable table) {
        boolean bl;
        String string;
        String string2;
        String string3;
        FMLLog.info("Processing ObjectHolder annotations", new Object[0]);
        Set<ASMDataTable$ASMData> set = table.getAll(GameRegistry$ObjectHolder.class.getName());
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        for (ASMDataTable$ASMData aSMDataTable$ASMData : set) {
            string3 = aSMDataTable$ASMData.getClassName();
            string2 = aSMDataTable$ASMData.getObjectName();
            string = (String)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            bl = string3.equals(string2);
            if (!bl) continue;
            this.scanTarget(hashMap, hashMap2, string3, string2, string, bl, false);
        }
        for (ASMDataTable$ASMData aSMDataTable$ASMData : set) {
            string3 = aSMDataTable$ASMData.getClassName();
            string2 = aSMDataTable$ASMData.getObjectName();
            string = (String)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            bl = string3.equals(string2);
            if (bl) continue;
            this.scanTarget(hashMap, hashMap2, string3, string2, string, bl, false);
        }
        this.scanTarget(hashMap, hashMap2, "fgm.iIIIiiiIiIIIIIiIIiIiiIiiiIIiIiIIiIIiiiIiIiiiIIIIIiIIiiIiiiiiiiiI", null, "minecraft", true, true);
        this.scanTarget(hashMap, hashMap2, "fgm.IIiiiiiiIIiiiIIIIIIiiIiiIiiIiiiIiiiIiiIIiiIiiIiiiIIiiiiIiiiiIIii", null, "minecraft", true, true);
        FMLLog.info("Found %d ObjectHolder annotations", this.objectHolders.size());
    }

    private void scanTarget(Map<String, String> classModIds, Map<String, Class<?>> classCache, String className, String annotationTarget, String value, boolean isClass, boolean extractFromValue) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, true, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
        if (isClass) {
            this.scanClassForFields(classModIds, className, (String)value, clazz, extractFromValue);
        } else {
            Object object;
            if (((String)value).indexOf(58) == -1) {
                object = classModIds.get(className);
                if (object == null) {
                    FMLLog.warning("Found an unqualified ObjectHolder annotation (%s) without a modid context at %s.%s, ignoring", value, className, annotationTarget);
                    throw new IllegalStateException("Unqualified reference to ObjectHolder");
                }
                value = (String)object + ":" + (String)value;
            }
            try {
                object = clazz.getField(annotationTarget);
                this.addHolderReference(new ObjectHolderRef((Field)object, (String)value, extractFromValue));
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
    }

    private void scanClassForFields(Map<String, String> classModIds, String className, String value, Class<?> clazz, boolean extractFromExistingValues) {
        classModIds.put(className, value);
        for (Field field : clazz.getFields()) {
            boolean bl;
            int n = field.getModifiers();
            boolean bl2 = bl = Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
            if (!bl || field.isAnnotationPresent(GameRegistry$ObjectHolder.class)) continue;
            this.addHolderReference(new ObjectHolderRef(field, value + ":" + field.getName(), extractFromExistingValues));
        }
    }

    private void addHolderReference(ObjectHolderRef ref) {
        if (ref.isValid()) {
            this.objectHolders.add(ref);
        }
    }

    public void applyObjectHolders() {
        FMLLog.info("Applying holder lookups", new Object[0]);
        for (ObjectHolderRef objectHolderRef : this.objectHolders) {
            objectHolderRef.apply();
        }
        FMLLog.info("Holder lookups applied", new Object[0]);
    }
}

