/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.VillagerRegistry$IVillageCreationHandler;
import cpw.mods.fml.common.registry.VillagerRegistry$IVillageTradeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fgm.IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii;
import fgm.IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii;
import fgm.IiIiiiIiiIIiIiiiIIIIiIiiiiIIIIiiIiiiIIiiIIiIiiIiIIiiIIIiIIiiIiII;
import fgm.iIIIiiIiiIIiIIIiiiIIIiiIIiIIIIIiiiiiiiiiiiiIIIIIIIIIiiIiIiIIiiIi;
import fgm.iIIiIiiIIiiiiiIiiiIiIiiIIIIIiiIIiIIIIIIIiIiIiiiIiIIiIIiiiIIiiiii;
import fgm.iIiIiIIIIIIiIIIIiIiIIiiIiiiiIiIiIIiiiIiiIiiIIIiIiiIiiiIiiIiiiIiI;
import fgm.iiIIiIIIIiIIIiiiiiiiIIiiIIIIiiIIiIIIIIiiiiIIiiiIIiiIiiIiiIiIiIII;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Multimap<Integer, VillagerRegistry$IVillageTradeHandler> tradeHandlers = ArrayListMultimap.create();
    private Map<Class<?>, VillagerRegistry$IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, iIIiIiiIIiiiiiIiiiIiIiiIIIIIiiIIiIIIIIIIiIiIiiiIiIIiIIiiiIIiiiii> newVillagers;

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe("Attempt to register duplicate villager id %d", id);
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerVillagerSkin(int villagerId, iIIiIiiIIiiiiiIiiiIiIiiIIIIIiiIIiIIIIIIIiIiIiiiIiIIiIIiiiIIiiiii villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(VillagerRegistry$IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public void registerVillageTradeHandler(int villagerId, VillagerRegistry$IVillageTradeHandler handler) {
        this.tradeHandlers.put((Object)villagerId, (Object)handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static iIIiIiiIIiiiiiIiiiIiIiiIIIIIiiIIiIIIIIIIiIiIiiiIiIIiIIiiiIIiiiii getVillagerSkin(int villagerType, iIIiIiiIIiiiiiIiiiIiIiiIIIIIiiIIiIIIIIIIiIiIiiiIiIIiIIiiiIIiiiii defaultSkin) {
        if (VillagerRegistry.instance().newVillagers != null && VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void manageVillagerTrades(IiIiiiIiiIIiIiiiIIIIiIiiiiIIIIiiIiiiIIiiIIiIiiIiIIiiIIIiIIiiIiII recipeList, IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii villager, int villagerType, Random random) {
        for (VillagerRegistry$IVillageTradeHandler villagerRegistry$IVillageTradeHandler : VillagerRegistry.instance().tradeHandlers.get((Object)villagerType)) {
            villagerRegistry$IVillageTradeHandler.manipulateTradesForVillager(villager, recipeList, random);
        }
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList arrayList = components;
        for (VillagerRegistry$IVillageCreationHandler villagerRegistry$IVillageCreationHandler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            arrayList.add(villagerRegistry$IVillageCreationHandler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(iIiIiIIIIIIiIIIIiIiIIiiIiiiiIiIiIIiiiIiiIiiIIIiIiiIiiiIiiIiiiIiI villagePiece, iIIIiiIiiIIiIIIiiiIIIiiIIiIIIIIiiiiiiiiiiiiIIIIIIIIIiiIiIiIIiiIi startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    public static void addEmeraldBuyRecipe(IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii villager, IiIiiiIiiIIiIiiiIIIIiIiiiiIIIIiiIiiiIIiiIIiIiiIiIIiiIIIiIIiiIiII list, Random random, IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI.put(item, new iiIIiIIIIiIIIiiiiiiiIIiiIIIIiiIIiIIIIIiiiiIIiiiIIiiIiiIiiIiIiIII(min, max));
        }
        IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(list, item, random, chance);
    }

    public static void addEmeraldSellRecipe(IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii villager, IiIiiiIiiIIiIiiiIIIIiIiiiiIIIIiiIiiiIIiiIIiIiiIiIIiiIIIiIIiiIiII list, Random random, IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI.put(item, new iiIIiIIIIiIIIiiiiiiiIIiiIIIIiiIIiIIIIIiiiiIIiiiIIiiIiiIiiIiIiIII(min, max));
        }
        IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(list, item, random, chance);
    }

    public static void applyRandomTrade(IiIiiiIiIIIIIiIIiIiIiiiiIIiiIIiiiIIIiIiiiiIIiiIIiiiiiiiiiiiiIIii villager, Random rand) {
        int n = VillagerRegistry.instance().newVillagerIds.size();
        int n2 = rand.nextInt(5 + n);
        villager.iIiIiIiIiiIiIiiiiiiiiiIIiiIiiiiiiIiIiiIiiIIiIiiIiIIiiiIiiIIiiIIi(n2 < 5 ? n2 : VillagerRegistry.instance().newVillagerIds.get(n2 - 5));
    }
}

