/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.common.toposort.TopologicalSort$DirectedGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class TopologicalSort {
    public static <T> List<T> topologicalSort(TopologicalSort$DirectedGraph<T> graph) {
        TopologicalSort$DirectedGraph<T> topologicalSort$DirectedGraph = TopologicalSort.reverse(graph);
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (T t : topologicalSort$DirectedGraph) {
            TopologicalSort.explore(t, topologicalSort$DirectedGraph, arrayList, hashSet, hashSet2);
        }
        return arrayList;
    }

    public static <T> TopologicalSort$DirectedGraph<T> reverse(TopologicalSort$DirectedGraph<T> graph) {
        TopologicalSort$DirectedGraph<T> topologicalSort$DirectedGraph = new TopologicalSort$DirectedGraph<T>();
        for (T t : graph) {
            topologicalSort$DirectedGraph.addNode(t);
        }
        for (T t : graph) {
            for (T t2 : graph.edgesFrom(t)) {
                topologicalSort$DirectedGraph.addEdge(t2, t);
            }
        }
        return topologicalSort$DirectedGraph;
    }

    public static <T> void explore(T node, TopologicalSort$DirectedGraph<T> graph, List<T> sortedResult, Set<T> visitedNodes, Set<T> expandedNodes) {
        if (visitedNodes.contains(node)) {
            if (expandedNodes.contains(node)) {
                return;
            }
            FMLLog.severe("Mod Sorting failed.", new Object[0]);
            FMLLog.severe("Visting node %s", node);
            FMLLog.severe("Current sorted list : %s", sortedResult);
            FMLLog.severe("Visited set for this node : %s", visitedNodes);
            FMLLog.severe("Explored node set : %s", expandedNodes);
            Sets.SetView setView = Sets.difference(visitedNodes, expandedNodes);
            FMLLog.severe("Likely cycle is in : %s", setView);
            throw new ModSortingException("There was a cycle detected in the input graph, sorting is not possible", node, setView);
        }
        visitedNodes.add(node);
        for (T t : graph.edgesFrom(node)) {
            TopologicalSort.explore(t, graph, sortedResult, visitedNodes, expandedNodes);
        }
        sortedResult.add(node);
        expandedNodes.add(node);
    }
}

