/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import cpw.mods.fml.common.versioning.ComparableVersion$IntegerItem;
import cpw.mods.fml.common.versioning.ComparableVersion$Item;
import cpw.mods.fml.common.versioning.ComparableVersion$ListItem;
import cpw.mods.fml.common.versioning.ComparableVersion$StringItem;
import java.util.Locale;
import java.util.Stack;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ComparableVersion
implements Comparable<ComparableVersion> {
    private String value;
    private String canonical;
    private ComparableVersion$ListItem items;

    public ComparableVersion(String version) {
        this.parseVersion(version);
    }

    public final void parseVersion(String version) {
        this.value = version;
        this.items = new ComparableVersion$ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ComparableVersion$ListItem comparableVersion$ListItem = this.items;
        Stack<ComparableVersion$ListItem> stack = new Stack<ComparableVersion$ListItem>();
        stack.push(comparableVersion$ListItem);
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == n) {
                    comparableVersion$ListItem.add(ComparableVersion$IntegerItem.ZERO);
                } else {
                    comparableVersion$ListItem.add(ComparableVersion.parseItem(bl, version.substring(n, i)));
                }
                n = i + 1;
                continue;
            }
            if (c == '-') {
                if (i == n) {
                    comparableVersion$ListItem.add(ComparableVersion$IntegerItem.ZERO);
                } else {
                    comparableVersion$ListItem.add(ComparableVersion.parseItem(bl, version.substring(n, i)));
                }
                n = i + 1;
                if (!bl) continue;
                comparableVersion$ListItem.normalize();
                if (i + 1 >= version.length() || !Character.isDigit(version.charAt(i + 1))) continue;
                ComparableVersion$ListItem comparableVersion$ListItem2 = comparableVersion$ListItem;
                comparableVersion$ListItem = new ComparableVersion$ListItem();
                comparableVersion$ListItem2.add(comparableVersion$ListItem);
                stack.push(comparableVersion$ListItem);
                continue;
            }
            if (Character.isDigit(c)) {
                if (!bl && i > n) {
                    comparableVersion$ListItem.add(new ComparableVersion$StringItem(version.substring(n, i), true));
                    n = i;
                }
                bl = true;
                continue;
            }
            if (bl && i > n) {
                comparableVersion$ListItem.add(ComparableVersion.parseItem(true, version.substring(n, i)));
                n = i;
            }
            bl = false;
        }
        if (version.length() > n) {
            comparableVersion$ListItem.add(ComparableVersion.parseItem(bl, version.substring(n)));
        }
        while (!stack.isEmpty()) {
            comparableVersion$ListItem = (ComparableVersion$ListItem)stack.pop();
            comparableVersion$ListItem.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static ComparableVersion$Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new ComparableVersion$IntegerItem(buf) : new ComparableVersion$StringItem(buf, false);
    }

    @Override
    public int compareTo(ComparableVersion o) {
        return this.items.compareTo(o.items);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof ComparableVersion && this.canonical.equals(((ComparableVersion)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }
}

