/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

@ObfuscationIgnore
class CoreModManager$FMLPluginWrapper
implements ITweaker {
    public final String name;
    public final IFMLLoadingPlugin coreModInstance;
    public final List<String> predepends;
    public final File location;
    public final int sortIndex;

    @ObfuscationIgnore
    public CoreModManager$FMLPluginWrapper(String name, IFMLLoadingPlugin coreModInstance, File location, int sortIndex, String ... predepends) {
        this.name = name;
        this.coreModInstance = coreModInstance;
        this.location = location;
        this.sortIndex = sortIndex;
        this.predepends = Lists.newArrayList((Object[])predepends);
    }

    @ObfuscationIgnore
    public String toString() {
        return String.format("%s {%s}", this.name, this.predepends);
    }

    @Override
    @ObfuscationIgnore
    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
    }

    @Override
    @ObfuscationIgnore
    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        FMLRelaunchLog.fine("Injecting coremod %s {%s} class transformers", this.name, this.coreModInstance.getClass().getName());
        if (this.coreModInstance.getASMTransformerClass() != null) {
            for (String object : this.coreModInstance.getASMTransformerClass()) {
                FMLRelaunchLog.finer("Skipping transformer %s - using direct source modifications", object);
            }
        }
        FMLRelaunchLog.fine("Injection complete", new Object[0]);
        FMLRelaunchLog.fine("Running coremod plugin for %s {%s}", this.name, this.coreModInstance.getClass().getName());
        HashMap hashMap = new HashMap();
        hashMap.put("mcLocation", CoreModManager.mcDir);
        hashMap.put("coremodList", CoreModManager.loadPlugins);
        hashMap.put("runtimeDeobfuscationEnabled", !CoreModManager.deobfuscatedEnvironment);
        FMLRelaunchLog.fine("Running coremod plugin %s", this.name);
        hashMap.put("coremodLocation", this.location);
        this.coreModInstance.injectData(hashMap);
        String string = this.coreModInstance.getSetupClass();
        if (string != null) {
            try {
                IFMLCallHook iFMLCallHook = (IFMLCallHook)Class.forName(string, true, classLoader).newInstance();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("runtimeDeobfuscationEnabled", !CoreModManager.deobfuscatedEnvironment);
                hashMap2.put("mcLocation", CoreModManager.mcDir);
                hashMap2.put("classLoader", classLoader);
                hashMap2.put("coremodLocation", this.location);
                hashMap2.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                iFMLCallHook.injectData(hashMap2);
                iFMLCallHook.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        FMLRelaunchLog.fine("Coremod plugin class %s run successfully", this.coreModInstance.getClass().getSimpleName());
        String string2 = this.coreModInstance.getModContainerClass();
        if (string2 != null) {
            FMLInjectionData.containers.add(string2);
        }
    }

    @Override
    @ObfuscationIgnore
    public String getLaunchTarget() {
        return "";
    }

    @Override
    public String[] getLaunchArguments() {
        return new String[0];
    }
}

