/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.ModAccessTransformer;
import cpw.mods.fml.common.launcher.FMLInjectionAndSortingTweaker;
import cpw.mods.fml.common.launcher.FMLTweaker;
import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.common.toposort.TopologicalSort$DirectedGraph;
import cpw.mods.fml.relauncher.CoreModManager$1;
import cpw.mods.fml.relauncher.CoreModManager$2;
import cpw.mods.fml.relauncher.CoreModManager$3;
import cpw.mods.fml.relauncher.CoreModManager$4;
import cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.FileListHelper;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin$DependsOn;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin$MCVersion;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin$Name;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin$SortingIndex;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin$TransformerExclusions;
import cpw.mods.fml.relauncher.ModListHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class CoreModManager {
    @ObfuscationIgnore
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");
    @ObfuscationIgnore
    private static final Attributes.Name MODTYPE = new Attributes.Name("ModType");
    @ObfuscationIgnore
    private static final Attributes.Name MODSIDE = new Attributes.Name("ModSide");
    @ObfuscationIgnore
    private static String[] rootPlugins = new String[]{"cpw.mods.fml.relauncher.FMLCorePlugin", "fgm.iIIIiiiIiIIIiiIiIIIiIIiIiIiiiIiIiIIIiiiiiiIIiIIIiIiIIIiIiiiiiiiI"};
    @ObfuscationIgnore
    private static List<String> loadedCoremods = Lists.newArrayList();
    @ObfuscationIgnore
    private static List<CoreModManager$FMLPluginWrapper> loadPlugins;
    @ObfuscationIgnore
    private static boolean deobfuscatedEnvironment;
    @ObfuscationIgnore
    private static FMLTweaker tweaker;
    @ObfuscationIgnore
    private static File mcDir;
    @ObfuscationIgnore
    private static List<String> reparsedCoremods;
    @ObfuscationIgnore
    private static List<String> accessTransformers;
    @ObfuscationIgnore
    private static Method ADDURL;
    @ObfuscationIgnore
    private static Map<String, Integer> tweakSorting;

    @ObfuscationIgnore
    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader, FMLTweaker tweaker) {
        Object object;
        CoreModManager.mcDir = mcDir;
        CoreModManager.tweaker = tweaker;
        try {
            object = classLoader.getClassBytes("fgm.IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii");
            if (object != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscatedEnvironment = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!deobfuscatedEnvironment) {
            FMLRelaunchLog.fine("Enabling runtime deobfuscation", new Object[0]);
        }
        tweaker.injectCascadingTweak("cpw.mods.fml.common.launcher.FMLInjectionAndSortingTweaker");
        FMLRelaunchLog.info("Skipping PatchingTransformer registration - using direct source modifications", new Object[0]);
        loadPlugins = new ArrayList<CoreModManager$FMLPluginWrapper>();
        for (byte by : (Object)rootPlugins) {
            CoreModManager.loadCoreMod(classLoader, (String)by, new File(FMLTweaker.getJarLocation()));
        }
        if (loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLRelaunchLog.fine("All fundamental core mods are successfully located", new Object[0]);
        object = System.getProperty("fml.coreMods.load", "");
        for (String string : ((String)object).split(",")) {
            if (string.isEmpty()) continue;
            FMLRelaunchLog.info("Found a command line coremod : %s", string);
            CoreModManager.loadCoreMod(classLoader, string, null);
        }
        CoreModManager.discoverCoreMods(mcDir, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ObfuscationIgnore
    private static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader) {
        void var8_15;
        File[] fileArray;
        File file;
        File[] fileArray2;
        ModListHelper.parseModList(mcDir);
        FMLRelaunchLog.fine("Discovering coremods", new Object[0]);
        File file2 = CoreModManager.setupCoreModDir(mcDir);
        CoreModManager$1 coreModManager$1 = new CoreModManager$1();
        CoreModManager$2 coreModManager$2 = new CoreModManager$2();
        File[] fileArray3 = file2.listFiles(coreModManager$2);
        if (fileArray3 != null && fileArray3.length > 0) {
            void object;
            FMLRelaunchLog.severe("FML has detected several badly downloaded jar files,  which have been named as zip files. You probably need to download them again, or they may not work properly", new Object[0]);
            fileArray2 = fileArray3;
            int n = fileArray2.length;
            boolean i = false;
            while (object < n) {
                file = fileArray2[object];
                FMLRelaunchLog.severe("Problem file : %s", file.getName());
                ++object;
            }
        }
        if ((fileArray = file2.listFiles((FileFilter)(fileArray2 = new CoreModManager$3()))) != null && fileArray.length > 0) {
            FMLRelaunchLog.log.getLogger().log(Level.FATAL, "There appear to be jars extracted into the mods directory. This is VERY BAD and will almost NEVER WORK WELL");
            FMLRelaunchLog.log.getLogger().log(Level.FATAL, "You should place original jars only in the mods directory. NEVER extract them to the mods directory.");
            FMLRelaunchLog.log.getLogger().log(Level.FATAL, "The directories below appear to be extracted jar files. Fix this before you continue.");
            for (File file3 : fileArray) {
                FMLRelaunchLog.log.getLogger().log(Level.FATAL, "Directory {} contains {}", (Object)file3.getName(), Arrays.asList(new File(file3, "META-INF").list()));
            }
            RuntimeException runtimeException = new RuntimeException("Extracted mod jars found, loading will NOT continue");
            try {
                File file3;
                Class<?> clazz = classLoader.loadClass("b");
                Object object = clazz.getMethod("a", Throwable.class, String.class).invoke(null, runtimeException, "FML has discovered extracted jar files in the mods directory.\nThis breaks mod loading functionality completely.\nRemove the directories and replace with the jar files originally provided.");
                file3 = new File(new File(file2.getParentFile(), "crash-reports"), String.format("fml-crash-%1$tY-%1$tm-%1$td_%1$tT.txt", Calendar.getInstance()));
                clazz.getMethod("a", File.class).invoke(object, file3);
                System.out.println("#@!@# FML has crashed the game deliberately. Crash report saved to: #@!@# " + file3.getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw runtimeException;
        }
        Object[] objectArray = file2.listFiles(coreModManager$1);
        file = new File(file2, FMLInjectionData.mccversion);
        if (file.isDirectory()) {
            Object[] objectArray2 = file.listFiles(coreModManager$1);
            File[] fileArray4 = (File[])ObjectArrays.concat((Object[])objectArray, (Object[])objectArray2, File.class);
        }
        File[] fileArray6 = (File[])ObjectArrays.concat((Object[])var8_15, (Object[])ModListHelper.additionalMods.values().toArray(new File[0]), File.class);
        fileArray6 = FileListHelper.sortFileList(fileArray6);
        for (File file4 : fileArray6) {
            String string;
            Object object;
            Attributes attributes;
            FMLRelaunchLog.fine("Examining for coremod candidacy %s", file4.getName());
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file4);
                if (jarFile.getManifest() == null) continue;
                ModAccessTransformer.addJar(jarFile);
                attributes = jarFile.getManifest().getMainAttributes();
            }
            catch (IOException iOException) {
                FMLRelaunchLog.log(Level.ERROR, iOException, "Unable to read the jar file %s - ignoring", file4.getName());
                continue;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string2 = attributes.getValue("TweakClass");
            if (string2 != null) {
                FMLRelaunchLog.info("Loading tweaker %s from %s", string2, file4.getName());
                object = Ints.tryParse((String)Strings.nullToEmpty((String)attributes.getValue("TweakOrder")));
                object = object == null ? Integer.valueOf(0) : object;
                CoreModManager.handleCascadingTweak(file4, jarFile, string2, classLoader, (Integer)object);
                loadedCoremods.add(file4.getName());
                continue;
            }
            Object object2 = object = attributes.containsKey(MODTYPE) ? Arrays.asList(attributes.getValue(MODTYPE).split(",")) : ImmutableList.of((Object)"FML");
            if (!object.contains("FML")) {
                FMLRelaunchLog.fine("Adding %s to the list of things to skip. It is not an FML mod,  it has types %s", file4.getName(), object);
                loadedCoremods.add(file4.getName());
                continue;
            }
            String string3 = string = attributes.containsKey(MODSIDE) ? attributes.getValue(MODSIDE) : "BOTH";
            if (!"BOTH".equals(string) && !FMLLaunchHandler.side.name().equals(string)) {
                FMLRelaunchLog.fine("Mod %s has ModSide meta-inf value %s, and we're %s. It will be ignored", file4.getName(), string, FMLLaunchHandler.side.name());
                loadedCoremods.add(file4.getName());
                continue;
            }
            String string4 = attributes.getValue("FMLCorePlugin");
            if (string4 == null) {
                FMLRelaunchLog.fine("Not found coremod data in %s", file4.getName());
                continue;
            }
            try {
                classLoader.addURL(file4.toURI().toURL());
                if (!attributes.containsKey(COREMODCONTAINSFMLMOD)) {
                    FMLRelaunchLog.finer("Adding %s to the list of known coremods, it will not be examined again", file4.getName());
                    loadedCoremods.add(file4.getName());
                } else {
                    FMLRelaunchLog.finer("Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", file4.getName());
                    reparsedCoremods.add(file4.getName());
                }
            }
            catch (MalformedURLException malformedURLException) {
                FMLRelaunchLog.log(Level.ERROR, malformedURLException, "Unable to convert file into a URL. weird", new Object[0]);
                continue;
            }
            CoreModManager.loadCoreMod(classLoader, string4, file4);
        }
    }

    @ObfuscationIgnore
    private static void handleCascadingTweak(File coreMod, JarFile jar, String cascadedTweaker, LaunchClassLoader classLoader, Integer sortingOrder) {
        try {
            if (ADDURL == null) {
                ADDURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                ADDURL.setAccessible(true);
            }
            ADDURL.invoke((Object)classLoader.getClass().getClassLoader(), coreMod.toURI().toURL());
            classLoader.addURL(coreMod.toURI().toURL());
            tweaker.injectCascadingTweak(cascadedTweaker);
            tweakSorting.put(cascadedTweaker, sortingOrder);
        }
        catch (Exception exception) {
            FMLRelaunchLog.log(Level.INFO, exception, "There was a problem trying to load the mod dir tweaker %s", coreMod.getAbsolutePath());
        }
    }

    @ObfuscationIgnore
    private static File setupCoreModDir(File mcDir) {
        File file = new File(mcDir, "mods");
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), iOException);
        }
        if (!file.exists()) {
            file.mkdir();
        } else if (file.exists() && !file.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return file;
    }

    @ObfuscationIgnore
    public static List<String> getLoadedCoremods() {
        return loadedCoremods;
    }

    @ObfuscationIgnore
    public static List<String> getReparseableCoremods() {
        return reparsedCoremods;
    }

    @ObfuscationIgnore
    private static CoreModManager$FMLPluginWrapper loadCoreMod(LaunchClassLoader classLoader, String coreModClass, File location) {
        String string = coreModClass.substring(coreModClass.lastIndexOf(46) + 1);
        try {
            IFMLLoadingPlugin$SortingIndex iFMLLoadingPlugin$SortingIndex;
            FMLRelaunchLog.fine("Instantiating coremod class %s", string);
            classLoader.addTransformerExclusion(coreModClass);
            Class<?> clazz = Class.forName(coreModClass, true, classLoader);
            IFMLLoadingPlugin$Name iFMLLoadingPlugin$Name = clazz.getAnnotation(IFMLLoadingPlugin$Name.class);
            if (iFMLLoadingPlugin$Name != null && !Strings.isNullOrEmpty((String)iFMLLoadingPlugin$Name.value())) {
                string = iFMLLoadingPlugin$Name.value();
                FMLRelaunchLog.finer("coremod named %s is loading", string);
            }
            IFMLLoadingPlugin$MCVersion iFMLLoadingPlugin$MCVersion = clazz.getAnnotation(IFMLLoadingPlugin$MCVersion.class);
            if (!Arrays.asList(rootPlugins).contains(coreModClass) && (iFMLLoadingPlugin$MCVersion == null || Strings.isNullOrEmpty((String)iFMLLoadingPlugin$MCVersion.value()))) {
                FMLRelaunchLog.log(Level.WARN, "The coremod %s does not have a MCVersion annotation, it may cause issues with this version of Minecraft", coreModClass);
            } else {
                if (iFMLLoadingPlugin$MCVersion != null && !FMLInjectionData.mccversion.equals(iFMLLoadingPlugin$MCVersion.value())) {
                    FMLRelaunchLog.log(Level.ERROR, "The coremod %s is requesting minecraft version %s and minecraft is %s. It will be ignored.", coreModClass, iFMLLoadingPlugin$MCVersion.value(), FMLInjectionData.mccversion);
                    return null;
                }
                if (iFMLLoadingPlugin$MCVersion != null) {
                    FMLRelaunchLog.log(Level.DEBUG, "The coremod %s requested minecraft version %s and minecraft is %s. It will be loaded.", coreModClass, iFMLLoadingPlugin$MCVersion.value(), FMLInjectionData.mccversion);
                }
            }
            IFMLLoadingPlugin$TransformerExclusions iFMLLoadingPlugin$TransformerExclusions = clazz.getAnnotation(IFMLLoadingPlugin$TransformerExclusions.class);
            if (iFMLLoadingPlugin$TransformerExclusions != null) {
                for (String string2 : iFMLLoadingPlugin$TransformerExclusions.value()) {
                    classLoader.addTransformerExclusion(string2);
                }
            }
            IFMLLoadingPlugin$DependsOn iFMLLoadingPlugin$DependsOn = clazz.getAnnotation(IFMLLoadingPlugin$DependsOn.class);
            String[] stringArray = new String[]{};
            if (iFMLLoadingPlugin$DependsOn != null) {
                stringArray = iFMLLoadingPlugin$DependsOn.value();
            }
            int n = (iFMLLoadingPlugin$SortingIndex = clazz.getAnnotation(IFMLLoadingPlugin$SortingIndex.class)) != null ? iFMLLoadingPlugin$SortingIndex.value() : 0;
            IFMLLoadingPlugin iFMLLoadingPlugin = (IFMLLoadingPlugin)clazz.newInstance();
            String string3 = iFMLLoadingPlugin.getAccessTransformerClass();
            if (string3 != null) {
                FMLRelaunchLog.log(Level.DEBUG, "Added access transformer class %s to enqueued access transformers", string3);
                accessTransformers.add(string3);
            }
            CoreModManager$FMLPluginWrapper coreModManager$FMLPluginWrapper = new CoreModManager$FMLPluginWrapper(string, iFMLLoadingPlugin, location, n, stringArray);
            loadPlugins.add(coreModManager$FMLPluginWrapper);
            FMLRelaunchLog.fine("Enqueued coremod %s", string);
            return coreModManager$FMLPluginWrapper;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!Lists.newArrayList((Object[])rootPlugins).contains(coreModClass)) {
                FMLRelaunchLog.log(Level.ERROR, classNotFoundException, "Coremod %s: Unable to class load the plugin %s", string, coreModClass);
            } else {
                FMLRelaunchLog.fine("Skipping root plugin %s", coreModClass);
            }
        }
        catch (ClassCastException classCastException) {
            FMLRelaunchLog.log(Level.ERROR, classCastException, "Coremod %s: The plugin %s is not an implementor of IFMLLoadingPlugin", string, coreModClass);
        }
        catch (InstantiationException instantiationException) {
            FMLRelaunchLog.log(Level.ERROR, instantiationException, "Coremod %s: The plugin class %s was not instantiable", string, coreModClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            FMLRelaunchLog.log(Level.ERROR, illegalAccessException, "Coremod %s: The plugin class %s was not accessible", string, coreModClass);
        }
        return null;
    }

    @ObfuscationIgnore
    private static void sortCoreMods() {
        TopologicalSort$DirectedGraph<CoreModManager$FMLPluginWrapper> topologicalSort$DirectedGraph = new TopologicalSort$DirectedGraph<CoreModManager$FMLPluginWrapper>();
        HashMap hashMap = Maps.newHashMap();
        for (CoreModManager$FMLPluginWrapper coreModManager$FMLPluginWrapper : loadPlugins) {
            topologicalSort$DirectedGraph.addNode(coreModManager$FMLPluginWrapper);
            hashMap.put(coreModManager$FMLPluginWrapper.name, coreModManager$FMLPluginWrapper);
        }
        for (CoreModManager$FMLPluginWrapper coreModManager$FMLPluginWrapper : loadPlugins) {
            for (String string : coreModManager$FMLPluginWrapper.predepends) {
                if (!hashMap.containsKey(string)) {
                    FMLRelaunchLog.log(Level.ERROR, "Missing coremod dependency - the coremod %s depends on coremod %s which isn't present.", coreModManager$FMLPluginWrapper.name, string);
                    throw new RuntimeException();
                }
                topologicalSort$DirectedGraph.addEdge(coreModManager$FMLPluginWrapper, (CoreModManager$FMLPluginWrapper)hashMap.get(string));
            }
        }
        try {
            loadPlugins = TopologicalSort.topologicalSort(topologicalSort$DirectedGraph);
            FMLRelaunchLog.fine("Sorted coremod list %s", loadPlugins);
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "There was a problem performing the coremod sort", new Object[0]);
            throw Throwables.propagate((Throwable)exception);
        }
    }

    @ObfuscationIgnore
    public static void injectTransformers(LaunchClassLoader classLoader) {
        Launch.blackboard.put("fml.deobfuscatedEnvironment", deobfuscatedEnvironment);
        tweaker.injectCascadingTweak("cpw.mods.fml.common.launcher.FMLDeobfTweaker");
        tweakSorting.put("cpw.mods.fml.common.launcher.FMLDeobfTweaker", 1000);
    }

    @ObfuscationIgnore
    public static void injectCoreModTweaks(FMLInjectionAndSortingTweaker fmlInjectionAndSortingTweaker) {
        List list = (List)Launch.blackboard.get("Tweaks");
        list.add(0, fmlInjectionAndSortingTweaker);
        for (CoreModManager$FMLPluginWrapper coreModManager$FMLPluginWrapper : loadPlugins) {
            list.add(coreModManager$FMLPluginWrapper);
        }
    }

    @ObfuscationIgnore
    public static void sortTweakList() {
        List list = (List)Launch.blackboard.get("Tweaks");
        ITweaker[] iTweakerArray = list.toArray(new ITweaker[list.size()]);
        Arrays.sort(iTweakerArray, new CoreModManager$4());
        for (int i = 0; i < iTweakerArray.length; ++i) {
            list.set(i, iTweakerArray[i]);
        }
    }

    @ObfuscationIgnore
    public static List<String> getAccessTransformers() {
        return accessTransformers;
    }

    static {
        reparsedCoremods = Lists.newArrayList();
        accessTransformers = Lists.newArrayList();
        tweakSorting = Maps.newHashMap();
    }
}

