/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.launcher.FMLTweaker;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLLaunchHandler {
    private static FMLLaunchHandler INSTANCE;
    static Side side;
    private LaunchClassLoader classLoader;
    private FMLTweaker tweaker;
    private File minecraftHome;

    public static void configureForClientLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupClient();
    }

    public static void configureForServerLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupServer();
    }

    private static FMLLaunchHandler instance(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        if (INSTANCE == null) {
            INSTANCE = new FMLLaunchHandler(launchLoader, tweaker);
        }
        return INSTANCE;
    }

    private FMLLaunchHandler(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        this.classLoader = launchLoader;
        this.tweaker = tweaker;
        this.minecraftHome = tweaker.getGameDir();
        this.classLoader.addClassLoaderExclusion("cpw.mods.fml.relauncher.");
        this.classLoader.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.deobf.");
        this.classLoader.addTransformerExclusion("cpw.mods.fml.common.patcher.");
    }

    private void setupClient() {
        FMLRelaunchLog.side = Side.CLIENT;
        side = Side.CLIENT;
        this.setupHome();
    }

    private void setupServer() {
        FMLRelaunchLog.side = Side.SERVER;
        side = Side.SERVER;
        this.setupHome();
    }

    private void setupHome() {
        FMLInjectionData.build(this.minecraftHome, this.classLoader);
        FMLRelaunchLog.minecraftHome = this.minecraftHome;
        FMLRelaunchLog.info("Forge Mod Loader version %s.%s.%s.%s for Minecraft %s loading", FMLInjectionData.major, FMLInjectionData.minor, FMLInjectionData.rev, FMLInjectionData.build, FMLInjectionData.mccversion, FMLInjectionData.mcpversion);
        FMLRelaunchLog.info("Java is %s, version %s, running on %s:%s:%s, installed at %s", System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.home"));
        FMLRelaunchLog.fine("Java classpath at launch is %s", System.getProperty("java.class.path"));
        FMLRelaunchLog.fine("Java library path at launch is %s", System.getProperty("java.library.path"));
        try {
            CoreModManager.handleLaunch(this.minecraftHome, this.classLoader, this.tweaker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FMLRelaunchLog.log(Level.ERROR, throwable, "An error occurred trying to configure the minecraft home at %s for Forge Mod Loader", this.minecraftHome.getAbsolutePath());
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static Side side() {
        return side;
    }

    private void injectPostfixTransformers() {
        CoreModManager.injectTransformers(this.classLoader);
    }

    public static void appendCoreMods() {
        INSTANCE.injectPostfixTransformers();
    }
}

