/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.ModListHelper$JsonModList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ModListHelper {
    private static File mcDirectory;
    private static Set<File> visitedFiles;
    public static final Map<String, File> additionalMods;

    static void parseModList(File minecraftDirectory) {
        String string;
        FMLRelaunchLog.fine("Attempting to load commandline specified mods, relative to %s", minecraftDirectory.getAbsolutePath());
        mcDirectory = minecraftDirectory;
        Map map = (Map)Launch.blackboard.get("launchArgs");
        String string2 = (String)map.get("--modListFile");
        if (string2 != null) {
            ModListHelper.parseListFile(string2);
        }
        if ((string = (String)map.get("--mods")) != null) {
            String[] stringArray;
            for (String string3 : stringArray = string.split(",")) {
                ModListHelper.tryAddFile(string3, null, string3);
            }
        }
    }

    private static void parseListFile(String listFile) {
        File file;
        ModListHelper$JsonModList modListHelper$JsonModList;
        String string;
        File file2;
        try {
            file2 = new File(mcDirectory, listFile).getCanonicalFile();
        }
        catch (IOException iOException) {
            FMLRelaunchLog.log(Level.INFO, iOException, "Unable to canonicalize path %s relative to %s", listFile, mcDirectory.getAbsolutePath());
            return;
        }
        if (!file2.exists()) {
            FMLRelaunchLog.info("Failed to find modList file %s", file2.getAbsolutePath());
            return;
        }
        if (visitedFiles.contains(file2)) {
            FMLRelaunchLog.severe("There appears to be a loop in the modListFile hierarchy. You shouldn't do this!", new Object[0]);
            throw new RuntimeException("Loop detected, impossible to load modlistfile");
        }
        try {
            string = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException iOException) {
            FMLRelaunchLog.log(Level.INFO, iOException, "Failed to read modList json file %s.", listFile);
            return;
        }
        Gson gson = new Gson();
        try {
            modListHelper$JsonModList = (ModListHelper$JsonModList)gson.fromJson(string, ModListHelper$JsonModList.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            FMLRelaunchLog.log(Level.INFO, jsonSyntaxException, "Failed to parse modList json file %s.", listFile);
            return;
        }
        visitedFiles.add(file2);
        if (modListHelper$JsonModList.parentList != null) {
            ModListHelper.parseListFile(modListHelper$JsonModList.parentList);
        }
        if (!(file = new File(modListHelper$JsonModList.repositoryRoot)).exists()) {
            FMLRelaunchLog.info("Failed to find the specified repository root %s", modListHelper$JsonModList.repositoryRoot);
            return;
        }
        for (String string2 : modListHelper$JsonModList.modRef) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String[] stringArray = string2.split(":");
            stringBuilder.append(stringArray[0].replace('.', File.separatorChar));
            stringBuilder2.append(stringArray[0]);
            stringBuilder.append(File.separatorChar);
            stringBuilder.append(stringArray[1]).append(File.separatorChar);
            stringBuilder2.append(":").append(stringArray[1]);
            stringBuilder.append(stringArray[2]).append(File.separatorChar);
            stringBuilder.append(stringArray[1]).append('-').append(stringArray[2]);
            if (stringArray.length == 4) {
                stringBuilder.append('-').append(stringArray[3]);
                stringBuilder2.append(":").append(stringArray[3]);
            }
            stringBuilder.append(".jar");
            ModListHelper.tryAddFile(stringBuilder.toString(), file, stringBuilder2.toString());
        }
    }

    private static void tryAddFile(String modFileName, File repoRoot, String descriptor) {
        File file;
        File file2 = file = repoRoot != null ? new File(repoRoot, modFileName) : new File(mcDirectory, modFileName);
        if (!file.exists()) {
            FMLRelaunchLog.info("Failed to find mod file %s (%s)", descriptor, file.getAbsolutePath());
        } else {
            FMLRelaunchLog.fine("Adding %s (%s) to the mod list", descriptor, file.getAbsolutePath());
            additionalMods.put(descriptor, file);
        }
    }

    static {
        visitedFiles = Sets.newHashSet();
        additionalMods = Maps.newLinkedHashMap();
    }
}

