/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.ReflectionHelper$UnableToAccessFieldException;
import cpw.mods.fml.relauncher.ReflectionHelper$UnableToFindClassException;
import cpw.mods.fml.relauncher.ReflectionHelper$UnableToFindFieldException;
import cpw.mods.fml.relauncher.ReflectionHelper$UnableToFindMethodException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ReflectionHelper {
    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception exception = null;
        for (String string : fieldNames) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return field;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new ReflectionHelper$UnableToFindFieldException(fieldNames, exception);
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            Field field = classToAccess.getDeclaredFields()[fieldIndex];
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception exception) {
            throw new ReflectionHelper$UnableToAccessFieldException(new String[0], exception);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return (T)ReflectionHelper.findField(classToAccess, fieldNames).get(instance);
        }
        catch (Exception exception) {
            throw new ReflectionHelper$UnableToAccessFieldException(fieldNames, exception);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field field = classToAccess.getDeclaredFields()[fieldIndex];
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception exception) {
            throw new ReflectionHelper$UnableToAccessFieldException(new String[0], exception);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.findField(classToAccess, fieldNames).set(instance, value);
        }
        catch (Exception exception) {
            throw new ReflectionHelper$UnableToAccessFieldException(fieldNames, exception);
        }
    }

    public static Class<? super Object> getClass(ClassLoader loader, String ... classNames) {
        Exception exception = null;
        for (String string : classNames) {
            try {
                return Class.forName(string, false, loader);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new ReflectionHelper$UnableToFindClassException(classNames, exception);
    }

    public static <E> Method findMethod(Class<? super E> clazz, E instance, String[] methodNames, Class<?> ... methodTypes) {
        Exception exception = null;
        for (String string : methodNames) {
            try {
                Method method = clazz.getDeclaredMethod(string, methodTypes);
                method.setAccessible(true);
                return method;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new ReflectionHelper$UnableToFindMethodException(methodNames, exception);
    }
}

