/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.repackage.com.nothome.delta;

import cpw.mods.fml.repackage.com.nothome.delta.Checksum;
import cpw.mods.fml.repackage.com.nothome.delta.Delta;
import cpw.mods.fml.repackage.com.nothome.delta.Delta$SourceState;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

class Delta$TargetState {
    private ReadableByteChannel c;
    private ByteBuffer tbuf = ByteBuffer.allocate(this.blocksize());
    private ByteBuffer sbuf = ByteBuffer.allocate(this.blocksize());
    private long hash;
    private boolean hashReset = true;
    private boolean eof;
    final /* synthetic */ Delta this$0;

    Delta$TargetState(Delta this$0, InputStream targetIS) {
        this.this$0 = this$0;
        this.c = Channels.newChannel(targetIS);
        this.tbuf.limit(0);
    }

    private int blocksize() {
        return Math.min(16384, this.this$0.S * 4);
    }

    public int find(Delta$SourceState source) {
        if (this.eof) {
            return -1;
        }
        this.sbuf.clear();
        this.sbuf.limit(0);
        if (this.hashReset) {
            this.this$0.debug("hashReset");
            while (this.tbuf.remaining() < this.this$0.S) {
                this.tbuf.compact();
                int n = this.c.read(this.tbuf);
                this.tbuf.flip();
                if (n != -1) continue;
                this.this$0.debug("target ending");
                return -1;
            }
            this.hash = Checksum.queryChecksum(this.tbuf, this.this$0.S);
            this.hashReset = false;
        }
        return source.checksum.findChecksumIndex(this.hash);
    }

    public boolean eof() {
        return this.eof;
    }

    public int read() {
        if (this.tbuf.remaining() <= this.this$0.S) {
            this.readMore();
            if (!this.tbuf.hasRemaining()) {
                this.eof = true;
                return -1;
            }
        }
        byte by = this.tbuf.get();
        if (this.tbuf.remaining() >= this.this$0.S) {
            byte by2 = this.tbuf.get(this.tbuf.position() + this.this$0.S - 1);
            this.hash = Checksum.incrementChecksum(this.hash, by, by2, this.this$0.S);
        } else {
            this.this$0.debug("out of char");
        }
        return by & 0xFF;
    }

    public int longestMatch(Delta$SourceState source) {
        this.this$0.debug("longestMatch");
        int n = 0;
        this.hashReset = true;
        while (true) {
            if (!this.sbuf.hasRemaining()) {
                this.sbuf.clear();
                int n2 = source.source.read(this.sbuf);
                this.sbuf.flip();
                if (n2 == -1) {
                    return n;
                }
            }
            if (!this.tbuf.hasRemaining()) {
                this.readMore();
                if (!this.tbuf.hasRemaining()) {
                    this.this$0.debug("target ending");
                    this.eof = true;
                    return n;
                }
            }
            if (this.sbuf.get() != this.tbuf.get()) {
                this.tbuf.position(this.tbuf.position() - 1);
                return n;
            }
            ++n;
        }
    }

    private void readMore() {
        this.tbuf.compact();
        this.c.read(this.tbuf);
        this.tbuf.flip();
    }

    void hash() {
        this.hash = Checksum.queryChecksum(this.tbuf, this.this$0.S);
    }

    public String toString() {
        return "Target[ targetBuff=" + this.dump() + " sourceBuff=" + String.valueOf(this.sbuf) + " hashf=" + this.hash + " eof=" + this.eof + "]";
    }

    private String dump() {
        return this.dump(this.tbuf);
    }

    private String dump(ByteBuffer bb) {
        return this.getTextDump(bb);
    }

    private void append(StringBuffer sb, int value) {
        char c = (char)(value >> 4 & 0xF);
        char c2 = (char)(value & 0xF);
        sb.append(Character.forDigit(c, 16));
        sb.append(Character.forDigit(c2, 16));
    }

    public String getTextDump(ByteBuffer bb) {
        StringBuffer stringBuffer = new StringBuffer(bb.remaining() * 2);
        bb.mark();
        while (bb.hasRemaining()) {
            byte by = bb.get();
            if (by > 32 && by < 127) {
                stringBuffer.append(" ").append((char)by);
                continue;
            }
            this.append(stringBuffer, by);
        }
        bb.reset();
        return stringBuffer.toString();
    }
}

