/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.repackage.com.nothome.delta;

import cpw.mods.fml.repackage.com.nothome.delta.ByteBufferSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.DebugDiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.Delta$SourceState;
import cpw.mods.fml.repackage.com.nothome.delta.Delta$TargetState;
import cpw.mods.fml.repackage.com.nothome.delta.DiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.GDiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.RandomAccessFileSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.SeekableSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class Delta {
    static final boolean debug = false;
    public static final int DEFAULT_CHUNK_SIZE = 16;
    private int S;
    private Delta$SourceState source;
    private Delta$TargetState target;
    private DiffWriter output;

    public Delta() {
        this.setChunkSize(16);
    }

    public void setChunkSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.S = size;
    }

    public void compute(byte[] source, byte[] target, OutputStream output) {
        this.compute(new ByteBufferSeekableSource(source), (InputStream)new ByteArrayInputStream(target), (DiffWriter)new GDiffWriter(output));
    }

    public byte[] compute(byte[] source, byte[] target) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.compute(source, target, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void compute(byte[] sourceBytes, InputStream inputStream, DiffWriter diffWriter) {
        this.compute(new ByteBufferSeekableSource(sourceBytes), inputStream, diffWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(File sourceFile, File targetFile, DiffWriter output) {
        RandomAccessFileSeekableSource randomAccessFileSeekableSource = new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r"));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(targetFile));
        try {
            this.compute(randomAccessFileSeekableSource, (InputStream)bufferedInputStream, output);
        }
        finally {
            randomAccessFileSeekableSource.close();
            ((InputStream)bufferedInputStream).close();
        }
    }

    public void compute(SeekableSource seekSource, InputStream targetIS, DiffWriter output) {
        this.source = new Delta$SourceState(this, seekSource);
        this.target = new Delta$TargetState(this, targetIS);
        this.output = output;
        while (!this.target.eof()) {
            this.debug("!target.eof()");
            int n = this.target.find(this.source);
            if (n != -1) {
                long l = (long)n * (long)this.S;
                this.source.seek(l);
                int n2 = this.target.longestMatch(this.source);
                if (n2 >= this.S) {
                    output.addCopy(l, n2);
                    continue;
                }
                this.target.tbuf.position(this.target.tbuf.position() - n2);
                this.addData();
                continue;
            }
            this.addData();
        }
        output.close();
    }

    private void addData() {
        int n = this.target.read();
        if (n == -1) {
            return;
        }
        this.output.addData((byte)n);
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.println("usage Delta [-d] source target [output]");
            System.err.println("either -d or an output filename must be specified.");
            System.err.println("aborting..");
            return;
        }
        DiffWriter diffWriter = null;
        File file = null;
        File file2 = null;
        if (argv[0].equals("-d")) {
            file = new File(argv[1]);
            file2 = new File(argv[2]);
            diffWriter = new DebugDiffWriter();
        } else {
            file = new File(argv[0]);
            file2 = new File(argv[1]);
            diffWriter = new GDiffWriter(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(argv[2])))));
        }
        if (file.length() > Integer.MAX_VALUE || file2.length() > Integer.MAX_VALUE) {
            System.err.println("source or target is too large, max length is 2147483647");
            System.err.println("aborting..");
            diffWriter.close();
            return;
        }
        Delta delta = new Delta();
        delta.compute(file, file2, diffWriter);
        diffWriter.flush();
        diffWriter.close();
    }

    private void debug(String s) {
    }
}

