/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.repackage.com.nothome.delta;

import cpw.mods.fml.repackage.com.nothome.delta.ByteBufferSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.PatchException;
import cpw.mods.fml.repackage.com.nothome.delta.RandomAccessFileSeekableSource;
import cpw.mods.fml.repackage.com.nothome.delta.SeekableSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class GDiffPatcher {
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private byte[] buf2 = this.buf.array();

    public void patch(File sourceFile, File patchFile, File outputFile) {
        RandomAccessFileSeekableSource randomAccessFileSeekableSource = new RandomAccessFileSeekableSource(new RandomAccessFile(sourceFile, "r"));
        FileInputStream fileInputStream = new FileInputStream(patchFile);
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        try {
            this.patch(randomAccessFileSeekableSource, (InputStream)fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            randomAccessFileSeekableSource.close();
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void patch(byte[] source, InputStream patch, OutputStream output) {
        this.patch(new ByteBufferSeekableSource(source), patch, output);
    }

    public byte[] patch(byte[] source, byte[] patch) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.patch(source, (InputStream)new ByteArrayInputStream(patch), (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void patch(SeekableSource source, InputStream patch, OutputStream out) {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        DataInputStream dataInputStream = new DataInputStream(patch);
        if (dataInputStream.readUnsignedByte() != 209 || dataInputStream.readUnsignedByte() != 255 || dataInputStream.readUnsignedByte() != 209 || dataInputStream.readUnsignedByte() != 255 || dataInputStream.readUnsignedByte() != 4) {
            throw new PatchException("magic string not found, aborting!");
        }
        block11: while ((n = dataInputStream.readUnsignedByte()) != 0) {
            if (n <= 246) {
                this.append(n, dataInputStream, dataOutputStream);
                continue;
            }
            switch (n) {
                case 247: {
                    int n2 = dataInputStream.readUnsignedShort();
                    this.append(n2, dataInputStream, dataOutputStream);
                    continue block11;
                }
                case 248: {
                    int n2 = dataInputStream.readInt();
                    this.append(n2, dataInputStream, dataOutputStream);
                    continue block11;
                }
                case 249: {
                    int n3 = dataInputStream.readUnsignedShort();
                    int n2 = dataInputStream.readUnsignedByte();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 250: {
                    int n3 = dataInputStream.readUnsignedShort();
                    int n2 = dataInputStream.readUnsignedShort();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 251: {
                    int n3 = dataInputStream.readUnsignedShort();
                    int n2 = dataInputStream.readInt();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 252: {
                    int n3 = dataInputStream.readInt();
                    int n2 = dataInputStream.readUnsignedByte();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 253: {
                    int n3 = dataInputStream.readInt();
                    int n2 = dataInputStream.readUnsignedShort();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 254: {
                    int n3 = dataInputStream.readInt();
                    int n2 = dataInputStream.readInt();
                    this.copy(n3, n2, source, dataOutputStream);
                    continue block11;
                }
                case 255: {
                    long l = dataInputStream.readLong();
                    int n2 = dataInputStream.readInt();
                    this.copy(l, n2, source, dataOutputStream);
                    continue block11;
                }
            }
            throw new IllegalStateException("command " + n);
        }
        dataOutputStream.flush();
    }

    private void copy(long offset, int length, SeekableSource source, OutputStream output) {
        source.seek(offset);
        while (length > 0) {
            int n = Math.min(this.buf.capacity(), length);
            this.buf.clear().limit(n);
            int n2 = source.read(this.buf);
            if (n2 == -1) {
                throw new EOFException("in copy " + offset + " " + length);
            }
            output.write(this.buf.array(), 0, n2);
            length -= n2;
        }
    }

    private void append(int length, InputStream patch, OutputStream output) {
        while (length > 0) {
            int n = Math.min(this.buf2.length, length);
            int n2 = patch.read(this.buf2, 0, n);
            if (n2 == -1) {
                throw new EOFException("cannot read " + length);
            }
            output.write(this.buf2, 0, n2);
            length -= n2;
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.println("usage GDiffPatch source patch output");
            System.err.println("aborting..");
            return;
        }
        try {
            File file = new File(argv[0]);
            File file2 = new File(argv[1]);
            File file3 = new File(argv[2]);
            if (file.length() > Integer.MAX_VALUE || file2.length() > Integer.MAX_VALUE) {
                System.err.println("source or patch is too large, max length is 2147483647");
                System.err.println("aborting..");
                return;
            }
            GDiffPatcher gDiffPatcher = new GDiffPatcher();
            gDiffPatcher.patch(file, file2, file3);
            System.out.println("finished patching file");
        }
        catch (Exception exception) {
            System.err.println("error while patching: " + String.valueOf(exception));
        }
    }
}

