/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class LaunchClassLoader
extends URLClassLoader {
    public static final int BUFFER_SIZE = 4096;
    private List<URL> sources;
    private ClassLoader parent = this.getClass().getClassLoader();
    private List<IClassTransformer> transformers = new ArrayList<IClassTransformer>(2);
    private Map<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private Set<String> invalidClasses = new HashSet<String>(1000);
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();
    private Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>(1000);
    private Set<String> negativeResourceCache = Collections.newSetFromMap(new ConcurrentHashMap());
    private IClassNameTransformer renameTransformer;
    private final ThreadLocal<byte[]> loadBuffer = new ThreadLocal();
    private static final String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false"));
    private static final boolean DEBUG_FINER = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingFiner", "false"));
    private static final boolean DEBUG_SAVE = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingSave", "false"));
    private static File tempFolder = null;

    public LaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
    }

    public void registerTransformer(String transformerClassName) {
        try {
            Class<?> clazz = this.loadClass(transformerClassName);
            IClassTransformer iClassTransformer = (IClassTransformer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.transformers.add(iClassTransformer);
            if (iClassTransformer instanceof IClassNameTransformer && this.renameTransformer == null) {
                this.renameTransformer = (IClassNameTransformer)((Object)iClassTransformer);
            }
        }
        catch (Exception exception) {
            LogWrapper.log(Level.ERROR, exception, "A critical problem occurred registering the ASM transformer class %s", transformerClassName);
        }
    }

    @Override
    public Class<?> findClass(String name) {
        if ("module-info".equals(name) || name.startsWith("META-INF.versions.")) {
            throw new ClassNotFoundException(name);
        }
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        return this.parent.loadClass(name);
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        if (tempFolder == null) {
            return;
        }
        File file = new File(tempFolder, transformedName.replace('.', File.separatorChar) + ".class");
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            LogWrapper.fine("Saving transformed class \"%s\" to \"%s\"", transformedName, file.getAbsolutePath().replace('\\', '/'));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(data);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            LogWrapper.log(Level.WARN, iOException, "Could not save transformed class \"%s\"", transformedName);
        }
    }

    private String untransformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.unmapClassName(name);
        }
        return name;
    }

    private String transformName(String name) {
        if (this.renameTransformer != null) {
            return this.renameTransformer.remapClassName(name);
        }
        return name;
    }

    private boolean isSealed(String path, Manifest manifest) {
        Attributes attributes = manifest.getAttributes(path);
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string == null && (attributes = manifest.getMainAttributes()) != null) {
            string = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        URL uRL = this.findResource(name);
        if (uRL != null) {
            try {
                return uRL.openConnection();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    private byte[] runTransformers(String name, String transformedName, byte[] basicClass) {
        if (DEBUG_FINER) {
            LogWrapper.finest("Beginning transform of {%s (%s)} Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
            for (IClassTransformer iClassTransformer : this.transformers) {
                String string = iClassTransformer.getClass().getName();
                LogWrapper.finest("Before Transformer {%s (%s)} %s: %d", name, transformedName, string, basicClass == null ? 0 : basicClass.length);
                basicClass = iClassTransformer.transform(name, transformedName, basicClass);
                LogWrapper.finest("After  Transformer {%s (%s)} %s: %d", name, transformedName, string, basicClass == null ? 0 : basicClass.length);
            }
            LogWrapper.finest("Ending transform of {%s (%s)} Start Length: %d", name, transformedName, basicClass == null ? 0 : basicClass.length);
        } else {
            for (IClassTransformer iClassTransformer : this.transformers) {
                basicClass = iClassTransformer.transform(name, transformedName, basicClass);
            }
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            byte[] byArray;
            int n;
            byte[] byArray2 = this.getOrCreateBuffer();
            int n2 = 0;
            while ((n = stream.read(byArray2, n2, byArray2.length - n2)) != -1) {
                if ((n2 += n) < byArray2.length - 1) continue;
                byArray = new byte[byArray2.length + 4096];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            return byArray;
        }
        catch (Throwable throwable) {
            LogWrapper.log(Level.WARN, throwable, "Problem loading class", new Object[0]);
            return new byte[0];
        }
    }

    private byte[] getOrCreateBuffer() {
        byte[] byArray = this.loadBuffer.get();
        if (byArray == null) {
            this.loadBuffer.set(new byte[4096]);
            byArray = this.loadBuffer.get();
        }
        return byArray;
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    public void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) {
        URL uRL;
        byte[] byArray;
        block9: {
            byte[] byArray2;
            if (this.negativeResourceCache.contains(name)) {
                return null;
            }
            if (this.resourceCache.containsKey(name)) {
                return this.resourceCache.get(name);
            }
            if (name.indexOf(46) == -1) {
                for (String string : RESERVED_NAMES) {
                    if (!name.toUpperCase(Locale.ENGLISH).startsWith(string) || (byArray = this.getClassBytes("_" + name)) == null) continue;
                    this.resourceCache.put(name, byArray);
                    return byArray;
                }
            }
            Closeable closeable = null;
            try {
                String string = name.replace('.', '/').concat(".class");
                uRL = this.findResource(string);
                if (uRL != null) break block9;
                if (DEBUG) {
                    LogWrapper.finest("Failed to find class resource %s", string);
                }
                this.negativeResourceCache.add(name);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                LaunchClassLoader.closeSilently(closeable);
                throw throwable;
            }
            LaunchClassLoader.closeSilently(closeable);
            return byArray2;
        }
        InputStream inputStream = uRL.openStream();
        if (DEBUG) {
            LogWrapper.finest("Loading class %s from resource %s", name, uRL.toString());
        }
        byte[] byArray3 = this.readFully(inputStream);
        this.resourceCache.put(name, byArray3);
        byArray = byArray3;
        LaunchClassLoader.closeSilently(inputStream);
        return byArray;
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void clearNegativeEntries(Set<String> entriesToClear) {
        this.negativeResourceCache.removeAll(entriesToClear);
    }
}

