/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper.injector;

import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.lwjglx.opengl.Display;

public class VanillaTweakInjector
implements IClassTransformer {
    @Override
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!"fgm.iiIiIiIiiIIiiiiIiIiiiiiiiiIiiiIIIIIIIiiiIiIIiIIIiIIIiiiIiiIiiiII".equals(name)) {
            return bytes;
        }
        return null;
    }

    public static File inject() {
        System.out.println("Turning off ImageIO disk-caching");
        ImageIO.setUseCache(false);
        VanillaTweakInjector.loadIconsOnFrames();
        System.out.println("Setting gameDir to: " + String.valueOf(Launch.minecraftHome));
        return Launch.minecraftHome;
    }

    public static void loadIconsOnFrames() {
        try {
            File file = new File(Launch.assetsDir, "icons/icon_16x16.png");
            File file2 = new File(Launch.assetsDir, "icons/icon_32x32.png");
            System.out.println("Loading current icons for window from: " + String.valueOf(file) + " and " + String.valueOf(file2));
            Display.setIcon(new ByteBuffer[]{VanillaTweakInjector.loadIcon(file), VanillaTweakInjector.loadIcon(file2)});
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                List<Image> list = Arrays.asList(ImageIO.read(file), ImageIO.read(file2));
                for (Frame frame : frameArray) {
                    try {
                        frame.setIconImages(list);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static ByteBuffer loadIcon(File iconFile) {
        BufferedImage bufferedImage = ImageIO.read(iconFile);
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * nArray.length);
        for (int n : nArray) {
            byteBuffer.putInt(n << 8 | n >> 24 & 0xFF);
        }
        byteBuffer.flip();
        return byteBuffer;
    }
}

