/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.IntBuffer;
import org.lwjglx.input.Cursor$CursorElement;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final Cursor$CursorElement[] cursors = null;
    private int index;
    private boolean destroyed;

    public Cursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
    }

    public static int getMinCursorSize() {
        return 0;
    }

    public static int getMaxCursorSize() {
        return 0;
    }

    public static int getCapabilities() {
        return 0;
    }

    private static Cursor$CursorElement[] createCursors(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        return null;
    }

    private static void convertARGBtoABGR(IntBuffer imageBuffer) {
        for (int i = 0; i < imageBuffer.limit(); ++i) {
            int n = imageBuffer.get(i);
            byte by = (byte)(n >>> 24);
            byte by2 = (byte)(n >>> 16);
            byte by3 = (byte)(n >>> 8);
            byte by4 = (byte)n;
            int n2 = ((by & 0xFF) << 24) + ((by4 & 0xFF) << 16) + ((by3 & 0xFF) << 8) + (by2 & 0xFF);
            imageBuffer.put(i, n2);
        }
    }

    private static void flipImages(int width, int height, int numImages, IntBuffer images, IntBuffer images_copy) {
        for (int i = 0; i < numImages; ++i) {
            int n = i * width * height;
            Cursor.flipImage(width, height, n, images, images_copy);
        }
    }

    private static void flipImage(int width, int height, int start_index, IntBuffer images, IntBuffer images_copy) {
        for (int i = 0; i < height >> 1; ++i) {
            int n = i * width + start_index;
            int n2 = (height - i - 1) * width + start_index;
            for (int j = 0; j < width; ++j) {
                int n3 = n + j;
                int n4 = n2 + j;
                int n5 = images.get(n3 + images.position());
                images_copy.put(n3, images.get(n4 + images.position()));
                images_copy.put(n4, n5);
            }
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    public void destroy() {
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }
}

