/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjglx.Sys;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.input.Keyboard$KeyEvent;
import org.lwjglx.input.Keyboard$KeyState;
import org.lwjglx.opengl.Display;

public class Keyboard {
    public static final int CHAR_NONE = 0;
    public static final int KEY_NONE = 0;
    public static final int KEY_ESCAPE = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 3;
    public static final int KEY_3 = 4;
    public static final int KEY_4 = 5;
    public static final int KEY_5 = 6;
    public static final int KEY_6 = 7;
    public static final int KEY_7 = 8;
    public static final int KEY_8 = 9;
    public static final int KEY_9 = 10;
    public static final int KEY_0 = 11;
    public static final int KEY_MINUS = 12;
    public static final int KEY_EQUALS = 13;
    public static final int KEY_BACK = 14;
    public static final int KEY_TAB = 15;
    public static final int KEY_Q = 16;
    public static final int KEY_W = 17;
    public static final int KEY_E = 18;
    public static final int KEY_R = 19;
    public static final int KEY_T = 20;
    public static final int KEY_Y = 21;
    public static final int KEY_U = 22;
    public static final int KEY_I = 23;
    public static final int KEY_O = 24;
    public static final int KEY_P = 25;
    public static final int KEY_LBRACKET = 26;
    public static final int KEY_RBRACKET = 27;
    public static final int KEY_RETURN = 28;
    public static final int KEY_LCONTROL = 29;
    public static final int KEY_A = 30;
    public static final int KEY_S = 31;
    public static final int KEY_D = 32;
    public static final int KEY_F = 33;
    public static final int KEY_G = 34;
    public static final int KEY_H = 35;
    public static final int KEY_J = 36;
    public static final int KEY_K = 37;
    public static final int KEY_L = 38;
    public static final int KEY_SEMICOLON = 39;
    public static final int KEY_APOSTROPHE = 40;
    public static final int KEY_GRAVE = 41;
    public static final int KEY_LSHIFT = 42;
    public static final int KEY_BACKSLASH = 43;
    public static final int KEY_Z = 44;
    public static final int KEY_X = 45;
    public static final int KEY_C = 46;
    public static final int KEY_V = 47;
    public static final int KEY_B = 48;
    public static final int KEY_N = 49;
    public static final int KEY_M = 50;
    public static final int KEY_COMMA = 51;
    public static final int KEY_PERIOD = 52;
    public static final int KEY_SLASH = 53;
    public static final int KEY_RSHIFT = 54;
    public static final int KEY_MULTIPLY = 55;
    public static final int KEY_LMENU = 56;
    public static final int KEY_SPACE = 57;
    public static final int KEY_CAPITAL = 58;
    public static final int KEY_F1 = 59;
    public static final int KEY_F2 = 60;
    public static final int KEY_F3 = 61;
    public static final int KEY_F4 = 62;
    public static final int KEY_F5 = 63;
    public static final int KEY_F6 = 64;
    public static final int KEY_F7 = 65;
    public static final int KEY_F8 = 66;
    public static final int KEY_F9 = 67;
    public static final int KEY_F10 = 68;
    public static final int KEY_NUMLOCK = 69;
    public static final int KEY_SCROLL = 70;
    public static final int KEY_NUMPAD7 = 71;
    public static final int KEY_NUMPAD8 = 72;
    public static final int KEY_NUMPAD9 = 73;
    public static final int KEY_SUBTRACT = 74;
    public static final int KEY_NUMPAD4 = 75;
    public static final int KEY_NUMPAD5 = 76;
    public static final int KEY_NUMPAD6 = 77;
    public static final int KEY_ADD = 78;
    public static final int KEY_NUMPAD1 = 79;
    public static final int KEY_NUMPAD2 = 80;
    public static final int KEY_NUMPAD3 = 81;
    public static final int KEY_NUMPAD0 = 82;
    public static final int KEY_DECIMAL = 83;
    public static final int KEY_F11 = 87;
    public static final int KEY_F12 = 88;
    public static final int KEY_F13 = 100;
    public static final int KEY_F14 = 101;
    public static final int KEY_F15 = 102;
    public static final int KEY_F16 = 103;
    public static final int KEY_F17 = 104;
    public static final int KEY_F18 = 105;
    public static final int KEY_KANA = 112;
    public static final int KEY_F19 = 113;
    public static final int KEY_CONVERT = 121;
    public static final int KEY_NOCONVERT = 123;
    public static final int KEY_YEN = 125;
    public static final int KEY_NUMPADEQUALS = 141;
    public static final int KEY_CIRCUMFLEX = 144;
    public static final int KEY_AT = 145;
    public static final int KEY_COLON = 146;
    public static final int KEY_UNDERLINE = 147;
    public static final int KEY_KANJI = 148;
    public static final int KEY_STOP = 149;
    public static final int KEY_AX = 150;
    public static final int KEY_UNLABELED = 151;
    public static final int KEY_NUMPADENTER = 156;
    public static final int KEY_RCONTROL = 157;
    public static final int KEY_SECTION = 167;
    public static final int KEY_NUMPADCOMMA = 179;
    public static final int KEY_DIVIDE = 181;
    public static final int KEY_SYSRQ = 183;
    public static final int KEY_RMENU = 184;
    public static final int KEY_FUNCTION = 196;
    public static final int KEY_PAUSE = 197;
    public static final int KEY_HOME = 199;
    public static final int KEY_UP = 200;
    public static final int KEY_PRIOR = 201;
    public static final int KEY_LEFT = 203;
    public static final int KEY_RIGHT = 205;
    public static final int KEY_END = 207;
    public static final int KEY_DOWN = 208;
    public static final int KEY_NEXT = 209;
    public static final int KEY_INSERT = 210;
    public static final int KEY_DELETE = 211;
    public static final int KEY_CLEAR = 218;
    public static final int KEY_LMETA = 219;
    public static final int KEY_LWIN = 219;
    public static final int KEY_RMETA = 220;
    public static final int KEY_RWIN = 220;
    public static final int KEY_APPS = 221;
    public static final int KEY_POWER = 222;
    public static final int KEY_SLEEP = 223;
    public static final int keyCount;
    private static final Map<String, Integer> reverseKeyMap;
    private static boolean doRepeatEvents;
    public static final int KEYBOARD_SIZE = Short.MAX_VALUE;
    public static Queue<Keyboard$KeyEvent> eventQueue;
    private static final String[] unlocalizedKeyNameMiniLut;

    public static void populateKeyLookupTables() {
        for (int i = 0; i <= 255; ++i) {
            Keyboard.getKeyName(i);
        }
    }

    public static void addRawKeyEvent(Keyboard$KeyEvent event) {
        if (event == null || event.state == Keyboard$KeyState.REPEAT && !doRepeatEvents) {
            return;
        }
        try {
            eventQueue.add(event);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void addGlfwKeyEvent(long window, int key, int scancode, int action, int mods, int c) {
        Keyboard$KeyState keyboard$KeyState = switch (action) {
            case 1 -> Keyboard$KeyState.PRESS;
            case 0 -> Keyboard$KeyState.RELEASE;
            case 2 -> Keyboard$KeyState.REPEAT;
            default -> Keyboard$KeyState.RELEASE;
        };
        Keyboard.addRawKeyEvent(new Keyboard$KeyEvent(KeyCodes.glfwToLwjgl(key), c, keyboard$KeyState, Sys.getNanoTime()));
    }

    public static void addCharEvent(int key, int c) {
        try {
            eventQueue.add(new Keyboard$KeyEvent(0, c, Keyboard$KeyState.PRESS, Sys.getNanoTime()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void create() {
    }

    public static boolean isKeyDown(int key) {
        if (key == 0) {
            return false;
        }
        int n = KeyCodes.lwjglToGlfw(key);
        return n != -1 && GLFW.glfwGetKey((long)Display.getWindow(), (int)n) == 1;
    }

    public static void poll() {
    }

    public static void enableRepeatEvents(boolean enable) {
        doRepeatEvents = enable;
    }

    public static boolean areRepeatEventsEnabled() {
        return doRepeatEvents;
    }

    public static int getKeyCount() {
        return keyCount;
    }

    public static int getNumKeyboardEvents() {
        return eventQueue.size();
    }

    public static boolean isRepeatEvent() {
        return Keyboard.eventQueue.peek().state == Keyboard$KeyState.REPEAT;
    }

    public static boolean next() {
        boolean bl;
        boolean bl2 = bl = eventQueue.size() > 1;
        if (bl) {
            eventQueue.remove();
        }
        return bl;
    }

    public static int getEventKey() {
        return Keyboard.eventQueue.peek().key;
    }

    public static char getEventCharacter() {
        return (char)Keyboard.eventQueue.peek().codepoint;
    }

    public static int lwjgl3ify$getEventCodePoint() {
        return Keyboard.eventQueue.peek().codepoint;
    }

    public static boolean getEventKeyState() {
        return Keyboard.eventQueue.peek().state.isPressed;
    }

    public static long getEventNanoseconds() {
        return Keyboard.eventQueue.peek().nano;
    }

    public static String getKeyName(int key) {
        if (key == 0) {
            return "NONE";
        }
        String string = StringUtils.upperCase((String)GLFW.glfwGetKeyName((int)KeyCodes.lwjglToGlfw(key), (int)0));
        Object object = string == null ? (key >= 0 && key < unlocalizedKeyNameMiniLut.length ? unlocalizedKeyNameMiniLut[key] : "Key " + key) : string;
        reverseKeyMap.put((String)object, key);
        return object;
    }

    public static int getKeyIndex(String keyName) {
        if (keyName.equals("NONE")) {
            return 0;
        }
        Integer n = reverseKeyMap.get(keyName);
        if (n == null) {
            if (keyName.matches("Key -?[0-9]+]")) {
                return Integer.parseInt(StringUtils.removeStart((String)keyName, (String)"Key "));
            }
            return 0;
        }
        return n;
    }

    public static boolean isCreated() {
        return Display.isCreated();
    }

    public static void destroy() {
    }

    static {
        reverseKeyMap = new ConcurrentHashMap<String, Integer>();
        doRepeatEvents = true;
        eventQueue = new ArrayBlockingQueue<Keyboard$KeyEvent>(256);
        unlocalizedKeyNameMiniLut = new String[Short.MAX_VALUE];
        Field[] fieldArray = Keyboard.class.getFields();
        int n = 0;
        try {
            for (Field field : fieldArray) {
                String string;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith("KEY_") || field.getName().endsWith("WIN")) continue;
                int n2 = field.getInt(null);
                Keyboard.unlocalizedKeyNameMiniLut[n2] = string = field.getName().substring(4);
                reverseKeyMap.put(string, n2);
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        keyCount = n;
        for (int i = 0; i < unlocalizedKeyNameMiniLut.length; ++i) {
            if (unlocalizedKeyNameMiniLut[i] != null) continue;
            Keyboard.unlocalizedKeyNameMiniLut[i] = "Key " + i;
        }
        eventQueue.add(new Keyboard$KeyEvent(0, 0, Keyboard$KeyState.RELEASE, Sys.getNanoTime()));
    }
}

