/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.openal;

import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.EXTEfx;
import org.lwjglx.openal.OpenALException;

public final class EFXUtil {
    private static final int EFFECT = 1111;
    private static final int FILTER = 2222;

    private EFXUtil() {
    }

    public static boolean isEfxSupported() {
        return ALC.getCapabilities().ALC_EXT_EFX;
    }

    public static boolean isEffectSupported(int effectType) {
        switch (effectType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 32768: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid effect type: " + effectType);
            }
        }
        return EFXUtil.testSupportGeneric(1111, effectType);
    }

    public static boolean isFilterSupported(int filterType) {
        switch (filterType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid filter type: " + filterType);
            }
        }
        return EFXUtil.testSupportGeneric(2222, filterType);
    }

    private static boolean testSupportGeneric(int objectType, int typeValue) {
        switch (objectType) {
            case 1111: 
            case 2222: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid objectType: " + objectType);
            }
        }
        boolean bl = false;
        if (EFXUtil.isEfxSupported()) {
            int n;
            AL10.alGetError();
            int n2 = 0;
            try {
                n2 = switch (objectType) {
                    case 1111 -> EXTEfx.alGenEffects();
                    case 2222 -> EXTEfx.alGenFilters();
                    default -> throw new IllegalArgumentException("Invalid objectType: " + objectType);
                };
                n = AL10.alGetError();
            }
            catch (OpenALException openALException) {
                n = openALException.getMessage().contains("AL_OUT_OF_MEMORY") ? 40965 : 40964;
            }
            if (n == 0) {
                int n3;
                AL10.alGetError();
                try {
                    switch (objectType) {
                        case 1111: {
                            EXTEfx.alEffecti((int)n2, (int)32769, (int)typeValue);
                            break;
                        }
                        case 2222: {
                            EXTEfx.alFilteri((int)n2, (int)32769, (int)typeValue);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + objectType);
                        }
                    }
                    n3 = AL10.alGetError();
                }
                catch (OpenALException openALException) {
                    n3 = 40963;
                }
                if (n3 == 0) {
                    bl = true;
                }
                try {
                    switch (objectType) {
                        case 1111: {
                            EXTEfx.alDeleteEffects((int)n2);
                            break;
                        }
                        case 2222: {
                            EXTEfx.alDeleteFilters((int)n2);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + objectType);
                        }
                    }
                }
                catch (OpenALException openALException) {}
            } else if (n == 40965) {
                throw new OpenALException(AL10.alGetString((int)n));
            }
        }
        return bl;
    }
}

