/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.lwjglx.util.ReadableColor;
import org.lwjglx.util.WritableColor;

public final class Color
implements Serializable,
ReadableColor,
WritableColor {
    static final long serialVersionUID = 1L;
    private byte red;
    private byte green;
    private byte blue;
    private byte alpha;

    public Color() {
        this(0, 0, 0, 255);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(byte r, byte g, byte b) {
        this(r, g, b, -1);
    }

    public Color(int r, int g, int b, int a) {
        this.set(r, g, b, a);
    }

    public Color(byte r, byte g, byte b, byte a) {
        this.set(r, g, b, a);
    }

    public Color(ReadableColor c) {
        this.setColor(c);
    }

    @Override
    public void set(int r, int g, int b, int a) {
        this.red = (byte)r;
        this.green = (byte)g;
        this.blue = (byte)b;
        this.alpha = (byte)a;
    }

    @Override
    public void set(byte r, byte g, byte b, byte a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    @Override
    public void set(int r, int g, int b) {
        this.set(r, g, b, 255);
    }

    @Override
    public void set(byte r, byte g, byte b) {
        this.set(r, g, b, (byte)-1);
    }

    @Override
    public int getRed() {
        return this.red & 0xFF;
    }

    @Override
    public int getGreen() {
        return this.green & 0xFF;
    }

    @Override
    public int getBlue() {
        return this.blue & 0xFF;
    }

    @Override
    public int getAlpha() {
        return this.alpha & 0xFF;
    }

    @Override
    public void setRed(int red) {
        this.red = (byte)red;
    }

    @Override
    public void setGreen(int green) {
        this.green = (byte)green;
    }

    @Override
    public void setBlue(int blue) {
        this.blue = (byte)blue;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = (byte)alpha;
    }

    @Override
    public void setRed(byte red) {
        this.red = red;
    }

    @Override
    public void setGreen(byte green) {
        this.green = green;
    }

    @Override
    public void setBlue(byte blue) {
        this.blue = blue;
    }

    @Override
    public void setAlpha(byte alpha) {
        this.alpha = alpha;
    }

    public String toString() {
        return "Color [" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "]";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ReadableColor && ((ReadableColor)o).getRed() == this.getRed() && ((ReadableColor)o).getGreen() == this.getGreen() && ((ReadableColor)o).getBlue() == this.getBlue() && ((ReadableColor)o).getAlpha() == this.getAlpha();
    }

    public int hashCode() {
        return this.red << 24 | this.green << 16 | this.blue << 8 | this.alpha;
    }

    @Override
    public byte getAlphaByte() {
        return this.alpha;
    }

    @Override
    public byte getBlueByte() {
        return this.blue;
    }

    @Override
    public byte getGreenByte() {
        return this.green;
    }

    @Override
    public byte getRedByte() {
        return this.red;
    }

    @Override
    public void writeRGBA(ByteBuffer dest) {
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
        dest.put(this.alpha);
    }

    @Override
    public void writeRGB(ByteBuffer dest) {
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
    }

    @Override
    public void writeABGR(ByteBuffer dest) {
        dest.put(this.alpha);
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
    }

    @Override
    public void writeARGB(ByteBuffer dest) {
        dest.put(this.alpha);
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
    }

    @Override
    public void writeBGR(ByteBuffer dest) {
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
    }

    @Override
    public void writeBGRA(ByteBuffer dest) {
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
        dest.put(this.alpha);
    }

    @Override
    public void readRGBA(ByteBuffer src) {
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
        this.alpha = src.get();
    }

    @Override
    public void readRGB(ByteBuffer src) {
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
    }

    @Override
    public void readARGB(ByteBuffer src) {
        this.alpha = src.get();
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
    }

    @Override
    public void readBGRA(ByteBuffer src) {
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
        this.alpha = src.get();
    }

    @Override
    public void readBGR(ByteBuffer src) {
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
    }

    @Override
    public void readABGR(ByteBuffer src) {
        this.alpha = src.get();
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
    }

    @Override
    public void setColor(ReadableColor src) {
        this.red = src.getRedByte();
        this.green = src.getGreenByte();
        this.blue = src.getBlueByte();
        this.alpha = src.getAlphaByte();
    }

    public void fromHSB(float hue, float saturation, float brightness) {
        if (saturation == 0.0f) {
            this.green = this.blue = (byte)(brightness * 255.0f + 0.5f);
            this.red = this.blue;
        } else {
            float f = (hue - (float)Math.floor(hue)) * 6.0f;
            float f2 = f - (float)Math.floor(f);
            float f3 = brightness * (1.0f - saturation);
            float f4 = brightness * (1.0f - saturation * f2);
            float f5 = brightness * (1.0f - saturation * (1.0f - f2));
            switch ((int)f) {
                case 0: {
                    this.red = (byte)(brightness * 255.0f + 0.5f);
                    this.green = (byte)(f5 * 255.0f + 0.5f);
                    this.blue = (byte)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    this.red = (byte)(f4 * 255.0f + 0.5f);
                    this.green = (byte)(brightness * 255.0f + 0.5f);
                    this.blue = (byte)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    this.red = (byte)(f3 * 255.0f + 0.5f);
                    this.green = (byte)(brightness * 255.0f + 0.5f);
                    this.blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    this.red = (byte)(f3 * 255.0f + 0.5f);
                    this.green = (byte)(f4 * 255.0f + 0.5f);
                    this.blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    this.red = (byte)(f5 * 255.0f + 0.5f);
                    this.green = (byte)(f3 * 255.0f + 0.5f);
                    this.blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    this.red = (byte)(brightness * 255.0f + 0.5f);
                    this.green = (byte)(f3 * 255.0f + 0.5f);
                    this.blue = (byte)(f4 * 255.0f + 0.5f);
                }
            }
        }
    }

    public float[] toHSB(float[] dest) {
        float f;
        int n;
        int n2;
        int n3 = this.getRed();
        int n4 = this.getGreen();
        int n5 = this.getBlue();
        if (dest == null) {
            dest = new float[3];
        }
        int n6 = n2 = n3 <= n4 ? n4 : n3;
        if (n5 > n2) {
            n2 = n5;
        }
        int n7 = n = n3 >= n4 ? n4 : n3;
        if (n5 < n) {
            n = n5;
        }
        float f2 = (float)n2 / 255.0f;
        float f3 = n2 != 0 ? (float)(n2 - n) / (float)n2 : 0.0f;
        if (f3 == 0.0f) {
            f = 0.0f;
        } else {
            float f4 = (float)(n2 - n3) / (float)(n2 - n);
            float f5 = (float)(n2 - n4) / (float)(n2 - n);
            float f6 = (float)(n2 - n5) / (float)(n2 - n);
            f = n3 == n2 ? f6 - f5 : (n4 == n2 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        dest[0] = f;
        dest[1] = f3;
        dest[2] = f2;
        return dest;
    }
}

