/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.lwjglx.LWJGLUtil;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.util.Display$1Sorter;

public final class Display {
    private static final boolean DEBUG = false;

    public static DisplayMode[] getAvailableDisplayModes(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBPP, int maxBPP, int minFreq, int maxFreq) {
        DisplayMode[] displayModeArray = org.lwjglx.opengl.Display.getAvailableDisplayModes();
        if (LWJGLUtil.DEBUG) {
            System.out.println("Available screen modes:");
            for (DisplayMode displayMode : displayModeArray) {
                System.out.println(displayMode);
            }
        }
        ArrayList arrayList = new ArrayList(displayModeArray.length);
        for (int i = 0; i < displayModeArray.length; ++i) {
            assert (displayModeArray[i] != null) : i + " " + displayModeArray.length;
            if (minWidth != -1 && displayModeArray[i].getWidth() < minWidth || maxWidth != -1 && displayModeArray[i].getWidth() > maxWidth || minHeight != -1 && displayModeArray[i].getHeight() < minHeight || maxHeight != -1 && displayModeArray[i].getHeight() > maxHeight || minBPP != -1 && displayModeArray[i].getBitsPerPixel() < minBPP || maxBPP != -1 && displayModeArray[i].getBitsPerPixel() > maxBPP || displayModeArray[i].getFrequency() != 0 && (minFreq != -1 && displayModeArray[i].getFrequency() < minFreq || maxFreq != -1 && displayModeArray[i].getFrequency() > maxFreq)) continue;
            arrayList.add(displayModeArray[i]);
        }
        DisplayMode[] displayModeArray2 = new DisplayMode[arrayList.size()];
        arrayList.toArray(displayModeArray2);
        if (LWJGLUtil.DEBUG) {
            // empty if block
        }
        return displayModeArray2;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] dm, String[] param) {
        Arrays.sort(dm, new Display$1Sorter(param));
        if (LWJGLUtil.DEBUG) {
            System.out.println("Sorted display modes:");
            for (DisplayMode displayMode : dm) {
                System.out.println(displayMode);
            }
        }
        for (DisplayMode displayMode : dm) {
            try {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + String.valueOf(displayMode));
                }
                org.lwjglx.opengl.Display.setDisplayMode(displayMode);
                return displayMode;
            }
            catch (Exception exception) {
                if (!LWJGLUtil.DEBUG) continue;
                System.out.println("Failed to set display mode to " + String.valueOf(displayMode));
                exception.printStackTrace();
            }
        }
        throw new Exception("Failed to set display mode.");
    }
}

