/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util;

import java.io.Serializable;
import org.lwjglx.util.ReadableDimension;
import org.lwjglx.util.ReadablePoint;
import org.lwjglx.util.ReadableRectangle;
import org.lwjglx.util.WritableDimension;
import org.lwjglx.util.WritablePoint;
import org.lwjglx.util.WritableRectangle;

public final class Rectangle
implements Serializable,
ReadableRectangle,
WritableRectangle {
    static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle() {
    }

    public Rectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public Rectangle(ReadablePoint p, ReadableDimension d) {
        this.x = p.getX();
        this.y = p.getY();
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    public Rectangle(ReadableRectangle r) {
        this.x = r.getX();
        this.y = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    @Override
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setLocation(ReadablePoint p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    @Override
    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    @Override
    public void setSize(ReadableDimension d) {
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public void setBounds(ReadablePoint p, ReadableDimension d) {
        this.x = p.getX();
        this.y = p.getY();
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    @Override
    public void setBounds(ReadableRectangle r) {
        this.x = r.getX();
        this.y = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    public int getArea() {
        return this.width * this.height;
    }

    @Override
    public void getBounds(WritableRectangle dest) {
        dest.setBounds(this.x, this.y, this.width, this.height);
    }

    @Override
    public void getLocation(WritablePoint dest) {
        dest.setLocation(this.x, this.y);
    }

    @Override
    public void getSize(WritableDimension dest) {
        dest.setSize(this.width, this.height);
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void translate(ReadablePoint point) {
        this.x += point.getX();
        this.y += point.getY();
    }

    public void untranslate(ReadablePoint point) {
        this.x -= point.getX();
        this.y -= point.getY();
    }

    public boolean contains(ReadablePoint p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int X, int Y) {
        int n = this.width;
        int n2 = this.height;
        if ((n | n2) < 0) {
            return false;
        }
        int n3 = this.x;
        int n4 = this.y;
        if (X < n3 || Y < n4) {
            return false;
        }
        n2 += n4;
        return !((n += n3) >= n3 && n <= X || n2 >= n4 && n2 <= Y);
    }

    public boolean contains(ReadableRectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(int X, int Y, int W, int H) {
        int n = this.width;
        int n2 = this.height;
        if ((n | n2 | W | H) < 0) {
            return false;
        }
        int n3 = this.x;
        int n4 = this.y;
        if (X < n3 || Y < n4) {
            return false;
        }
        n += n3;
        if ((W += X) <= X ? n >= n3 || W > n : n >= n3 && W > n) {
            return false;
        }
        n2 += n4;
        return !((H += Y) <= Y ? n2 >= n4 || H > n2 : n2 >= n4 && H > n2);
    }

    public boolean intersects(ReadableRectangle r) {
        int n = this.width;
        int n2 = this.height;
        int n3 = r.getWidth();
        int n4 = r.getHeight();
        if (n3 <= 0 || n4 <= 0 || n <= 0 || n2 <= 0) {
            return false;
        }
        int n5 = this.x;
        int n6 = this.y;
        int n7 = r.getX();
        int n8 = r.getY();
        n4 += n8;
        n += n5;
        n2 += n6;
        return !((n3 += n7) >= n7 && n3 <= n5 || n4 >= n8 && n4 <= n6 || n >= n5 && n <= n7 || n2 >= n6 && n2 <= n8);
    }

    public Rectangle intersection(ReadableRectangle r, Rectangle dest) {
        int n = this.x;
        int n2 = this.y;
        int n3 = r.getX();
        int n4 = r.getY();
        long l = n;
        l += (long)this.width;
        long l2 = n2;
        l2 += (long)this.height;
        long l3 = n3;
        l3 += (long)r.getWidth();
        long l4 = n4;
        l4 += (long)r.getHeight();
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        if (dest == null) {
            dest = new Rectangle(n, n2, (int)l, (int)l2);
        } else {
            dest.setBounds(n, n2, (int)l, (int)l2);
        }
        return dest;
    }

    public WritableRectangle union(ReadableRectangle r, WritableRectangle dest) {
        int n = Math.min(this.x, r.getX());
        int n2 = Math.max(this.x + this.width, r.getX() + r.getWidth());
        int n3 = Math.min(this.y, r.getY());
        int n4 = Math.max(this.y + this.height, r.getY() + r.getHeight());
        dest.setBounds(n, n3, n2 - n, n4 - n3);
        return dest;
    }

    public void add(int newx, int newy) {
        int n = Math.min(this.x, newx);
        int n2 = Math.max(this.x + this.width, newx);
        int n3 = Math.min(this.y, newy);
        int n4 = Math.max(this.y + this.height, newy);
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
    }

    public void add(ReadablePoint pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(ReadableRectangle r) {
        int n = Math.min(this.x, r.getX());
        int n2 = Math.max(this.x + this.width, r.getX() + r.getWidth());
        int n3 = Math.min(this.y, r.getY());
        int n4 = Math.max(this.y + this.height, r.getY() + r.getHeight());
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.y -= v;
        this.width += h * 2;
        this.height += v * 2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)obj;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }
}

