/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjglx.LWJGLUtil;

public class WaveData {
    public final ByteBuffer data;
    public final int format;
    public final int samplerate;

    private WaveData(ByteBuffer data, int format, int samplerate) {
        this.data = data;
        this.format = format;
        this.samplerate = samplerate;
    }

    public void dispose() {
        this.data.clear();
    }

    public static WaveData create(URL path) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(path));
        }
        catch (Exception exception) {
            LWJGLUtil.log("Unable to create from: " + String.valueOf(path) + ", " + exception.getMessage());
            return null;
        }
    }

    public static WaveData create(String path) {
        return WaveData.create(Thread.currentThread().getContextClassLoader().getResource(path));
    }

    public static WaveData create(InputStream is) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(is));
        }
        catch (Exception exception) {
            LWJGLUtil.log("Unable to create from inputstream, " + exception.getMessage());
            return null;
        }
    }

    public static WaveData create(byte[] buffer) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(new BufferedInputStream(new ByteArrayInputStream(buffer))));
        }
        catch (Exception exception) {
            LWJGLUtil.log("Unable to create from byte array, " + exception.getMessage());
            return null;
        }
    }

    public static WaveData create(ByteBuffer buffer) {
        try {
            byte[] byArray = null;
            if (buffer.hasArray()) {
                byArray = buffer.array();
            } else {
                byArray = new byte[buffer.capacity()];
                buffer.get(byArray);
            }
            return WaveData.create(byArray);
        }
        catch (Exception exception) {
            LWJGLUtil.log("Unable to create from ByteBuffer, " + exception.getMessage());
            return null;
        }
    }

    public static WaveData create(AudioInputStream ais) {
        AudioFormat audioFormat = ais.getFormat();
        int n = 0;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4352;
            } else if (audioFormat.getSampleSizeInBits() == 16) {
                n = 4353;
            } else assert (false) : "Illegal sample size";
        } else if (audioFormat.getChannels() == 2) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 4354;
            } else if (audioFormat.getSampleSizeInBits() == 16) {
                n = 4355;
            } else assert (false) : "Illegal sample size";
        } else assert (false) : "Only mono or stereo is supported";
        ByteBuffer byteBuffer = null;
        try {
            int n2 = ais.available();
            if (n2 <= 0) {
                n2 = ais.getFormat().getChannels() * (int)ais.getFrameLength() * ais.getFormat().getSampleSizeInBits() / 8;
            }
            byte[] byArray = new byte[ais.available()];
            int n3 = 0;
            for (int i = 0; (n3 = ais.read(byArray, i, byArray.length - i)) != -1 && i < byArray.length; i += n3) {
            }
            byteBuffer = WaveData.convertAudioBytes(byArray, audioFormat.getSampleSizeInBits() == 16, audioFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException iOException) {
            return null;
        }
        WaveData waveData = new WaveData(byteBuffer, n, (int)audioFormat.getSampleRate());
        try {
            ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return waveData;
    }

    private static ByteBuffer convertAudioBytes(byte[] audio_bytes, boolean two_bytes_data, ByteOrder order) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(audio_bytes.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(audio_bytes);
        byteBuffer2.order(order);
        if (two_bytes_data) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            ShortBuffer shortBuffer2 = byteBuffer2.asShortBuffer();
            while (shortBuffer2.hasRemaining()) {
                shortBuffer.put(shortBuffer2.get());
            }
        } else {
            while (byteBuffer2.hasRemaining()) {
                byteBuffer.put(byteBuffer2.get());
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }
}

