/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class XPMFile {
    private byte[] bytes;
    private static final int WIDTH = 0;
    private static final int HEIGHT = 1;
    private static final int NUMBER_OF_COLORS = 2;
    private static final int CHARACTERS_PER_PIXEL = 3;
    private static int[] format = new int[4];

    private XPMFile() {
    }

    public static XPMFile load(String file) {
        return XPMFile.load(new FileInputStream(new File(file)));
    }

    public static XPMFile load(InputStream is) {
        XPMFile xPMFile = new XPMFile();
        xPMFile.readImage(is);
        return xPMFile;
    }

    public int getHeight() {
        return format[1];
    }

    public int getWidth() {
        return format[0];
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    private void readImage(InputStream is) {
        try {
            int n;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(is));
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            format = XPMFile.parseFormat(XPMFile.nextLineOfInterest(lineNumberReader));
            for (n = 0; n < format[2]; ++n) {
                Object[] objectArray = XPMFile.parseColor(XPMFile.nextLineOfInterest(lineNumberReader));
                hashMap.put((String)objectArray[0], (Integer)objectArray[1]);
            }
            this.bytes = new byte[format[0] * format[1] * 4];
            for (n = 0; n < format[1]; ++n) {
                this.parseImageLine(XPMFile.nextLineOfInterest(lineNumberReader), format, hashMap, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Unable to parse XPM File");
        }
    }

    private static String nextLineOfInterest(LineNumberReader reader) {
        String string;
        while (!(string = reader.readLine()).startsWith("\"")) {
        }
        return string.substring(1, string.lastIndexOf(34));
    }

    private static int[] parseFormat(String format) {
        StringTokenizer stringTokenizer = new StringTokenizer(format);
        return new int[]{Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())};
    }

    private static Object[] parseColor(String line) {
        String string = line.substring(0, format[3]);
        String string2 = line.substring(format[3] + 4);
        return new Object[]{string, Integer.parseInt(string2, 16)};
    }

    private void parseImageLine(String line, int[] format, HashMap<String, Integer> colors, int index) {
        int n = index * 4 * format[0];
        for (int i = 0; i < format[0]; ++i) {
            String string = line.substring(i * format[3], i * format[3] + format[3]);
            int n2 = colors.get(string);
            this.bytes[n + i * 4] = (byte)((n2 & 0xFF0000) >> 16);
            this.bytes[n + (i * 4 + 1)] = (byte)((n2 & 0xFF00) >> 8);
            this.bytes[n + (i * 4 + 2)] = (byte)((n2 & 0xFF) >> 0);
            this.bytes[n + (i * 4 + 3)] = -1;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage:\nXPMFile <file>");
        }
        try {
            String string = args[0].substring(0, args[0].indexOf(".")) + ".raw";
            XPMFile xPMFile = XPMFile.load(args[0]);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
            bufferedOutputStream.write(xPMFile.getBytes());
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

