/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.util.glu.MipMap$1;
import org.lwjglx.util.glu.PixelStoreState;
import org.lwjglx.util.glu.Util;

public class MipMap
extends Util {
    private static final ThreadLocal<PixelStoreState> pixelStoreState = new MipMap$1();
    private static final int STBIR_PIXEL_LAYOUT_ALPHA = 0;
    private static final int STBIR_PIXEL_LAYOUT_GREY = 1;
    private static final int STBIR_PIXEL_LAYOUT_GREY_ALPHA = 2;
    private static final int STBIR_PIXEL_LAYOUT_RGB = 3;
    private static final int STBIR_PIXEL_LAYOUT_RGBA = 4;
    private static final int STBIR_PIXEL_LAYOUT_BGR = 5;
    private static final int STBIR_PIXEL_LAYOUT_BGRA = 6;

    public static int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, ByteBuffer data) {
        int n;
        int n2;
        if (width < 1 || height < 1) {
            return 100901;
        }
        int n3 = MipMap.bytesPerPixel(format, type);
        if (n3 == 0) {
            return 100900;
        }
        int n4 = MipMap.glGetIntegerv(3379);
        int n5 = MipMap.nearestPower(width);
        if (n5 > n4) {
            n5 = n4;
        }
        if ((n2 = MipMap.nearestPower(height)) > n4) {
            n2 = n4;
        }
        PixelStoreState pixelStoreState = MipMap.pixelStoreState.get();
        pixelStoreState.load();
        GL11.glPixelStorei((int)3330, (int)0);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3331, (int)0);
        GL11.glPixelStorei((int)3332, (int)0);
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)((n5 + 4) * n2 * n3));
        ByteBuffer byteBuffer2 = MemoryUtil.memAlloc((int)((n5 + 4) * n2 * n3));
        int n6 = 0;
        if (n5 != width || n2 != height) {
            n = MipMap.gluScaleImage(format, width, height, type, data, n5, n2, type, byteBuffer);
            if (n != 0) {
                n6 = n;
            }
        } else {
            MemoryUtil.memCopy((ByteBuffer)data, (ByteBuffer)byteBuffer);
        }
        n = 0;
        while (n6 == 0) {
            int n7;
            GL11.glTexImage2D((int)target, (int)n, (int)components, (int)n5, (int)n2, (int)0, (int)format, (int)type, (ByteBuffer)byteBuffer);
            if (n5 == 1 && n2 == 1) break;
            int n8 = n5 < 2 ? 1 : n5 >> 1;
            int n9 = MipMap.gluScaleImage(format, n5, n2, type, byteBuffer, n8, n7 = n2 < 2 ? 1 : n2 >> 1, type, byteBuffer2);
            if (n9 != 0) {
                n6 = n9;
                break;
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer = byteBuffer2;
            byteBuffer2 = byteBuffer3;
            n5 = n8;
            n2 = n7;
            ++n;
        }
        pixelStoreState.save();
        MemoryUtil.memFree((ByteBuffer)byteBuffer);
        MemoryUtil.memFree((ByteBuffer)byteBuffer2);
        return n6;
    }

    public static int gluScaleImage(int format, int widthIn, int heightIn, int typein, ByteBuffer dataIn, int widthOut, int heightOut, int typeOut, ByteBuffer dataOut) {
        int n;
        int n2 = MipMap.compPerPix(format);
        if (n2 == -1) {
            return 100900;
        }
        int n3 = widthIn * n2 * (typein == 5126 ? 4 : 1);
        int n4 = widthOut * n2 * (typeOut == 5126 ? 4 : 1);
        if (typein != typeOut) {
            return 100900;
        }
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                return 100900;
            }
        }
        int n5 = typein == 5126 ? 4 : 0;
        ByteBuffer byteBuffer = STBImageResize.stbir_resize((ByteBuffer)dataIn, (int)widthIn, (int)heightIn, (int)n3, (ByteBuffer)dataOut, (int)widthOut, (int)heightOut, (int)n4, (int)n, (int)n5, (int)0, (int)3);
        if (byteBuffer == null) {
            throw new RuntimeException("Couldn't resize image with stbir");
        }
        return 0;
    }
}

