/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjglx.BufferUtils;
import org.lwjglx.util.glu.Util;

public class Project
extends Util {
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final FloatBuffer matrix = BufferUtils.createFloatBuffer(16);
    private static final FloatBuffer finalMatrix = BufferUtils.createFloatBuffer(16);
    private static final FloatBuffer tempMatrix = BufferUtils.createFloatBuffer(16);
    private static final float[] in = new float[4];
    private static final float[] out = new float[4];
    private static final float[] forward = new float[3];
    private static final float[] side = new float[3];
    private static final float[] up = new float[3];

    private static void __gluMakeIdentityf(FloatBuffer m) {
        int n = m.position();
        m.put(IDENTITY_MATRIX);
        m.position(n);
    }

    private static void __gluMultMatrixVecf(FloatBuffer m, float[] in, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = in[0] * m.get(m.position() + 0 + i) + in[1] * m.get(m.position() + 4 + i) + in[2] * m.get(m.position() + 8 + i) + in[3] * m.get(m.position() + 12 + i);
        }
    }

    private static boolean __gluInvertMatrixf(FloatBuffer src, FloatBuffer inverse) {
        int n;
        FloatBuffer floatBuffer = tempMatrix;
        for (n = 0; n < 16; ++n) {
            floatBuffer.put(n, src.get(n + src.position()));
        }
        Project.__gluMakeIdentityf(inverse);
        for (n = 0; n < 4; ++n) {
            float f;
            int n2;
            int n3;
            int n4 = n;
            for (n3 = n + 1; n3 < 4; ++n3) {
                if (!(Math.abs(floatBuffer.get(n3 * 4 + n)) > Math.abs(floatBuffer.get(n * 4 + n)))) continue;
                n4 = n3;
            }
            if (n4 != n) {
                for (n2 = 0; n2 < 4; ++n2) {
                    f = floatBuffer.get(n * 4 + n2);
                    floatBuffer.put(n * 4 + n2, floatBuffer.get(n4 * 4 + n2));
                    floatBuffer.put(n4 * 4 + n2, f);
                    f = inverse.get(n * 4 + n2);
                    inverse.put(n * 4 + n2, inverse.get(n4 * 4 + n2));
                    inverse.put(n4 * 4 + n2, f);
                }
            }
            if (floatBuffer.get(n * 4 + n) == 0.0f) {
                return false;
            }
            f = floatBuffer.get(n * 4 + n);
            for (n2 = 0; n2 < 4; ++n2) {
                floatBuffer.put(n * 4 + n2, floatBuffer.get(n * 4 + n2) / f);
                inverse.put(n * 4 + n2, inverse.get(n * 4 + n2) / f);
            }
            for (n3 = 0; n3 < 4; ++n3) {
                if (n3 == n) continue;
                f = floatBuffer.get(n3 * 4 + n);
                for (n2 = 0; n2 < 4; ++n2) {
                    floatBuffer.put(n3 * 4 + n2, floatBuffer.get(n3 * 4 + n2) - floatBuffer.get(n * 4 + n2) * f);
                    inverse.put(n3 * 4 + n2, inverse.get(n3 * 4 + n2) - inverse.get(n * 4 + n2) * f);
                }
            }
        }
        return true;
    }

    private static void __gluMultMatricesf(FloatBuffer a, FloatBuffer b, FloatBuffer r) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r.put(r.position() + i * 4 + j, a.get(a.position() + i * 4 + 0) * b.get(b.position() + 0 + j) + a.get(a.position() + i * 4 + 1) * b.get(b.position() + 4 + j) + a.get(a.position() + i * 4 + 2) * b.get(b.position() + 8 + j) + a.get(a.position() + i * 4 + 3) * b.get(b.position() + 12 + j));
            }
        }
    }

    public static void gluPerspective(float fovy, float aspect, float zNear, float zFar) {
        float f = fovy / 2.0f * (float)Math.PI / 180.0f;
        float f2 = zFar - zNear;
        float f3 = (float)Math.sin(f);
        if (f2 == 0.0f || f3 == 0.0f || aspect == 0.0f) {
            return;
        }
        float f4 = (float)Math.cos(f) / f3;
        Project.__gluMakeIdentityf(matrix);
        matrix.put(0, f4 / aspect);
        matrix.put(5, f4);
        matrix.put(10, -(zFar + zNear) / f2);
        matrix.put(11, -1.0f);
        matrix.put(14, -2.0f * zNear * zFar / f2);
        matrix.put(15, 0.0f);
        GL11.glMultMatrixf((FloatBuffer)matrix);
    }

    public static void gluLookAt(float eyex, float eyey, float eyez, float centerx, float centery, float centerz, float upx, float upy, float upz) {
        float[] fArray = forward;
        float[] fArray2 = side;
        float[] fArray3 = up;
        fArray[0] = centerx - eyex;
        fArray[1] = centery - eyey;
        fArray[2] = centerz - eyez;
        fArray3[0] = upx;
        fArray3[1] = upy;
        fArray3[2] = upz;
        Project.normalize(fArray);
        Project.cross(fArray, fArray3, fArray2);
        Project.normalize(fArray2);
        Project.cross(fArray2, fArray, fArray3);
        Project.__gluMakeIdentityf(matrix);
        matrix.put(0, fArray2[0]);
        matrix.put(4, fArray2[1]);
        matrix.put(8, fArray2[2]);
        matrix.put(1, fArray3[0]);
        matrix.put(5, fArray3[1]);
        matrix.put(9, fArray3[2]);
        matrix.put(2, -fArray[0]);
        matrix.put(6, -fArray[1]);
        matrix.put(10, -fArray[2]);
        GL11.glMultMatrixf((FloatBuffer)matrix);
        GL11.glTranslatef((float)(-eyex), (float)(-eyey), (float)(-eyez));
    }

    public static boolean gluProject(float objx, float objy, float objz, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer win_pos) {
        float[] fArray = in;
        float[] fArray2 = out;
        fArray[0] = objx;
        fArray[1] = objy;
        fArray[2] = objz;
        fArray[3] = 1.0f;
        Project.__gluMultMatrixVecf(modelMatrix, fArray, fArray2);
        Project.__gluMultMatrixVecf(projMatrix, fArray2, fArray);
        if ((double)fArray[3] == 0.0) {
            return false;
        }
        fArray[3] = 1.0f / fArray[3] * 0.5f;
        fArray[0] = fArray[0] * fArray[3] + 0.5f;
        fArray[1] = fArray[1] * fArray[3] + 0.5f;
        fArray[2] = fArray[2] * fArray[3] + 0.5f;
        win_pos.put(0, fArray[0] * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position() + 0));
        win_pos.put(1, fArray[1] * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1));
        win_pos.put(2, fArray[2]);
        return true;
    }

    public static boolean gluUnProject(float winx, float winy, float winz, FloatBuffer modelMatrix, FloatBuffer projMatrix, IntBuffer viewport, FloatBuffer obj_pos) {
        float[] fArray = in;
        float[] fArray2 = out;
        Project.__gluMultMatricesf(modelMatrix, projMatrix, finalMatrix);
        if (!Project.__gluInvertMatrixf(finalMatrix, finalMatrix)) {
            return false;
        }
        fArray[0] = winx;
        fArray[1] = winy;
        fArray[2] = winz;
        fArray[3] = 1.0f;
        fArray[0] = (fArray[0] - (float)viewport.get(viewport.position() + 0)) / (float)viewport.get(viewport.position() + 2);
        fArray[1] = (fArray[1] - (float)viewport.get(viewport.position() + 1)) / (float)viewport.get(viewport.position() + 3);
        fArray[0] = fArray[0] * 2.0f - 1.0f;
        fArray[1] = fArray[1] * 2.0f - 1.0f;
        fArray[2] = fArray[2] * 2.0f - 1.0f;
        Project.__gluMultMatrixVecf(finalMatrix, fArray, fArray2);
        if ((double)fArray2[3] == 0.0) {
            return false;
        }
        fArray2[3] = 1.0f / fArray2[3];
        obj_pos.put(obj_pos.position() + 0, fArray2[0] * fArray2[3]);
        obj_pos.put(obj_pos.position() + 1, fArray2[1] * fArray2[3]);
        obj_pos.put(obj_pos.position() + 2, fArray2[2] * fArray2[3]);
        return true;
    }

    public static void gluPickMatrix(float x, float y, float deltaX, float deltaY, IntBuffer viewport) {
        if (deltaX <= 0.0f || deltaY <= 0.0f) {
            return;
        }
        GL11.glTranslatef((float)(((float)viewport.get(viewport.position() + 2) - 2.0f * (x - (float)viewport.get(viewport.position() + 0))) / deltaX), (float)(((float)viewport.get(viewport.position() + 3) - 2.0f * (y - (float)viewport.get(viewport.position() + 1))) / deltaY), (float)0.0f);
        GL11.glScalef((float)((float)viewport.get(viewport.position() + 2) / deltaX), (float)((float)viewport.get(viewport.position() + 3) / deltaY), (float)1.0f);
    }
}

