/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu.tessellation;

import org.lwjglx.util.glu.tessellation.GLUhalfEdge;
import org.lwjglx.util.glu.tessellation.GLUvertex;

class Geom {
    private Geom() {
    }

    static double EdgeEval(GLUvertex u, GLUvertex v, GLUvertex w) {
        assert (Geom.VertLeq(u, v) && Geom.VertLeq(v, w));
        double d = v.s - u.s;
        double d2 = w.s - v.s;
        if (d + d2 > 0.0) {
            if (d < d2) {
                return v.t - u.t + (u.t - w.t) * (d / (d + d2));
            }
            return v.t - w.t + (w.t - u.t) * (d2 / (d + d2));
        }
        return 0.0;
    }

    static double EdgeSign(GLUvertex u, GLUvertex v, GLUvertex w) {
        assert (Geom.VertLeq(u, v) && Geom.VertLeq(v, w));
        double d = v.s - u.s;
        double d2 = w.s - v.s;
        if (d + d2 > 0.0) {
            return (v.t - w.t) * d + (v.t - u.t) * d2;
        }
        return 0.0;
    }

    static double TransEval(GLUvertex u, GLUvertex v, GLUvertex w) {
        assert (Geom.TransLeq(u, v) && Geom.TransLeq(v, w));
        double d = v.t - u.t;
        double d2 = w.t - v.t;
        if (d + d2 > 0.0) {
            if (d < d2) {
                return v.s - u.s + (u.s - w.s) * (d / (d + d2));
            }
            return v.s - w.s + (w.s - u.s) * (d2 / (d + d2));
        }
        return 0.0;
    }

    static double TransSign(GLUvertex u, GLUvertex v, GLUvertex w) {
        assert (Geom.TransLeq(u, v) && Geom.TransLeq(v, w));
        double d = v.t - u.t;
        double d2 = w.t - v.t;
        if (d + d2 > 0.0) {
            return (v.s - w.s) * d + (v.s - u.s) * d2;
        }
        return 0.0;
    }

    static boolean VertCCW(GLUvertex u, GLUvertex v, GLUvertex w) {
        return u.s * (v.t - w.t) + v.s * (w.t - u.t) + w.s * (u.t - v.t) >= 0.0;
    }

    static double Interpolate(double a, double x, double b, double y) {
        a = a < 0.0 ? 0.0 : a;
        double d = b = b < 0.0 ? 0.0 : b;
        if (a <= b) {
            if (b == 0.0) {
                return (x + y) / 2.0;
            }
            return x + (y - x) * (a / (a + b));
        }
        return y + (x - y) * (b / (a + b));
    }

    static void EdgeIntersect(GLUvertex o1, GLUvertex d1, GLUvertex o2, GLUvertex d2, GLUvertex v) {
        double d;
        double d3;
        GLUvertex gLUvertex;
        if (!Geom.VertLeq(o1, d1)) {
            gLUvertex = o1;
            o1 = d1;
            d1 = gLUvertex;
        }
        if (!Geom.VertLeq(o2, d2)) {
            gLUvertex = o2;
            o2 = d2;
            d2 = gLUvertex;
        }
        if (!Geom.VertLeq(o1, o2)) {
            gLUvertex = o1;
            o1 = o2;
            o2 = gLUvertex;
            gLUvertex = d1;
            d1 = d2;
            d2 = gLUvertex;
        }
        if (!Geom.VertLeq(o2, d1)) {
            v.s = (o2.s + d1.s) / 2.0;
        } else if (Geom.VertLeq(d1, d2)) {
            d3 = Geom.EdgeEval(o1, o2, d1);
            if (d3 + (d = Geom.EdgeEval(o2, d1, d2)) < 0.0) {
                d3 = -d3;
                d = -d;
            }
            v.s = Geom.Interpolate(d3, o2.s, d, d1.s);
        } else {
            d3 = Geom.EdgeSign(o1, o2, d1);
            if (d3 + (d = -Geom.EdgeSign(o1, d2, d1)) < 0.0) {
                d3 = -d3;
                d = -d;
            }
            v.s = Geom.Interpolate(d3, o2.s, d, d2.s);
        }
        if (!Geom.TransLeq(o1, d1)) {
            gLUvertex = o1;
            o1 = d1;
            d1 = gLUvertex;
        }
        if (!Geom.TransLeq(o2, d2)) {
            gLUvertex = o2;
            o2 = d2;
            d2 = gLUvertex;
        }
        if (!Geom.TransLeq(o1, o2)) {
            gLUvertex = o2;
            o2 = o1;
            o1 = gLUvertex;
            gLUvertex = d2;
            d2 = d1;
            d1 = gLUvertex;
        }
        if (!Geom.TransLeq(o2, d1)) {
            v.t = (o2.t + d1.t) / 2.0;
        } else if (Geom.TransLeq(d1, d2)) {
            d3 = Geom.TransEval(o1, o2, d1);
            if (d3 + (d = Geom.TransEval(o2, d1, d2)) < 0.0) {
                d3 = -d3;
                d = -d;
            }
            v.t = Geom.Interpolate(d3, o2.t, d, d1.t);
        } else {
            d3 = Geom.TransSign(o1, o2, d1);
            if (d3 + (d = -Geom.TransSign(o1, d2, d1)) < 0.0) {
                d3 = -d3;
                d = -d;
            }
            v.t = Geom.Interpolate(d3, o2.t, d, d2.t);
        }
    }

    static boolean VertEq(GLUvertex u, GLUvertex v) {
        return u.s == v.s && u.t == v.t;
    }

    static boolean VertLeq(GLUvertex u, GLUvertex v) {
        return u.s < v.s || u.s == v.s && u.t <= v.t;
    }

    static boolean TransLeq(GLUvertex u, GLUvertex v) {
        return u.t < v.t || u.t == v.t && u.s <= v.s;
    }

    static boolean EdgeGoesLeft(GLUhalfEdge e) {
        return Geom.VertLeq(e.Sym.Org, e.Org);
    }

    static boolean EdgeGoesRight(GLUhalfEdge e) {
        return Geom.VertLeq(e.Org, e.Sym.Org);
    }

    static double VertL1dist(GLUvertex u, GLUvertex v) {
        return Math.abs(u.s - v.s) + Math.abs(u.t - v.t);
    }
}

