/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu.tessellation;

import org.lwjglx.util.glu.tessellation.GLUface;
import org.lwjglx.util.glu.tessellation.GLUhalfEdge;
import org.lwjglx.util.glu.tessellation.GLUmesh;
import org.lwjglx.util.glu.tessellation.GLUvertex;

class Mesh {
    private Mesh() {
    }

    static GLUhalfEdge MakeEdge(GLUhalfEdge eNext) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = new GLUhalfEdge(true);
        GLUhalfEdge gLUhalfEdge3 = new GLUhalfEdge(false);
        if (!eNext.first) {
            eNext = eNext.Sym;
        }
        gLUhalfEdge3.next = gLUhalfEdge = eNext.Sym.next;
        gLUhalfEdge.Sym.next = gLUhalfEdge2;
        gLUhalfEdge2.next = eNext;
        eNext.Sym.next = gLUhalfEdge3;
        gLUhalfEdge2.Sym = gLUhalfEdge3;
        gLUhalfEdge2.Onext = gLUhalfEdge2;
        gLUhalfEdge2.Lnext = gLUhalfEdge3;
        gLUhalfEdge2.Org = null;
        gLUhalfEdge2.Lface = null;
        gLUhalfEdge2.winding = 0;
        gLUhalfEdge2.activeRegion = null;
        gLUhalfEdge3.Sym = gLUhalfEdge2;
        gLUhalfEdge3.Onext = gLUhalfEdge3;
        gLUhalfEdge3.Lnext = gLUhalfEdge2;
        gLUhalfEdge3.Org = null;
        gLUhalfEdge3.Lface = null;
        gLUhalfEdge3.winding = 0;
        gLUhalfEdge3.activeRegion = null;
        return gLUhalfEdge2;
    }

    static void Splice(GLUhalfEdge a, GLUhalfEdge b) {
        GLUhalfEdge gLUhalfEdge = a.Onext;
        GLUhalfEdge gLUhalfEdge2 = b.Onext;
        gLUhalfEdge.Sym.Lnext = b;
        gLUhalfEdge2.Sym.Lnext = a;
        a.Onext = gLUhalfEdge2;
        b.Onext = gLUhalfEdge;
    }

    static void MakeVertex(GLUvertex newVertex, GLUhalfEdge eOrig, GLUvertex vNext) {
        GLUvertex gLUvertex;
        GLUvertex gLUvertex2 = newVertex;
        assert (gLUvertex2 != null);
        gLUvertex2.prev = gLUvertex = vNext.prev;
        gLUvertex.next = gLUvertex2;
        gLUvertex2.next = vNext;
        vNext.prev = gLUvertex2;
        gLUvertex2.anEdge = eOrig;
        gLUvertex2.data = null;
        GLUhalfEdge gLUhalfEdge = eOrig;
        do {
            gLUhalfEdge.Org = gLUvertex2;
        } while ((gLUhalfEdge = gLUhalfEdge.Onext) != eOrig);
    }

    static void MakeFace(GLUface newFace, GLUhalfEdge eOrig, GLUface fNext) {
        GLUface gLUface;
        GLUface gLUface2 = newFace;
        assert (gLUface2 != null);
        gLUface2.prev = gLUface = fNext.prev;
        gLUface.next = gLUface2;
        gLUface2.next = fNext;
        fNext.prev = gLUface2;
        gLUface2.anEdge = eOrig;
        gLUface2.data = null;
        gLUface2.trail = null;
        gLUface2.marked = false;
        gLUface2.inside = fNext.inside;
        GLUhalfEdge gLUhalfEdge = eOrig;
        do {
            gLUhalfEdge.Lface = gLUface2;
        } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != eOrig);
    }

    static void KillEdge(GLUhalfEdge eDel) {
        GLUhalfEdge gLUhalfEdge;
        if (!eDel.first) {
            eDel = eDel.Sym;
        }
        GLUhalfEdge gLUhalfEdge2 = eDel.next;
        gLUhalfEdge2.Sym.next = gLUhalfEdge = eDel.Sym.next;
        gLUhalfEdge.Sym.next = gLUhalfEdge2;
    }

    static void KillVertex(GLUvertex vDel, GLUvertex newOrg) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge = vDel.anEdge;
        do {
            gLUhalfEdge2.Org = newOrg;
        } while ((gLUhalfEdge2 = gLUhalfEdge2.Onext) != gLUhalfEdge);
        GLUvertex gLUvertex = vDel.prev;
        GLUvertex gLUvertex2 = vDel.next;
        gLUvertex2.prev = gLUvertex;
        gLUvertex.next = gLUvertex2;
    }

    static void KillFace(GLUface fDel, GLUface newLface) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge = fDel.anEdge;
        do {
            gLUhalfEdge2.Lface = newLface;
        } while ((gLUhalfEdge2 = gLUhalfEdge2.Lnext) != gLUhalfEdge);
        GLUface gLUface = fDel.prev;
        GLUface gLUface2 = fDel.next;
        gLUface2.prev = gLUface;
        gLUface.next = gLUface2;
    }

    public static GLUhalfEdge __gl_meshMakeEdge(GLUmesh mesh) {
        GLUvertex gLUvertex = new GLUvertex();
        GLUvertex gLUvertex2 = new GLUvertex();
        GLUface gLUface = new GLUface();
        GLUhalfEdge gLUhalfEdge = Mesh.MakeEdge(mesh.eHead);
        if (gLUhalfEdge == null) {
            return null;
        }
        Mesh.MakeVertex(gLUvertex, gLUhalfEdge, mesh.vHead);
        Mesh.MakeVertex(gLUvertex2, gLUhalfEdge.Sym, mesh.vHead);
        Mesh.MakeFace(gLUface, gLUhalfEdge, mesh.fHead);
        return gLUhalfEdge;
    }

    public static boolean __gl_meshSplice(GLUhalfEdge eOrg, GLUhalfEdge eDst) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (eOrg == eDst) {
            return true;
        }
        if (eDst.Org != eOrg.Org) {
            bl2 = true;
            Mesh.KillVertex(eDst.Org, eOrg.Org);
        }
        if (eDst.Lface != eOrg.Lface) {
            bl = true;
            Mesh.KillFace(eDst.Lface, eOrg.Lface);
        }
        Mesh.Splice(eDst, eOrg);
        if (!bl2) {
            object = new GLUvertex();
            Mesh.MakeVertex((GLUvertex)object, eDst, eOrg.Org);
            eOrg.Org.anEdge = eOrg;
        }
        if (!bl) {
            object = new GLUface();
            Mesh.MakeFace((GLUface)object, eDst, eOrg.Lface);
            eOrg.Lface.anEdge = eOrg;
        }
        return true;
    }

    static boolean __gl_meshDelete(GLUhalfEdge eDel) {
        GLUhalfEdge gLUhalfEdge = eDel.Sym;
        boolean bl = false;
        if (eDel.Lface != eDel.Sym.Lface) {
            bl = true;
            Mesh.KillFace(eDel.Lface, eDel.Sym.Lface);
        }
        if (eDel.Onext == eDel) {
            Mesh.KillVertex(eDel.Org, null);
        } else {
            eDel.Sym.Lface.anEdge = eDel.Sym.Lnext;
            eDel.Org.anEdge = eDel.Onext;
            Mesh.Splice(eDel, eDel.Sym.Lnext);
            if (!bl) {
                GLUface gLUface = new GLUface();
                Mesh.MakeFace(gLUface, eDel, eDel.Lface);
            }
        }
        if (gLUhalfEdge.Onext == gLUhalfEdge) {
            Mesh.KillVertex(gLUhalfEdge.Org, null);
            Mesh.KillFace(gLUhalfEdge.Lface, null);
        } else {
            eDel.Lface.anEdge = gLUhalfEdge.Sym.Lnext;
            gLUhalfEdge.Org.anEdge = gLUhalfEdge.Onext;
            Mesh.Splice(gLUhalfEdge, gLUhalfEdge.Sym.Lnext);
        }
        Mesh.KillEdge(eDel);
        return true;
    }

    static GLUhalfEdge __gl_meshAddEdgeVertex(GLUhalfEdge eOrg) {
        GLUhalfEdge gLUhalfEdge = Mesh.MakeEdge(eOrg);
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.Sym;
        Mesh.Splice(gLUhalfEdge, eOrg.Lnext);
        gLUhalfEdge.Org = eOrg.Sym.Org;
        GLUvertex gLUvertex = new GLUvertex();
        Mesh.MakeVertex(gLUvertex, gLUhalfEdge2, gLUhalfEdge.Org);
        gLUhalfEdge.Lface = gLUhalfEdge2.Lface = eOrg.Lface;
        return gLUhalfEdge;
    }

    public static GLUhalfEdge __gl_meshSplitEdge(GLUhalfEdge eOrg) {
        GLUhalfEdge gLUhalfEdge = Mesh.__gl_meshAddEdgeVertex(eOrg);
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.Sym;
        Mesh.Splice(eOrg.Sym, eOrg.Sym.Sym.Lnext);
        Mesh.Splice(eOrg.Sym, gLUhalfEdge2);
        eOrg.Sym.Org = gLUhalfEdge2.Org;
        gLUhalfEdge2.Sym.Org.anEdge = gLUhalfEdge2.Sym;
        gLUhalfEdge2.Sym.Lface = eOrg.Sym.Lface;
        gLUhalfEdge2.winding = eOrg.winding;
        gLUhalfEdge2.Sym.winding = eOrg.Sym.winding;
        return gLUhalfEdge2;
    }

    static GLUhalfEdge __gl_meshConnect(GLUhalfEdge eOrg, GLUhalfEdge eDst) {
        boolean bl = false;
        GLUhalfEdge gLUhalfEdge = Mesh.MakeEdge(eOrg);
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.Sym;
        if (eDst.Lface != eOrg.Lface) {
            bl = true;
            Mesh.KillFace(eDst.Lface, eOrg.Lface);
        }
        Mesh.Splice(gLUhalfEdge, eOrg.Lnext);
        Mesh.Splice(gLUhalfEdge2, eDst);
        gLUhalfEdge.Org = eOrg.Sym.Org;
        gLUhalfEdge2.Org = eDst.Org;
        gLUhalfEdge.Lface = gLUhalfEdge2.Lface = eOrg.Lface;
        eOrg.Lface.anEdge = gLUhalfEdge2;
        if (!bl) {
            GLUface gLUface = new GLUface();
            Mesh.MakeFace(gLUface, gLUhalfEdge, eOrg.Lface);
        }
        return gLUhalfEdge;
    }

    static void __gl_meshZapFace(GLUface fZap) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = fZap.anEdge;
        GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2.Lnext;
        do {
            gLUhalfEdge = gLUhalfEdge3;
            gLUhalfEdge3 = gLUhalfEdge.Lnext;
            gLUhalfEdge.Lface = null;
            if (gLUhalfEdge.Sym.Lface != null) continue;
            if (gLUhalfEdge.Onext == gLUhalfEdge) {
                Mesh.KillVertex(gLUhalfEdge.Org, null);
            } else {
                gLUhalfEdge.Org.anEdge = gLUhalfEdge.Onext;
                Mesh.Splice(gLUhalfEdge, gLUhalfEdge.Sym.Lnext);
            }
            GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge.Sym;
            if (gLUhalfEdge4.Onext == gLUhalfEdge4) {
                Mesh.KillVertex(gLUhalfEdge4.Org, null);
            } else {
                gLUhalfEdge4.Org.anEdge = gLUhalfEdge4.Onext;
                Mesh.Splice(gLUhalfEdge4, gLUhalfEdge4.Sym.Lnext);
            }
            Mesh.KillEdge(gLUhalfEdge);
        } while (gLUhalfEdge != gLUhalfEdge2);
        GLUface gLUface = fZap.prev;
        GLUface gLUface2 = fZap.next;
        gLUface2.prev = gLUface;
        gLUface.next = gLUface2;
    }

    public static GLUmesh __gl_meshNewMesh() {
        GLUmesh gLUmesh = new GLUmesh();
        GLUvertex gLUvertex = gLUmesh.vHead;
        GLUface gLUface = gLUmesh.fHead;
        GLUhalfEdge gLUhalfEdge = gLUmesh.eHead;
        GLUhalfEdge gLUhalfEdge2 = gLUmesh.eHeadSym;
        gLUvertex.next = gLUvertex.prev = gLUvertex;
        gLUvertex.anEdge = null;
        gLUvertex.data = null;
        gLUface.next = gLUface.prev = gLUface;
        gLUface.anEdge = null;
        gLUface.data = null;
        gLUface.trail = null;
        gLUface.marked = false;
        gLUface.inside = false;
        gLUhalfEdge.next = gLUhalfEdge;
        gLUhalfEdge.Sym = gLUhalfEdge2;
        gLUhalfEdge.Onext = null;
        gLUhalfEdge.Lnext = null;
        gLUhalfEdge.Org = null;
        gLUhalfEdge.Lface = null;
        gLUhalfEdge.winding = 0;
        gLUhalfEdge.activeRegion = null;
        gLUhalfEdge2.next = gLUhalfEdge2;
        gLUhalfEdge2.Sym = gLUhalfEdge;
        gLUhalfEdge2.Onext = null;
        gLUhalfEdge2.Lnext = null;
        gLUhalfEdge2.Org = null;
        gLUhalfEdge2.Lface = null;
        gLUhalfEdge2.winding = 0;
        gLUhalfEdge2.activeRegion = null;
        return gLUmesh;
    }

    static GLUmesh __gl_meshUnion(GLUmesh mesh1, GLUmesh mesh2) {
        GLUface gLUface = mesh1.fHead;
        GLUvertex gLUvertex = mesh1.vHead;
        GLUhalfEdge gLUhalfEdge = mesh1.eHead;
        GLUface gLUface2 = mesh2.fHead;
        GLUvertex gLUvertex2 = mesh2.vHead;
        GLUhalfEdge gLUhalfEdge2 = mesh2.eHead;
        if (gLUface2.next != gLUface2) {
            gLUface.prev.next = gLUface2.next;
            gLUface2.next.prev = gLUface.prev;
            gLUface2.prev.next = gLUface;
            gLUface.prev = gLUface2.prev;
        }
        if (gLUvertex2.next != gLUvertex2) {
            gLUvertex.prev.next = gLUvertex2.next;
            gLUvertex2.next.prev = gLUvertex.prev;
            gLUvertex2.prev.next = gLUvertex;
            gLUvertex.prev = gLUvertex2.prev;
        }
        if (gLUhalfEdge2.next != gLUhalfEdge2) {
            gLUhalfEdge.Sym.next.Sym.next = gLUhalfEdge2.next;
            gLUhalfEdge2.next.Sym.next = gLUhalfEdge.Sym.next;
            gLUhalfEdge2.Sym.next.Sym.next = gLUhalfEdge;
            gLUhalfEdge.Sym.next = gLUhalfEdge2.Sym.next;
        }
        return mesh1;
    }

    static void __gl_meshDeleteMeshZap(GLUmesh mesh) {
        GLUface gLUface = mesh.fHead;
        while (gLUface.next != gLUface) {
            Mesh.__gl_meshZapFace(gLUface.next);
        }
        assert (mesh.vHead.next == mesh.vHead);
    }

    public static void __gl_meshDeleteMesh(GLUmesh mesh) {
        GLUface gLUface = mesh.fHead.next;
        while (gLUface != mesh.fHead) {
            GLUface gLUface2;
            gLUface = gLUface2 = gLUface.next;
        }
        GLUvertex gLUvertex = mesh.vHead.next;
        while (gLUvertex != mesh.vHead) {
            GLUvertex gLUvertex2;
            gLUvertex = gLUvertex2 = gLUvertex.next;
        }
        GLUhalfEdge gLUhalfEdge = mesh.eHead.next;
        while (gLUhalfEdge != mesh.eHead) {
            GLUhalfEdge gLUhalfEdge2;
            gLUhalfEdge = gLUhalfEdge2 = gLUhalfEdge.next;
        }
    }

    public static void __gl_meshCheckMesh(GLUmesh mesh) {
        GLUvertex gLUvertex;
        GLUhalfEdge gLUhalfEdge;
        GLUface gLUface;
        GLUface gLUface2 = mesh.fHead;
        GLUvertex gLUvertex2 = mesh.vHead;
        GLUhalfEdge gLUhalfEdge2 = mesh.eHead;
        GLUface gLUface3 = gLUface2;
        gLUface3 = gLUface2;
        while ((gLUface = gLUface3.next) != gLUface2) {
            assert (gLUface.prev == gLUface3);
            gLUhalfEdge = gLUface.anEdge;
            do {
                assert (gLUhalfEdge.Sym != gLUhalfEdge);
                assert (gLUhalfEdge.Sym.Sym == gLUhalfEdge);
                assert (gLUhalfEdge.Lnext.Onext.Sym == gLUhalfEdge);
                assert (gLUhalfEdge.Onext.Sym.Lnext == gLUhalfEdge);
                assert (gLUhalfEdge.Lface == gLUface);
            } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != gLUface.anEdge);
            gLUface3 = gLUface;
        }
        assert (gLUface.prev == gLUface3 && gLUface.anEdge == null && gLUface.data == null);
        GLUvertex gLUvertex3 = gLUvertex2;
        gLUvertex3 = gLUvertex2;
        while ((gLUvertex = gLUvertex3.next) != gLUvertex2) {
            assert (gLUvertex.prev == gLUvertex3);
            gLUhalfEdge = gLUvertex.anEdge;
            do {
                assert (gLUhalfEdge.Sym != gLUhalfEdge);
                assert (gLUhalfEdge.Sym.Sym == gLUhalfEdge);
                assert (gLUhalfEdge.Lnext.Onext.Sym == gLUhalfEdge);
                assert (gLUhalfEdge.Onext.Sym.Lnext == gLUhalfEdge);
                assert (gLUhalfEdge.Org == gLUvertex);
            } while ((gLUhalfEdge = gLUhalfEdge.Onext) != gLUvertex.anEdge);
            gLUvertex3 = gLUvertex;
        }
        assert (gLUvertex.prev == gLUvertex3 && gLUvertex.anEdge == null && gLUvertex.data == null);
        GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2;
        gLUhalfEdge3 = gLUhalfEdge2;
        while ((gLUhalfEdge = gLUhalfEdge3.next) != gLUhalfEdge2) {
            assert (gLUhalfEdge.Sym.next == gLUhalfEdge3.Sym);
            assert (gLUhalfEdge.Sym != gLUhalfEdge);
            assert (gLUhalfEdge.Sym.Sym == gLUhalfEdge);
            assert (gLUhalfEdge.Org != null);
            assert (gLUhalfEdge.Sym.Org != null);
            assert (gLUhalfEdge.Lnext.Onext.Sym == gLUhalfEdge);
            assert (gLUhalfEdge.Onext.Sym.Lnext == gLUhalfEdge);
            gLUhalfEdge3 = gLUhalfEdge;
        }
        assert (gLUhalfEdge.Sym.next == gLUhalfEdge3.Sym && gLUhalfEdge.Sym == mesh.eHeadSym && gLUhalfEdge.Sym.Sym == gLUhalfEdge && gLUhalfEdge.Org == null && gLUhalfEdge.Sym.Org == null && gLUhalfEdge.Lface == null && gLUhalfEdge.Sym.Lface == null);
    }
}

