/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu.tessellation;

import org.lwjglx.util.glu.tessellation.PriorityQ;
import org.lwjglx.util.glu.tessellation.PriorityQ$Leq;
import org.lwjglx.util.glu.tessellation.PriorityQ$PQhandleElem;
import org.lwjglx.util.glu.tessellation.PriorityQ$PQnode;

class PriorityQHeap
extends PriorityQ {
    PriorityQ$PQnode[] nodes = new PriorityQ$PQnode[33];
    PriorityQ$PQhandleElem[] handles;
    int size = 0;
    int max = 32;
    int freeList;
    boolean initialized;
    PriorityQ$Leq leq;

    PriorityQHeap(PriorityQ$Leq leq) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            this.nodes[n] = new PriorityQ$PQnode();
        }
        this.handles = new PriorityQ$PQhandleElem[33];
        for (n = 0; n < this.handles.length; ++n) {
            this.handles[n] = new PriorityQ$PQhandleElem();
        }
        this.initialized = false;
        this.freeList = 0;
        this.leq = leq;
        this.nodes[1].handle = 1;
        this.handles[1].key = null;
    }

    @Override
    void pqDeletePriorityQ() {
        this.handles = null;
        this.nodes = null;
    }

    void FloatDown(int curr) {
        PriorityQ$PQnode[] priorityQ$PQnodeArray = this.nodes;
        PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray = this.handles;
        int n = priorityQ$PQnodeArray[curr].handle;
        while (true) {
            int n2;
            if ((n2 = curr << 1) < this.size && PriorityQHeap.LEQ(this.leq, priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[n2 + 1].handle].key, priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[n2].handle].key)) {
                ++n2;
            }
            assert (n2 <= this.max);
            int n3 = priorityQ$PQnodeArray[n2].handle;
            if (n2 > this.size || PriorityQHeap.LEQ(this.leq, priorityQ$PQhandleElemArray[n].key, priorityQ$PQhandleElemArray[n3].key)) break;
            priorityQ$PQnodeArray[curr].handle = n3;
            priorityQ$PQhandleElemArray[n3].node = curr;
            curr = n2;
        }
        priorityQ$PQnodeArray[curr].handle = n;
        priorityQ$PQhandleElemArray[n].node = curr;
    }

    void FloatUp(int curr) {
        PriorityQ$PQnode[] priorityQ$PQnodeArray = this.nodes;
        PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray = this.handles;
        int n = priorityQ$PQnodeArray[curr].handle;
        while (true) {
            int n2 = curr >> 1;
            int n3 = priorityQ$PQnodeArray[n2].handle;
            if (n2 == 0 || PriorityQHeap.LEQ(this.leq, priorityQ$PQhandleElemArray[n3].key, priorityQ$PQhandleElemArray[n].key)) break;
            priorityQ$PQnodeArray[curr].handle = n3;
            priorityQ$PQhandleElemArray[n3].node = curr;
            curr = n2;
        }
        priorityQ$PQnodeArray[curr].handle = n;
        priorityQ$PQhandleElemArray[n].node = curr;
    }

    @Override
    boolean pqInit() {
        for (int i = this.size; i >= 1; --i) {
            this.FloatDown(i);
        }
        this.initialized = true;
        return true;
    }

    @Override
    int pqInsert(Object keyNew) {
        int n;
        int n2;
        if ((n2 = ++this.size) * 2 > this.max) {
            PriorityQ$PQnode[] priorityQ$PQnodeArray = this.nodes;
            PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray = this.handles;
            this.max <<= 1;
            PriorityQ$PQnode[] priorityQ$PQnodeArray2 = new PriorityQ$PQnode[this.max + 1];
            System.arraycopy(this.nodes, 0, priorityQ$PQnodeArray2, 0, this.nodes.length);
            for (int i = this.nodes.length; i < priorityQ$PQnodeArray2.length; ++i) {
                priorityQ$PQnodeArray2[i] = new PriorityQ$PQnode();
            }
            this.nodes = priorityQ$PQnodeArray2;
            if (this.nodes == null) {
                this.nodes = priorityQ$PQnodeArray;
                return Integer.MAX_VALUE;
            }
            PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray2 = new PriorityQ$PQhandleElem[this.max + 1];
            System.arraycopy(this.handles, 0, priorityQ$PQhandleElemArray2, 0, this.handles.length);
            for (int i = this.handles.length; i < priorityQ$PQhandleElemArray2.length; ++i) {
                priorityQ$PQhandleElemArray2[i] = new PriorityQ$PQhandleElem();
            }
            this.handles = priorityQ$PQhandleElemArray2;
            if (this.handles == null) {
                this.handles = priorityQ$PQhandleElemArray;
                return Integer.MAX_VALUE;
            }
        }
        if (this.freeList == 0) {
            n = n2;
        } else {
            n = this.freeList;
            this.freeList = this.handles[n].node;
        }
        this.nodes[n2].handle = n;
        this.handles[n].node = n2;
        this.handles[n].key = keyNew;
        if (this.initialized) {
            this.FloatUp(n2);
        }
        assert (n != Integer.MAX_VALUE);
        return n;
    }

    @Override
    Object pqExtractMin() {
        PriorityQ$PQnode[] priorityQ$PQnodeArray = this.nodes;
        PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray = this.handles;
        int n = priorityQ$PQnodeArray[1].handle;
        Object object = priorityQ$PQhandleElemArray[n].key;
        if (this.size > 0) {
            priorityQ$PQnodeArray[1].handle = priorityQ$PQnodeArray[this.size].handle;
            priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[1].handle].node = 1;
            priorityQ$PQhandleElemArray[n].key = null;
            priorityQ$PQhandleElemArray[n].node = this.freeList;
            this.freeList = n;
            if (--this.size > 0) {
                this.FloatDown(1);
            }
        }
        return object;
    }

    @Override
    void pqDelete(int hCurr) {
        PriorityQ$PQnode[] priorityQ$PQnodeArray = this.nodes;
        PriorityQ$PQhandleElem[] priorityQ$PQhandleElemArray = this.handles;
        assert (hCurr >= 1 && hCurr <= this.max && priorityQ$PQhandleElemArray[hCurr].key != null);
        int n = priorityQ$PQhandleElemArray[hCurr].node;
        priorityQ$PQnodeArray[n].handle = priorityQ$PQnodeArray[this.size].handle;
        priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[n].handle].node = n;
        if (n <= --this.size) {
            if (n <= 1 || PriorityQHeap.LEQ(this.leq, priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[n >> 1].handle].key, priorityQ$PQhandleElemArray[priorityQ$PQnodeArray[n].handle].key)) {
                this.FloatDown(n);
            } else {
                this.FloatUp(n);
            }
        }
        priorityQ$PQhandleElemArray[hCurr].key = null;
        priorityQ$PQhandleElemArray[hCurr].node = this.freeList;
        this.freeList = hCurr;
    }

    @Override
    Object pqMinimum() {
        return this.handles[this.nodes[1].handle].key;
    }

    @Override
    boolean pqIsEmpty() {
        return this.size == 0;
    }
}

