/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu.tessellation;

import org.lwjglx.util.glu.tessellation.CachedVertex;
import org.lwjglx.util.glu.tessellation.GLUface;
import org.lwjglx.util.glu.tessellation.GLUhalfEdge;
import org.lwjglx.util.glu.tessellation.GLUmesh;
import org.lwjglx.util.glu.tessellation.GLUtessellatorImpl;
import org.lwjglx.util.glu.tessellation.Render$FaceCount;
import org.lwjglx.util.glu.tessellation.Render$RenderFan;
import org.lwjglx.util.glu.tessellation.Render$RenderStrip;
import org.lwjglx.util.glu.tessellation.Render$RenderTriangle;

class Render {
    private static final boolean USE_OPTIMIZED_CODE_PATH = false;
    private static final Render$RenderFan renderFan = new Render$RenderFan();
    private static final Render$RenderStrip renderStrip = new Render$RenderStrip();
    private static final Render$RenderTriangle renderTriangle = new Render$RenderTriangle();
    private static final int SIGN_INCONSISTENT = 2;

    private Render() {
    }

    public static void __gl_renderMesh(GLUtessellatorImpl tess, GLUmesh mesh) {
        tess.lonelyTriList = null;
        GLUface gLUface = mesh.fHead.next;
        while (gLUface != mesh.fHead) {
            gLUface.marked = false;
            gLUface = gLUface.next;
        }
        gLUface = mesh.fHead.next;
        while (gLUface != mesh.fHead) {
            if (gLUface.inside && !gLUface.marked) {
                Render.RenderMaximumFaceGroup(tess, gLUface);
                assert (gLUface.marked);
            }
            gLUface = gLUface.next;
        }
        if (tess.lonelyTriList != null) {
            Render.RenderLonelyTriangles(tess, tess.lonelyTriList);
            tess.lonelyTriList = null;
        }
    }

    static void RenderMaximumFaceGroup(GLUtessellatorImpl tess, GLUface fOrig) {
        GLUhalfEdge gLUhalfEdge = fOrig.anEdge;
        Render$FaceCount render$FaceCount = new Render$FaceCount();
        render$FaceCount.size = 1L;
        render$FaceCount.eStart = gLUhalfEdge;
        render$FaceCount.render = renderTriangle;
        if (!tess.flagBoundary) {
            Render$FaceCount render$FaceCount2 = Render.MaximumFan(gLUhalfEdge);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
            render$FaceCount2 = Render.MaximumFan(gLUhalfEdge.Lnext);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
            render$FaceCount2 = Render.MaximumFan(gLUhalfEdge.Onext.Sym);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
            render$FaceCount2 = Render.MaximumStrip(gLUhalfEdge);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
            render$FaceCount2 = Render.MaximumStrip(gLUhalfEdge.Lnext);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
            render$FaceCount2 = Render.MaximumStrip(gLUhalfEdge.Onext.Sym);
            if (render$FaceCount2.size > render$FaceCount.size) {
                render$FaceCount = render$FaceCount2;
            }
        }
        render$FaceCount.render.render(tess, render$FaceCount.eStart, render$FaceCount.size);
    }

    private static boolean Marked(GLUface f) {
        return !f.inside || f.marked;
    }

    private static GLUface AddToTrail(GLUface f, GLUface t) {
        f.trail = t;
        f.marked = true;
        return f;
    }

    private static void FreeTrail(GLUface t) {
        while (t != null) {
            t.marked = false;
            t = t.trail;
        }
    }

    static Render$FaceCount MaximumFan(GLUhalfEdge eOrig) {
        Render$FaceCount render$FaceCount = new Render$FaceCount(0L, null, renderFan);
        GLUface gLUface = null;
        GLUhalfEdge gLUhalfEdge = eOrig;
        while (!Render.Marked(gLUhalfEdge.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge.Lface, gLUface);
            ++render$FaceCount.size;
            gLUhalfEdge = gLUhalfEdge.Onext;
        }
        gLUhalfEdge = eOrig;
        while (!Render.Marked(gLUhalfEdge.Sym.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge.Sym.Lface, gLUface);
            ++render$FaceCount.size;
            gLUhalfEdge = gLUhalfEdge.Sym.Lnext;
        }
        render$FaceCount.eStart = gLUhalfEdge;
        Render.FreeTrail(gLUface);
        return render$FaceCount;
    }

    private static boolean IsEven(long n) {
        return (n & 1L) == 0L;
    }

    static Render$FaceCount MaximumStrip(GLUhalfEdge eOrig) {
        Render$FaceCount render$FaceCount = new Render$FaceCount(0L, null, renderStrip);
        long l = 0L;
        long l2 = 0L;
        GLUface gLUface = null;
        GLUhalfEdge gLUhalfEdge = eOrig;
        while (!Render.Marked(gLUhalfEdge.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge.Lface, gLUface);
            ++l2;
            gLUhalfEdge = gLUhalfEdge.Lnext.Sym;
            if (Render.Marked(gLUhalfEdge.Lface)) break;
            gLUface = Render.AddToTrail(gLUhalfEdge.Lface, gLUface);
            ++l2;
            gLUhalfEdge = gLUhalfEdge.Onext;
        }
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge;
        gLUhalfEdge = eOrig;
        while (!Render.Marked(gLUhalfEdge.Sym.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge.Sym.Lface, gLUface);
            ++l;
            gLUhalfEdge = gLUhalfEdge.Sym.Lnext;
            if (Render.Marked(gLUhalfEdge.Sym.Lface)) break;
            gLUface = Render.AddToTrail(gLUhalfEdge.Sym.Lface, gLUface);
            ++l;
            gLUhalfEdge = gLUhalfEdge.Sym.Onext.Sym;
        }
        GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge;
        render$FaceCount.size = l2 + l;
        if (Render.IsEven(l2)) {
            render$FaceCount.eStart = gLUhalfEdge2.Sym;
        } else if (Render.IsEven(l)) {
            render$FaceCount.eStart = gLUhalfEdge3;
        } else {
            --render$FaceCount.size;
            render$FaceCount.eStart = gLUhalfEdge3.Onext;
        }
        Render.FreeTrail(gLUface);
        return render$FaceCount;
    }

    static void RenderLonelyTriangles(GLUtessellatorImpl tess, GLUface f) {
        int n = -1;
        tess.callBeginOrBeginData(4);
        while (f != null) {
            GLUhalfEdge gLUhalfEdge = f.anEdge;
            do {
                if (tess.flagBoundary) {
                    int n2;
                    int n3 = n2 = !gLUhalfEdge.Sym.Lface.inside ? 1 : 0;
                    if (n != n2) {
                        n = n2;
                        tess.callEdgeFlagOrEdgeFlagData(n != 0);
                    }
                }
                tess.callVertexOrVertexData(gLUhalfEdge.Org.data);
            } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != f.anEdge);
            f = f.trail;
        }
        tess.callEndOrEndData();
    }

    public static void __gl_renderBoundary(GLUtessellatorImpl tess, GLUmesh mesh) {
        GLUface gLUface = mesh.fHead.next;
        while (gLUface != mesh.fHead) {
            if (gLUface.inside) {
                tess.callBeginOrBeginData(2);
                GLUhalfEdge gLUhalfEdge = gLUface.anEdge;
                do {
                    tess.callVertexOrVertexData(gLUhalfEdge.Org.data);
                } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != gLUface.anEdge);
                tess.callEndOrEndData();
            }
            gLUface = gLUface.next;
        }
    }

    static int ComputeNormal(GLUtessellatorImpl tess, double[] norm, boolean check) {
        CachedVertex[] cachedVertexArray = tess.cache;
        int n = tess.cacheCount;
        double[] dArray = new double[3];
        int n2 = 0;
        if (!check) {
            norm[2] = 0.0;
            norm[1] = 0.0;
            norm[0] = 0.0;
        }
        int n3 = 1;
        double d = cachedVertexArray[n3].coords[0] - cachedVertexArray[0].coords[0];
        double d2 = cachedVertexArray[n3].coords[1] - cachedVertexArray[0].coords[1];
        double d3 = cachedVertexArray[n3].coords[2] - cachedVertexArray[0].coords[2];
        while (++n3 < n) {
            double d4 = d;
            double d5 = d2;
            double d6 = d3;
            d = cachedVertexArray[n3].coords[0] - cachedVertexArray[0].coords[0];
            d2 = cachedVertexArray[n3].coords[1] - cachedVertexArray[0].coords[1];
            d3 = cachedVertexArray[n3].coords[2] - cachedVertexArray[0].coords[2];
            dArray[0] = d5 * d3 - d6 * d2;
            dArray[1] = d6 * d - d4 * d3;
            dArray[2] = d4 * d2 - d5 * d;
            double d7 = dArray[0] * norm[0] + dArray[1] * norm[1] + dArray[2] * norm[2];
            if (!check) {
                if (d7 >= 0.0) {
                    norm[0] = norm[0] + dArray[0];
                    norm[1] = norm[1] + dArray[1];
                    norm[2] = norm[2] + dArray[2];
                    continue;
                }
                norm[0] = norm[0] - dArray[0];
                norm[1] = norm[1] - dArray[1];
                norm[2] = norm[2] - dArray[2];
                continue;
            }
            if (d7 == 0.0) continue;
            if (d7 > 0.0) {
                if (n2 < 0) {
                    return 2;
                }
                n2 = 1;
                continue;
            }
            if (n2 > 0) {
                return 2;
            }
            n2 = -1;
        }
        return n2;
    }

    public static boolean __gl_renderCache(GLUtessellatorImpl tess) {
        int n;
        CachedVertex[] cachedVertexArray = tess.cache;
        int n2 = tess.cacheCount;
        double[] dArray = new double[3];
        if (tess.cacheCount < 3) {
            return true;
        }
        dArray[0] = tess.normal[0];
        dArray[1] = tess.normal[1];
        dArray[2] = tess.normal[2];
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            Render.ComputeNormal(tess, dArray, false);
        }
        if ((n = Render.ComputeNormal(tess, dArray, true)) == 2) {
            return false;
        }
        return n == 0;
    }
}

