/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.glu.tessellation;

import org.lwjglx.util.glu.tessellation.ActiveRegion;
import org.lwjglx.util.glu.tessellation.Dict;
import org.lwjglx.util.glu.tessellation.DictNode;
import org.lwjglx.util.glu.tessellation.GLUface;
import org.lwjglx.util.glu.tessellation.GLUhalfEdge;
import org.lwjglx.util.glu.tessellation.GLUmesh;
import org.lwjglx.util.glu.tessellation.GLUtessellatorImpl;
import org.lwjglx.util.glu.tessellation.GLUvertex;
import org.lwjglx.util.glu.tessellation.Geom;
import org.lwjglx.util.glu.tessellation.Mesh;
import org.lwjglx.util.glu.tessellation.PriorityQ;

class Sweep {
    private static final boolean TOLERANCE_NONZERO = false;
    private static final double SENTINEL_COORD = 4.0E150;

    private Sweep() {
    }

    private static void DebugEvent(GLUtessellatorImpl tess) {
    }

    private static void AddWinding(GLUhalfEdge eDst, GLUhalfEdge eSrc) {
        eDst.winding += eSrc.winding;
        eDst.Sym.winding += eSrc.Sym.winding;
    }

    private static ActiveRegion RegionBelow(ActiveRegion r) {
        return (ActiveRegion)Dict.dictKey(Dict.dictPred(r.nodeUp));
    }

    private static ActiveRegion RegionAbove(ActiveRegion r) {
        return (ActiveRegion)Dict.dictKey(Dict.dictSucc(r.nodeUp));
    }

    static boolean EdgeLeq(GLUtessellatorImpl tess, ActiveRegion reg1, ActiveRegion reg2) {
        double d;
        GLUvertex gLUvertex = tess.event;
        GLUhalfEdge gLUhalfEdge = reg1.eUp;
        GLUhalfEdge gLUhalfEdge2 = reg2.eUp;
        if (gLUhalfEdge.Sym.Org == gLUvertex) {
            if (gLUhalfEdge2.Sym.Org == gLUvertex) {
                if (Geom.VertLeq(gLUhalfEdge.Org, gLUhalfEdge2.Org)) {
                    return Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Org, gLUhalfEdge2.Org) <= 0.0;
                }
                return Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Org, gLUhalfEdge.Org) >= 0.0;
            }
            return Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUvertex, gLUhalfEdge2.Org) <= 0.0;
        }
        if (gLUhalfEdge2.Sym.Org == gLUvertex) {
            return Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUvertex, gLUhalfEdge.Org) >= 0.0;
        }
        double d2 = Geom.EdgeEval(gLUhalfEdge.Sym.Org, gLUvertex, gLUhalfEdge.Org);
        return d2 >= (d = Geom.EdgeEval(gLUhalfEdge2.Sym.Org, gLUvertex, gLUhalfEdge2.Org));
    }

    static void DeleteRegion(GLUtessellatorImpl tess, ActiveRegion reg) {
        if (reg.fixUpperEdge) assert (reg.eUp.winding == 0);
        reg.eUp.activeRegion = null;
        Dict.dictDelete(tess.dict, reg.nodeUp);
    }

    static boolean FixUpperEdge(ActiveRegion reg, GLUhalfEdge newEdge) {
        assert (reg.fixUpperEdge);
        if (!Mesh.__gl_meshDelete(reg.eUp)) {
            return false;
        }
        reg.fixUpperEdge = false;
        reg.eUp = newEdge;
        newEdge.activeRegion = reg;
        return true;
    }

    static ActiveRegion TopLeftRegion(ActiveRegion reg) {
        GLUvertex gLUvertex = reg.eUp.Org;
        do {
            reg = Sweep.RegionAbove(reg);
        } while (reg.eUp.Org == gLUvertex);
        if (reg.fixUpperEdge) {
            GLUhalfEdge gLUhalfEdge = Mesh.__gl_meshConnect(Sweep.RegionBelow((ActiveRegion)reg).eUp.Sym, reg.eUp.Lnext);
            if (gLUhalfEdge == null) {
                return null;
            }
            if (!Sweep.FixUpperEdge(reg, gLUhalfEdge)) {
                return null;
            }
            reg = Sweep.RegionAbove(reg);
        }
        return reg;
    }

    static ActiveRegion TopRightRegion(ActiveRegion reg) {
        GLUvertex gLUvertex = reg.eUp.Sym.Org;
        do {
            reg = Sweep.RegionAbove(reg);
        } while (reg.eUp.Sym.Org == gLUvertex);
        return reg;
    }

    static ActiveRegion AddRegionBelow(GLUtessellatorImpl tess, ActiveRegion regAbove, GLUhalfEdge eNewUp) {
        ActiveRegion activeRegion = new ActiveRegion();
        activeRegion.eUp = eNewUp;
        activeRegion.nodeUp = Dict.dictInsertBefore(tess.dict, regAbove.nodeUp, activeRegion);
        if (activeRegion.nodeUp == null) {
            throw new RuntimeException();
        }
        activeRegion.fixUpperEdge = false;
        activeRegion.sentinel = false;
        activeRegion.dirty = false;
        eNewUp.activeRegion = activeRegion;
        return activeRegion;
    }

    static boolean IsWindingInside(GLUtessellatorImpl tess, int n) {
        switch (tess.windingRule) {
            case 100130: {
                return (n & 1) != 0;
            }
            case 100131: {
                return n != 0;
            }
            case 100132: {
                return n > 0;
            }
            case 100133: {
                return n < 0;
            }
            case 100134: {
                return n >= 2 || n <= -2;
            }
        }
        throw new InternalError();
    }

    static void ComputeWinding(GLUtessellatorImpl tess, ActiveRegion reg) {
        reg.windingNumber = Sweep.RegionAbove((ActiveRegion)reg).windingNumber + reg.eUp.winding;
        reg.inside = Sweep.IsWindingInside(tess, reg.windingNumber);
    }

    static void FinishRegion(GLUtessellatorImpl tess, ActiveRegion reg) {
        GLUhalfEdge gLUhalfEdge = reg.eUp;
        GLUface gLUface = gLUhalfEdge.Lface;
        gLUface.inside = reg.inside;
        gLUface.anEdge = gLUhalfEdge;
        Sweep.DeleteRegion(tess, reg);
    }

    static GLUhalfEdge FinishLeftRegions(GLUtessellatorImpl tess, ActiveRegion regFirst, ActiveRegion regLast) {
        ActiveRegion activeRegion = regFirst;
        GLUhalfEdge gLUhalfEdge = regFirst.eUp;
        while (activeRegion != regLast) {
            activeRegion.fixUpperEdge = false;
            ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
            GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
            if (gLUhalfEdge2.Org != gLUhalfEdge.Org) {
                if (!activeRegion2.fixUpperEdge) {
                    Sweep.FinishRegion(tess, activeRegion);
                    break;
                }
                gLUhalfEdge2 = Mesh.__gl_meshConnect(gLUhalfEdge.Onext.Sym, gLUhalfEdge2.Sym);
                if (gLUhalfEdge2 == null) {
                    throw new RuntimeException();
                }
                if (!Sweep.FixUpperEdge(activeRegion2, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            if (gLUhalfEdge.Onext != gLUhalfEdge2) {
                if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            Sweep.FinishRegion(tess, activeRegion);
            gLUhalfEdge = activeRegion2.eUp;
            activeRegion = activeRegion2;
        }
        return gLUhalfEdge;
    }

    static void AddRightEdges(GLUtessellatorImpl tess, ActiveRegion regUp, GLUhalfEdge eFirst, GLUhalfEdge eLast, GLUhalfEdge eTopLeft, boolean cleanUp) {
        ActiveRegion activeRegion;
        boolean bl = true;
        GLUhalfEdge gLUhalfEdge = eFirst;
        do {
            assert (Geom.VertLeq(gLUhalfEdge.Org, gLUhalfEdge.Sym.Org));
            Sweep.AddRegionBelow(tess, regUp, gLUhalfEdge.Sym);
        } while ((gLUhalfEdge = gLUhalfEdge.Onext) != eLast);
        if (eTopLeft == null) {
            eTopLeft = Sweep.RegionBelow((ActiveRegion)regUp).eUp.Sym.Onext;
        }
        ActiveRegion activeRegion2 = regUp;
        GLUhalfEdge gLUhalfEdge2 = eTopLeft;
        while (true) {
            activeRegion = Sweep.RegionBelow(activeRegion2);
            gLUhalfEdge = activeRegion.eUp.Sym;
            if (gLUhalfEdge.Org != gLUhalfEdge2.Org) break;
            if (gLUhalfEdge.Onext != gLUhalfEdge2) {
                if (!Mesh.__gl_meshSplice(gLUhalfEdge.Sym.Lnext, gLUhalfEdge)) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge)) {
                    throw new RuntimeException();
                }
            }
            activeRegion.windingNumber = activeRegion2.windingNumber - gLUhalfEdge.winding;
            activeRegion.inside = Sweep.IsWindingInside(tess, activeRegion.windingNumber);
            activeRegion2.dirty = true;
            if (!bl && Sweep.CheckForRightSplice(tess, activeRegion2)) {
                Sweep.AddWinding(gLUhalfEdge, gLUhalfEdge2);
                Sweep.DeleteRegion(tess, activeRegion2);
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            bl = false;
            activeRegion2 = activeRegion;
            gLUhalfEdge2 = gLUhalfEdge;
        }
        activeRegion2.dirty = true;
        assert (activeRegion2.windingNumber - gLUhalfEdge.winding == activeRegion.windingNumber);
        if (cleanUp) {
            Sweep.WalkDirtyRegions(tess, activeRegion2);
        }
    }

    static void CallCombine(GLUtessellatorImpl tess, GLUvertex isect, Object[] data, float[] weights, boolean needed) {
        double[] dArray = new double[]{isect.coords[0], isect.coords[1], isect.coords[2]};
        Object[] objectArray = new Object[1];
        tess.callCombineOrCombineData(dArray, data, weights, objectArray);
        isect.data = objectArray[0];
        if (isect.data == null) {
            if (!needed) {
                isect.data = data[0];
            } else if (!tess.fatalError) {
                tess.callErrorOrErrorData(100156);
                tess.fatalError = true;
            }
        }
    }

    static void SpliceMergeVertices(GLUtessellatorImpl tess, GLUhalfEdge e1, GLUhalfEdge e2) {
        Object[] objectArray = new Object[4];
        float[] fArray = new float[]{0.5f, 0.5f, 0.0f, 0.0f};
        objectArray[0] = e1.Org.data;
        objectArray[1] = e2.Org.data;
        Sweep.CallCombine(tess, e1.Org, objectArray, fArray, false);
        if (!Mesh.__gl_meshSplice(e1, e2)) {
            throw new RuntimeException();
        }
    }

    static void VertexWeights(GLUvertex isect, GLUvertex org, GLUvertex dst, float[] weights) {
        double d = Geom.VertL1dist(org, isect);
        double d2 = Geom.VertL1dist(dst, isect);
        weights[0] = (float)(0.5 * d2 / (d + d2));
        weights[1] = (float)(0.5 * d / (d + d2));
        isect.coords[0] = isect.coords[0] + ((double)weights[0] * org.coords[0] + (double)weights[1] * dst.coords[0]);
        isect.coords[1] = isect.coords[1] + ((double)weights[0] * org.coords[1] + (double)weights[1] * dst.coords[1]);
        isect.coords[2] = isect.coords[2] + ((double)weights[0] * org.coords[2] + (double)weights[1] * dst.coords[2]);
    }

    static void GetIntersectData(GLUtessellatorImpl tess, GLUvertex isect, GLUvertex orgUp, GLUvertex dstUp, GLUvertex orgLo, GLUvertex dstLo) {
        Object[] objectArray = new Object[4];
        float[] fArray = new float[4];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        objectArray[0] = orgUp.data;
        objectArray[1] = dstUp.data;
        objectArray[2] = orgLo.data;
        objectArray[3] = dstLo.data;
        isect.coords[2] = 0.0;
        isect.coords[1] = 0.0;
        isect.coords[0] = 0.0;
        Sweep.VertexWeights(isect, orgUp, dstUp, fArray2);
        Sweep.VertexWeights(isect, orgLo, dstLo, fArray3);
        System.arraycopy(fArray2, 0, fArray, 0, 2);
        System.arraycopy(fArray3, 0, fArray, 2, 2);
        Sweep.CallCombine(tess, isect, objectArray, fArray, true);
    }

    static boolean CheckForRightSplice(GLUtessellatorImpl tess, ActiveRegion regUp) {
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        GLUhalfEdge gLUhalfEdge = regUp.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
        if (Geom.VertLeq(gLUhalfEdge.Org, gLUhalfEdge2.Org)) {
            if (Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Org, gLUhalfEdge2.Org) > 0.0) {
                return false;
            }
            if (!Geom.VertEq(gLUhalfEdge.Org, gLUhalfEdge2.Org)) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge2.Sym.Lnext)) {
                    throw new RuntimeException();
                }
                activeRegion.dirty = true;
                regUp.dirty = true;
            } else if (gLUhalfEdge.Org != gLUhalfEdge2.Org) {
                tess.pq.pqDelete(gLUhalfEdge.Org.pqHandle);
                Sweep.SpliceMergeVertices(tess, gLUhalfEdge2.Sym.Lnext, gLUhalfEdge);
            }
        } else {
            if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Org, gLUhalfEdge.Org) < 0.0) {
                return false;
            }
            regUp.dirty = true;
            Sweep.RegionAbove((ActiveRegion)regUp).dirty = true;
            if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge)) {
                throw new RuntimeException();
            }
        }
        return true;
    }

    static boolean CheckForLeftSplice(GLUtessellatorImpl tess, ActiveRegion regUp) {
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        GLUhalfEdge gLUhalfEdge = regUp.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
        assert (!Geom.VertEq(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org));
        if (Geom.VertLeq(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org)) {
            if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org, gLUhalfEdge.Org) < 0.0) {
                return false;
            }
            regUp.dirty = true;
            Sweep.RegionAbove((ActiveRegion)regUp).dirty = true;
            GLUhalfEdge gLUhalfEdge3 = Mesh.__gl_meshSplitEdge(gLUhalfEdge);
            if (gLUhalfEdge3 == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym, gLUhalfEdge3)) {
                throw new RuntimeException();
            }
            gLUhalfEdge3.Lface.inside = regUp.inside;
        } else {
            if (Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Sym.Org, gLUhalfEdge2.Org) > 0.0) {
                return false;
            }
            activeRegion.dirty = true;
            regUp.dirty = true;
            GLUhalfEdge gLUhalfEdge4 = Mesh.__gl_meshSplitEdge(gLUhalfEdge2);
            if (gLUhalfEdge4 == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge.Lnext, gLUhalfEdge2.Sym)) {
                throw new RuntimeException();
            }
            gLUhalfEdge4.Sym.Lface.inside = regUp.inside;
        }
        return true;
    }

    static boolean CheckForIntersect(GLUtessellatorImpl tess, ActiveRegion regUp) {
        GLUvertex gLUvertex;
        double d;
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        GLUhalfEdge gLUhalfEdge = regUp.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
        GLUvertex gLUvertex2 = gLUhalfEdge.Org;
        GLUvertex gLUvertex3 = gLUhalfEdge2.Org;
        GLUvertex gLUvertex4 = gLUhalfEdge.Sym.Org;
        GLUvertex gLUvertex5 = gLUhalfEdge2.Sym.Org;
        GLUvertex gLUvertex6 = new GLUvertex();
        assert (!Geom.VertEq(gLUvertex5, gLUvertex4));
        assert (Geom.EdgeSign(gLUvertex4, tess.event, gLUvertex2) <= 0.0);
        assert (Geom.EdgeSign(gLUvertex5, tess.event, gLUvertex3) >= 0.0);
        assert (gLUvertex2 != tess.event && gLUvertex3 != tess.event);
        assert (!regUp.fixUpperEdge && !activeRegion.fixUpperEdge);
        if (gLUvertex2 == gLUvertex3) {
            return false;
        }
        double d2 = Math.min(gLUvertex2.t, gLUvertex4.t);
        if (d2 > (d = Math.max(gLUvertex3.t, gLUvertex5.t))) {
            return false;
        }
        if (Geom.VertLeq(gLUvertex2, gLUvertex3) ? Geom.EdgeSign(gLUvertex5, gLUvertex2, gLUvertex3) > 0.0 : Geom.EdgeSign(gLUvertex4, gLUvertex3, gLUvertex2) < 0.0) {
            return false;
        }
        Sweep.DebugEvent(tess);
        Geom.EdgeIntersect(gLUvertex4, gLUvertex2, gLUvertex5, gLUvertex3, gLUvertex6);
        assert (Math.min(gLUvertex2.t, gLUvertex4.t) <= gLUvertex6.t);
        assert (gLUvertex6.t <= Math.max(gLUvertex3.t, gLUvertex5.t));
        assert (Math.min(gLUvertex5.s, gLUvertex4.s) <= gLUvertex6.s);
        assert (gLUvertex6.s <= Math.max(gLUvertex3.s, gLUvertex2.s));
        if (Geom.VertLeq(gLUvertex6, tess.event)) {
            gLUvertex6.s = tess.event.s;
            gLUvertex6.t = tess.event.t;
        }
        GLUvertex gLUvertex7 = gLUvertex = Geom.VertLeq(gLUvertex2, gLUvertex3) ? gLUvertex2 : gLUvertex3;
        if (Geom.VertLeq(gLUvertex, gLUvertex6)) {
            gLUvertex6.s = gLUvertex.s;
            gLUvertex6.t = gLUvertex.t;
        }
        if (Geom.VertEq(gLUvertex6, gLUvertex2) || Geom.VertEq(gLUvertex6, gLUvertex3)) {
            Sweep.CheckForRightSplice(tess, regUp);
            return false;
        }
        if (!Geom.VertEq(gLUvertex4, tess.event) && Geom.EdgeSign(gLUvertex4, tess.event, gLUvertex6) >= 0.0 || !Geom.VertEq(gLUvertex5, tess.event) && Geom.EdgeSign(gLUvertex5, tess.event, gLUvertex6) <= 0.0) {
            if (gLUvertex5 == tess.event) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym, gLUhalfEdge)) {
                    throw new RuntimeException();
                }
                if ((regUp = Sweep.TopLeftRegion(regUp)) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge = Sweep.RegionBelow((ActiveRegion)regUp).eUp;
                Sweep.FinishLeftRegions(tess, Sweep.RegionBelow(regUp), activeRegion);
                Sweep.AddRightEdges(tess, regUp, gLUhalfEdge.Sym.Lnext, gLUhalfEdge, gLUhalfEdge, true);
                return true;
            }
            if (gLUvertex4 == tess.event) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge.Lnext, gLUhalfEdge2.Sym.Lnext)) {
                    throw new RuntimeException();
                }
                activeRegion = regUp;
                regUp = Sweep.TopRightRegion(regUp);
                GLUhalfEdge gLUhalfEdge3 = Sweep.RegionBelow((ActiveRegion)regUp).eUp.Sym.Onext;
                activeRegion.eUp = gLUhalfEdge2.Sym.Lnext;
                gLUhalfEdge2 = Sweep.FinishLeftRegions(tess, activeRegion, null);
                Sweep.AddRightEdges(tess, regUp, gLUhalfEdge2.Onext, gLUhalfEdge.Sym.Onext, gLUhalfEdge3, true);
                return true;
            }
            if (Geom.EdgeSign(gLUvertex4, tess.event, gLUvertex6) >= 0.0) {
                regUp.dirty = true;
                Sweep.RegionAbove((ActiveRegion)regUp).dirty = true;
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge.Org.s = tess.event.s;
                gLUhalfEdge.Org.t = tess.event.t;
            }
            if (Geom.EdgeSign(gLUvertex5, tess.event, gLUvertex6) <= 0.0) {
                activeRegion.dirty = true;
                regUp.dirty = true;
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge2.Org.s = tess.event.s;
                gLUhalfEdge2.Org.t = tess.event.t;
            }
            return false;
        }
        if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
            throw new RuntimeException();
        }
        if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
            throw new RuntimeException();
        }
        if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge)) {
            throw new RuntimeException();
        }
        gLUhalfEdge.Org.s = gLUvertex6.s;
        gLUhalfEdge.Org.t = gLUvertex6.t;
        gLUhalfEdge.Org.pqHandle = tess.pq.pqInsert(gLUhalfEdge.Org);
        if ((long)gLUhalfEdge.Org.pqHandle == Long.MAX_VALUE) {
            tess.pq.pqDeletePriorityQ();
            tess.pq = null;
            throw new RuntimeException();
        }
        Sweep.GetIntersectData(tess, gLUhalfEdge.Org, gLUvertex2, gLUvertex4, gLUvertex3, gLUvertex5);
        activeRegion.dirty = true;
        regUp.dirty = true;
        Sweep.RegionAbove((ActiveRegion)regUp).dirty = true;
        return false;
    }

    static void WalkDirtyRegions(GLUtessellatorImpl tess, ActiveRegion regUp) {
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        while (true) {
            if (activeRegion.dirty) {
                regUp = activeRegion;
                activeRegion = Sweep.RegionBelow(activeRegion);
                continue;
            }
            if (!regUp.dirty) {
                activeRegion = regUp;
                if ((regUp = Sweep.RegionAbove(regUp)) == null || !regUp.dirty) {
                    return;
                }
            }
            regUp.dirty = false;
            GLUhalfEdge gLUhalfEdge = regUp.eUp;
            GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
            if (gLUhalfEdge.Sym.Org != gLUhalfEdge2.Sym.Org && Sweep.CheckForLeftSplice(tess, regUp)) {
                if (activeRegion.fixUpperEdge) {
                    Sweep.DeleteRegion(tess, activeRegion);
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                        throw new RuntimeException();
                    }
                    activeRegion = Sweep.RegionBelow(regUp);
                    gLUhalfEdge2 = activeRegion.eUp;
                } else if (regUp.fixUpperEdge) {
                    Sweep.DeleteRegion(tess, regUp);
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                        throw new RuntimeException();
                    }
                    regUp = Sweep.RegionAbove(activeRegion);
                    gLUhalfEdge = regUp.eUp;
                }
            }
            if (gLUhalfEdge.Org != gLUhalfEdge2.Org) {
                if (!(gLUhalfEdge.Sym.Org == gLUhalfEdge2.Sym.Org || regUp.fixUpperEdge || activeRegion.fixUpperEdge || gLUhalfEdge.Sym.Org != tess.event && gLUhalfEdge2.Sym.Org != tess.event)) {
                    if (Sweep.CheckForIntersect(tess, regUp)) {
                        return;
                    }
                } else {
                    Sweep.CheckForRightSplice(tess, regUp);
                }
            }
            if (gLUhalfEdge.Org != gLUhalfEdge2.Org || gLUhalfEdge.Sym.Org != gLUhalfEdge2.Sym.Org) continue;
            Sweep.AddWinding(gLUhalfEdge2, gLUhalfEdge);
            Sweep.DeleteRegion(tess, regUp);
            if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                throw new RuntimeException();
            }
            regUp = Sweep.RegionAbove(activeRegion);
        }
    }

    static void ConnectRightVertex(GLUtessellatorImpl tess, ActiveRegion regUp, GLUhalfEdge eBottomLeft) {
        GLUhalfEdge gLUhalfEdge = eBottomLeft.Onext;
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        GLUhalfEdge gLUhalfEdge2 = regUp.eUp;
        GLUhalfEdge gLUhalfEdge3 = activeRegion.eUp;
        boolean bl = false;
        if (gLUhalfEdge2.Sym.Org != gLUhalfEdge3.Sym.Org) {
            Sweep.CheckForIntersect(tess, regUp);
        }
        if (Geom.VertEq(gLUhalfEdge2.Org, tess.event)) {
            if (!Mesh.__gl_meshSplice(gLUhalfEdge.Sym.Lnext, gLUhalfEdge2)) {
                throw new RuntimeException();
            }
            if ((regUp = Sweep.TopLeftRegion(regUp)) == null) {
                throw new RuntimeException();
            }
            gLUhalfEdge = Sweep.RegionBelow((ActiveRegion)regUp).eUp;
            Sweep.FinishLeftRegions(tess, Sweep.RegionBelow(regUp), activeRegion);
            bl = true;
        }
        if (Geom.VertEq(gLUhalfEdge3.Org, tess.event)) {
            if (!Mesh.__gl_meshSplice(eBottomLeft, gLUhalfEdge3.Sym.Lnext)) {
                throw new RuntimeException();
            }
            eBottomLeft = Sweep.FinishLeftRegions(tess, activeRegion, null);
            bl = true;
        }
        if (bl) {
            Sweep.AddRightEdges(tess, regUp, eBottomLeft.Onext, gLUhalfEdge, gLUhalfEdge, true);
            return;
        }
        GLUhalfEdge gLUhalfEdge4 = Geom.VertLeq(gLUhalfEdge3.Org, gLUhalfEdge2.Org) ? gLUhalfEdge3.Sym.Lnext : gLUhalfEdge2;
        if ((gLUhalfEdge4 = Mesh.__gl_meshConnect(eBottomLeft.Onext.Sym, gLUhalfEdge4)) == null) {
            throw new RuntimeException();
        }
        Sweep.AddRightEdges(tess, regUp, gLUhalfEdge4, gLUhalfEdge4.Onext, gLUhalfEdge4.Onext, false);
        gLUhalfEdge4.Sym.activeRegion.fixUpperEdge = true;
        Sweep.WalkDirtyRegions(tess, regUp);
    }

    static void ConnectLeftDegenerate(GLUtessellatorImpl tess, ActiveRegion regUp, GLUvertex vEvent) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = regUp.eUp;
        if (Geom.VertEq(gLUhalfEdge2.Org, vEvent)) {
            assert (false);
            Sweep.SpliceMergeVertices(tess, gLUhalfEdge2, vEvent.anEdge);
            return;
        }
        if (!Geom.VertEq(gLUhalfEdge2.Sym.Org, vEvent)) {
            if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                throw new RuntimeException();
            }
            if (regUp.fixUpperEdge) {
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2.Onext)) {
                    throw new RuntimeException();
                }
                regUp.fixUpperEdge = false;
            }
            if (!Mesh.__gl_meshSplice(vEvent.anEdge, gLUhalfEdge2)) {
                throw new RuntimeException();
            }
            Sweep.SweepEvent(tess, vEvent);
            return;
        }
        assert (false);
        regUp = Sweep.TopRightRegion(regUp);
        ActiveRegion activeRegion = Sweep.RegionBelow(regUp);
        GLUhalfEdge gLUhalfEdge3 = activeRegion.eUp.Sym;
        GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge = gLUhalfEdge3.Onext;
        if (activeRegion.fixUpperEdge) {
            assert (gLUhalfEdge4 != gLUhalfEdge3);
            Sweep.DeleteRegion(tess, activeRegion);
            if (!Mesh.__gl_meshDelete(gLUhalfEdge3)) {
                throw new RuntimeException();
            }
            gLUhalfEdge3 = gLUhalfEdge4.Sym.Lnext;
        }
        if (!Mesh.__gl_meshSplice(vEvent.anEdge, gLUhalfEdge3)) {
            throw new RuntimeException();
        }
        if (!Geom.EdgeGoesLeft(gLUhalfEdge4)) {
            gLUhalfEdge4 = null;
        }
        Sweep.AddRightEdges(tess, regUp, gLUhalfEdge3.Onext, gLUhalfEdge, gLUhalfEdge4, true);
    }

    static void ConnectLeftVertex(GLUtessellatorImpl tess, GLUvertex vEvent) {
        ActiveRegion activeRegion;
        ActiveRegion activeRegion2 = new ActiveRegion();
        activeRegion2.eUp = vEvent.anEdge.Sym;
        ActiveRegion activeRegion3 = (ActiveRegion)Dict.dictKey(Dict.dictSearch(tess.dict, activeRegion2));
        ActiveRegion activeRegion4 = Sweep.RegionBelow(activeRegion3);
        GLUhalfEdge gLUhalfEdge = activeRegion3.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion4.eUp;
        if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, vEvent, gLUhalfEdge.Org) == 0.0) {
            Sweep.ConnectLeftDegenerate(tess, activeRegion3, vEvent);
            return;
        }
        ActiveRegion activeRegion5 = activeRegion = Geom.VertLeq(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Sym.Org) ? activeRegion3 : activeRegion4;
        if (activeRegion3.inside || activeRegion.fixUpperEdge) {
            GLUhalfEdge gLUhalfEdge3;
            if (activeRegion == activeRegion3) {
                gLUhalfEdge3 = Mesh.__gl_meshConnect(vEvent.anEdge.Sym, gLUhalfEdge.Lnext);
                if (gLUhalfEdge3 == null) {
                    throw new RuntimeException();
                }
            } else {
                GLUhalfEdge gLUhalfEdge4 = Mesh.__gl_meshConnect(gLUhalfEdge2.Sym.Onext.Sym, vEvent.anEdge);
                if (gLUhalfEdge4 == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge3 = gLUhalfEdge4.Sym;
            }
            if (activeRegion.fixUpperEdge) {
                if (!Sweep.FixUpperEdge(activeRegion, gLUhalfEdge3)) {
                    throw new RuntimeException();
                }
            } else {
                Sweep.ComputeWinding(tess, Sweep.AddRegionBelow(tess, activeRegion3, gLUhalfEdge3));
            }
            Sweep.SweepEvent(tess, vEvent);
        } else {
            Sweep.AddRightEdges(tess, activeRegion3, vEvent.anEdge, vEvent.anEdge, null, true);
        }
    }

    static void SweepEvent(GLUtessellatorImpl tess, GLUvertex vEvent) {
        tess.event = vEvent;
        Sweep.DebugEvent(tess);
        GLUhalfEdge gLUhalfEdge = vEvent.anEdge;
        while (gLUhalfEdge.activeRegion == null) {
            gLUhalfEdge = gLUhalfEdge.Onext;
            if (gLUhalfEdge != vEvent.anEdge) continue;
            Sweep.ConnectLeftVertex(tess, vEvent);
            return;
        }
        ActiveRegion activeRegion = Sweep.TopLeftRegion(gLUhalfEdge.activeRegion);
        if (activeRegion == null) {
            throw new RuntimeException();
        }
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
        GLUhalfEdge gLUhalfEdge3 = Sweep.FinishLeftRegions(tess, activeRegion2, null);
        if (gLUhalfEdge3.Onext == gLUhalfEdge2) {
            Sweep.ConnectRightVertex(tess, activeRegion, gLUhalfEdge3);
        } else {
            Sweep.AddRightEdges(tess, activeRegion, gLUhalfEdge3.Onext, gLUhalfEdge2, gLUhalfEdge2, true);
        }
    }

    static void AddSentinel(GLUtessellatorImpl tess, double t) {
        ActiveRegion activeRegion = new ActiveRegion();
        GLUhalfEdge gLUhalfEdge = Mesh.__gl_meshMakeEdge(tess.mesh);
        if (gLUhalfEdge == null) {
            throw new RuntimeException();
        }
        gLUhalfEdge.Org.s = 4.0E150;
        gLUhalfEdge.Org.t = t;
        gLUhalfEdge.Sym.Org.s = -4.0E150;
        gLUhalfEdge.Sym.Org.t = t;
        tess.event = gLUhalfEdge.Sym.Org;
        activeRegion.eUp = gLUhalfEdge;
        activeRegion.windingNumber = 0;
        activeRegion.inside = false;
        activeRegion.fixUpperEdge = false;
        activeRegion.sentinel = true;
        activeRegion.dirty = false;
        activeRegion.nodeUp = Dict.dictInsert(tess.dict, activeRegion);
        if (activeRegion.nodeUp == null) {
            throw new RuntimeException();
        }
    }

    static void InitEdgeDict(GLUtessellatorImpl tess) {
        tess.dict = Dict.dictNewDict(tess, (frame, key1, key2) -> Sweep.EdgeLeq(tess, (ActiveRegion)key1, (ActiveRegion)key2));
        if (tess.dict == null) {
            throw new RuntimeException();
        }
        Sweep.AddSentinel(tess, -4.0E150);
        Sweep.AddSentinel(tess, 4.0E150);
    }

    static void DoneEdgeDict(GLUtessellatorImpl tess) {
        ActiveRegion activeRegion;
        int n = 0;
        while ((activeRegion = (ActiveRegion)Dict.dictKey(Dict.dictMin(tess.dict))) != null) {
            if (!activeRegion.sentinel) {
                assert (activeRegion.fixUpperEdge);
                assert (++n == 1);
            }
            assert (activeRegion.windingNumber == 0);
            Sweep.DeleteRegion(tess, activeRegion);
        }
        Dict.dictDeleteDict(tess.dict);
    }

    static void RemoveDegenerateEdges(GLUtessellatorImpl tess) {
        GLUhalfEdge gLUhalfEdge = tess.mesh.eHead;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.next;
        while (gLUhalfEdge2 != gLUhalfEdge) {
            GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2.next;
            GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge2.Lnext;
            if (Geom.VertEq(gLUhalfEdge2.Org, gLUhalfEdge2.Sym.Org) && gLUhalfEdge2.Lnext.Lnext != gLUhalfEdge2) {
                Sweep.SpliceMergeVertices(tess, gLUhalfEdge4, gLUhalfEdge2);
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
                gLUhalfEdge2 = gLUhalfEdge4;
                gLUhalfEdge4 = gLUhalfEdge2.Lnext;
            }
            if (gLUhalfEdge4.Lnext == gLUhalfEdge2) {
                if (gLUhalfEdge4 != gLUhalfEdge2) {
                    if (gLUhalfEdge4 == gLUhalfEdge3 || gLUhalfEdge4 == gLUhalfEdge3.Sym) {
                        gLUhalfEdge3 = gLUhalfEdge3.next;
                    }
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge4)) {
                        throw new RuntimeException();
                    }
                }
                if (gLUhalfEdge2 == gLUhalfEdge3 || gLUhalfEdge2 == gLUhalfEdge3.Sym) {
                    gLUhalfEdge3 = gLUhalfEdge3.next;
                }
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            gLUhalfEdge2 = gLUhalfEdge3;
        }
    }

    static boolean InitPriorityQ(GLUtessellatorImpl tess) {
        tess.pq = PriorityQ.pqNewPriorityQ((key1, key2) -> Geom.VertLeq((GLUvertex)key1, (GLUvertex)key2));
        PriorityQ priorityQ = tess.pq;
        if (priorityQ == null) {
            return false;
        }
        GLUvertex gLUvertex = tess.mesh.vHead;
        GLUvertex gLUvertex2 = gLUvertex.next;
        while (gLUvertex2 != gLUvertex) {
            gLUvertex2.pqHandle = priorityQ.pqInsert(gLUvertex2);
            if ((long)gLUvertex2.pqHandle == Long.MAX_VALUE) break;
            gLUvertex2 = gLUvertex2.next;
        }
        if (gLUvertex2 != gLUvertex || !priorityQ.pqInit()) {
            tess.pq.pqDeletePriorityQ();
            tess.pq = null;
            return false;
        }
        return true;
    }

    static void DonePriorityQ(GLUtessellatorImpl tess) {
        tess.pq.pqDeletePriorityQ();
    }

    static boolean RemoveDegenerateFaces(GLUmesh mesh) {
        GLUface gLUface = mesh.fHead.next;
        while (gLUface != mesh.fHead) {
            GLUface gLUface2 = gLUface.next;
            GLUhalfEdge gLUhalfEdge = gLUface.anEdge;
            assert (gLUhalfEdge.Lnext != gLUhalfEdge);
            if (gLUhalfEdge.Lnext.Lnext == gLUhalfEdge) {
                Sweep.AddWinding(gLUhalfEdge.Onext, gLUhalfEdge);
                if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                    return false;
                }
            }
            gLUface = gLUface2;
        }
        return true;
    }

    public static boolean __gl_computeInterior(GLUtessellatorImpl tess) {
        GLUvertex gLUvertex;
        tess.fatalError = false;
        Sweep.RemoveDegenerateEdges(tess);
        if (!Sweep.InitPriorityQ(tess)) {
            return false;
        }
        Sweep.InitEdgeDict(tess);
        while ((gLUvertex = (GLUvertex)tess.pq.pqExtractMin()) != null) {
            GLUvertex gLUvertex2;
            while ((gLUvertex2 = (GLUvertex)tess.pq.pqMinimum()) != null && Geom.VertEq(gLUvertex2, gLUvertex)) {
                gLUvertex2 = (GLUvertex)tess.pq.pqExtractMin();
                Sweep.SpliceMergeVertices(tess, gLUvertex.anEdge, gLUvertex2.anEdge);
            }
            Sweep.SweepEvent(tess, gLUvertex);
        }
        tess.event = ((ActiveRegion)Dict.dictKey((DictNode)Dict.dictMin((Dict)tess.dict))).eUp.Org;
        Sweep.DebugEvent(tess);
        Sweep.DoneEdgeDict(tess);
        Sweep.DonePriorityQ(tess);
        if (!Sweep.RemoveDegenerateFaces(tess.mesh)) {
            return false;
        }
        Mesh.__gl_meshCheckMesh(tess.mesh);
        return true;
    }
}

