/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.jinput;

import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Mouse;
import net.java.games.input.Rumbler;
import org.lwjglx.util.jinput.LWJGLMouse$Axis;
import org.lwjglx.util.jinput.LWJGLMouse$Button;

final class LWJGLMouse
extends Mouse {
    private static final int EVENT_X = 1;
    private static final int EVENT_Y = 2;
    private static final int EVENT_WHEEL = 3;
    private static final int EVENT_BUTTON = 4;
    private static final int EVENT_DONE = 5;
    private int event_state = 5;

    LWJGLMouse() {
        super("LWJGLMouse", LWJGLMouse.createComponents(), new Controller[0], new Rumbler[0]);
    }

    private static Component[] createComponents() {
        return new Component[]{new LWJGLMouse$Axis(Component.Identifier.Axis.X), new LWJGLMouse$Axis(Component.Identifier.Axis.Y), new LWJGLMouse$Axis(Component.Identifier.Axis.Z), new LWJGLMouse$Button(Component.Identifier.Button.LEFT), new LWJGLMouse$Button(Component.Identifier.Button.MIDDLE), new LWJGLMouse$Button(Component.Identifier.Button.RIGHT)};
    }

    public synchronized void pollDevice() {
        if (!org.lwjglx.input.Mouse.isCreated()) {
            return;
        }
        org.lwjglx.input.Mouse.poll();
        for (int i = 0; i < 3; ++i) {
            this.setButtonState(i);
        }
    }

    private LWJGLMouse$Button map(int lwjgl_button) {
        switch (lwjgl_button) {
            case 0: {
                return (LWJGLMouse$Button)this.getLeft();
            }
            case 1: {
                return (LWJGLMouse$Button)this.getRight();
            }
            case 2: {
                return (LWJGLMouse$Button)this.getMiddle();
            }
        }
        return null;
    }

    private void setButtonState(int lwjgl_button) {
        LWJGLMouse$Button lWJGLMouse$Button = this.map(lwjgl_button);
        if (lWJGLMouse$Button != null) {
            lWJGLMouse$Button.setValue(org.lwjglx.input.Mouse.isButtonDown(lwjgl_button) ? 1.0f : 0.0f);
        }
    }

    protected synchronized boolean getNextDeviceEvent(Event event) {
        if (!org.lwjglx.input.Mouse.isCreated()) {
            return false;
        }
        block7: while (true) {
            long l = org.lwjglx.input.Mouse.getEventNanoseconds();
            switch (this.event_state) {
                case 1: {
                    this.event_state = 2;
                    int n = org.lwjglx.input.Mouse.getEventDX();
                    if (n == 0) break;
                    event.set(this.getX(), (float)n, l);
                    return true;
                }
                case 2: {
                    this.event_state = 3;
                    int n = -org.lwjglx.input.Mouse.getEventDY();
                    if (n == 0) break;
                    event.set(this.getY(), (float)n, l);
                    return true;
                }
                case 3: {
                    this.event_state = 4;
                    int n = org.lwjglx.input.Mouse.getEventDWheel();
                    if (n == 0) break;
                    event.set(this.getWheel(), (float)n, l);
                    return true;
                }
                case 4: {
                    this.event_state = 5;
                    int n = org.lwjglx.input.Mouse.getEventButton();
                    if (n == -1) break;
                    LWJGLMouse$Button lWJGLMouse$Button = this.map(n);
                    if (lWJGLMouse$Button == null) continue block7;
                    event.set((Component)lWJGLMouse$Button, org.lwjglx.input.Mouse.getEventButtonState() ? 1.0f : 0.0f, l);
                    return true;
                }
                case 5: {
                    if (!org.lwjglx.input.Mouse.next()) {
                        return false;
                    }
                    this.event_state = 1;
                    break;
                }
            }
        }
    }
}

