/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.util.vector;

import java.nio.FloatBuffer;
import org.lwjglx.util.vector.Matrix3f;
import org.lwjglx.util.vector.Matrix4f;
import org.lwjglx.util.vector.ReadableVector4f;
import org.lwjglx.util.vector.Vector;
import org.lwjglx.util.vector.Vector4f;

public class Quaternion
extends Vector
implements ReadableVector4f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
        this.setIdentity();
    }

    public Quaternion(ReadableVector4f src) {
        this.set(src);
    }

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion set(ReadableVector4f src) {
        this.x = src.getX();
        this.y = src.getY();
        this.z = src.getZ();
        this.w = src.getW();
        return this;
    }

    public Quaternion setIdentity() {
        return Quaternion.setIdentity(this);
    }

    public static Quaternion setIdentity(Quaternion q) {
        q.x = 0.0f;
        q.y = 0.0f;
        q.z = 0.0f;
        q.w = 1.0f;
        return q;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public static Quaternion normalise(Quaternion src, Quaternion dest) {
        float f = 1.0f / src.length();
        if (dest == null) {
            dest = new Quaternion();
        }
        dest.set(src.x * f, src.y * f, src.z * f, src.w * f);
        return dest;
    }

    public Quaternion normalise(Quaternion dest) {
        return Quaternion.normalise(this, dest);
    }

    public static float dot(Quaternion left, Quaternion right) {
        return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
    }

    public Quaternion negate(Quaternion dest) {
        return Quaternion.negate(this, dest);
    }

    public static Quaternion negate(Quaternion src, Quaternion dest) {
        if (dest == null) {
            dest = new Quaternion();
        }
        dest.x = -src.x;
        dest.y = -src.y;
        dest.z = -src.z;
        dest.w = src.w;
        return dest;
    }

    @Override
    public Vector negate() {
        return Quaternion.negate(this, this);
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        this.z = buf.get();
        this.w = buf.get();
        return this;
    }

    @Override
    public Vector scale(float scale) {
        return Quaternion.scale(scale, this, this);
    }

    public static Quaternion scale(float scale, Quaternion src, Quaternion dest) {
        if (dest == null) {
            dest = new Quaternion();
        }
        dest.x = src.x * scale;
        dest.y = src.y * scale;
        dest.z = src.z * scale;
        dest.w = src.w * scale;
        return dest;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        buf.put(this.w);
        return this;
    }

    @Override
    public final float getX() {
        return this.x;
    }

    @Override
    public final float getY() {
        return this.y;
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public void setW(float w) {
        this.w = w;
    }

    @Override
    public float getW() {
        return this.w;
    }

    public String toString() {
        return "Quaternion: " + this.x + " " + this.y + " " + this.z + " " + this.w;
    }

    public static Quaternion mul(Quaternion left, Quaternion right, Quaternion dest) {
        if (dest == null) {
            dest = new Quaternion();
        }
        dest.set(left.x * right.w + left.w * right.x + left.y * right.z - left.z * right.y, left.y * right.w + left.w * right.y + left.z * right.x - left.x * right.z, left.z * right.w + left.w * right.z + left.x * right.y - left.y * right.x, left.w * right.w - left.x * right.x - left.y * right.y - left.z * right.z);
        return dest;
    }

    public static Quaternion mulInverse(Quaternion left, Quaternion right, Quaternion dest) {
        float f = right.lengthSquared();
        float f2 = f = (double)f == 0.0 ? f : 1.0f / f;
        if (dest == null) {
            dest = new Quaternion();
        }
        dest.set((left.x * right.w - left.w * right.x - left.y * right.z + left.z * right.y) * f, (left.y * right.w - left.w * right.y - left.z * right.x + left.x * right.z) * f, (left.z * right.w - left.w * right.z - left.x * right.y + left.y * right.x) * f, (left.w * right.w + left.x * right.x + left.y * right.y + left.z * right.z) * f);
        return dest;
    }

    public final void setFromAxisAngle(Vector4f a1) {
        this.x = a1.x;
        this.y = a1.y;
        this.z = a1.z;
        float f = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float f2 = (float)(Math.sin(0.5 * (double)a1.w) / (double)f);
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w = (float)Math.cos(0.5 * (double)a1.w);
    }

    public final Quaternion setFromMatrix(Matrix4f m) {
        return Quaternion.setFromMatrix(m, this);
    }

    public static Quaternion setFromMatrix(Matrix4f m, Quaternion q) {
        return q.setFromMat(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    public final Quaternion setFromMatrix(Matrix3f m) {
        return Quaternion.setFromMatrix(m, this);
    }

    public static Quaternion setFromMatrix(Matrix3f m, Quaternion q) {
        return q.setFromMat(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
    }

    private Quaternion setFromMat(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float f = m00 + m11 + m22;
        if ((double)f >= 0.0) {
            float f2 = (float)Math.sqrt((double)f + 1.0);
            this.w = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.x = (m21 - m12) * f2;
            this.y = (m02 - m20) * f2;
            this.z = (m10 - m01) * f2;
        } else {
            float f3 = Math.max(Math.max(m00, m11), m22);
            if (f3 == m00) {
                float f4 = (float)Math.sqrt((double)(m00 - (m11 + m22)) + 1.0);
                this.x = f4 * 0.5f;
                f4 = 0.5f / f4;
                this.y = (m01 + m10) * f4;
                this.z = (m20 + m02) * f4;
                this.w = (m21 - m12) * f4;
            } else if (f3 == m11) {
                float f5 = (float)Math.sqrt((double)(m11 - (m22 + m00)) + 1.0);
                this.y = f5 * 0.5f;
                f5 = 0.5f / f5;
                this.z = (m12 + m21) * f5;
                this.x = (m01 + m10) * f5;
                this.w = (m02 - m20) * f5;
            } else {
                float f6 = (float)Math.sqrt((double)(m22 - (m00 + m11)) + 1.0);
                this.z = f6 * 0.5f;
                f6 = 0.5f / f6;
                this.x = (m20 + m02) * f6;
                this.y = (m12 + m21) * f6;
                this.w = (m10 - m01) * f6;
            }
        }
        return this;
    }
}

