/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.InstanceCreator;
import com.google.gson.internal.ConstructorConstructor$1;
import com.google.gson.internal.ConstructorConstructor$10;
import com.google.gson.internal.ConstructorConstructor$11;
import com.google.gson.internal.ConstructorConstructor$12;
import com.google.gson.internal.ConstructorConstructor$13;
import com.google.gson.internal.ConstructorConstructor$14;
import com.google.gson.internal.ConstructorConstructor$15;
import com.google.gson.internal.ConstructorConstructor$16;
import com.google.gson.internal.ConstructorConstructor$17;
import com.google.gson.internal.ConstructorConstructor$2;
import com.google.gson.internal.ConstructorConstructor$3;
import com.google.gson.internal.ConstructorConstructor$4;
import com.google.gson.internal.ConstructorConstructor$5;
import com.google.gson.internal.ConstructorConstructor$6;
import com.google.gson.internal.ConstructorConstructor$7;
import com.google.gson.internal.ConstructorConstructor$8;
import com.google.gson.internal.ConstructorConstructor$9;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;
    private final boolean useJdkUnsafe;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map, boolean bl) {
        this.instanceCreators = map;
        this.useJdkUnsafe = bl;
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> clazz = typeToken.getRawType();
        InstanceCreator<?> instanceCreator = this.instanceCreators.get(type);
        if (instanceCreator != null) {
            return new ConstructorConstructor$1(this, instanceCreator, type);
        }
        InstanceCreator<?> instanceCreator2 = this.instanceCreators.get(clazz);
        if (instanceCreator2 != null) {
            return new ConstructorConstructor$2(this, instanceCreator2, type);
        }
        ObjectConstructor<T> objectConstructor = this.newDefaultConstructor(clazz);
        if (objectConstructor != null) {
            return objectConstructor;
        }
        ObjectConstructor<T> objectConstructor2 = this.newDefaultImplementationConstructor(type, clazz);
        if (objectConstructor2 != null) {
            return objectConstructor2;
        }
        return this.newUnsafeAllocator(clazz);
    }

    private <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> clazz) {
        Constructor<? super T> constructor;
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        String string = ReflectionHelper.tryMakeAccessible(constructor);
        if (string != null) {
            return new ConstructorConstructor$3(this, string);
        }
        return new ConstructorConstructor$4(this, constructor);
    }

    private <T> ObjectConstructor<T> newDefaultImplementationConstructor(Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$5(this);
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$6(this, type);
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$7(this);
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$8(this);
            }
            return new ConstructorConstructor$9(this);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (clazz == EnumMap.class) {
                return new ConstructorConstructor$10(this, type);
            }
            if (ConcurrentNavigableMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$11(this);
            }
            if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$12(this);
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new ConstructorConstructor$13(this);
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return new ConstructorConstructor$14(this);
            }
            return new ConstructorConstructor$15(this);
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(Class<? super T> clazz) {
        if (this.useJdkUnsafe) {
            return new ConstructorConstructor$16(this, clazz);
        }
        String string = "Unable to create instance of " + clazz + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        return new ConstructorConstructor$17(this, string);
    }

    public String toString() {
        return this.instanceCreators.toString();
    }
}

