/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u00020\u0015*\u00020\u0017J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d*\u00020\u0011H\u0002J\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/Cache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_METADATA", "VERSION", "key", "", "url", "Lokhttp3/HttpUrl;", "readInt", "source", "Lokio/BufferedSource;", "readInt$okhttp", "varyHeaders", "Lokhttp3/Headers;", "requestHeaders", "responseHeaders", "varyMatches", "", "cachedResponse", "Lokhttp3/Response;", "cachedRequest", "newRequest", "Lokhttp3/Request;", "hasVaryAll", "varyFields", "", "okhttp"})
@SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n2624#2,3:789\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n729#1:789,3\n*E\n"})
public final class Cache$Companion {
    private Cache$Companion() {
    }

    @JvmStatic
    @NotNull
    public final String key(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        return ByteString.Companion.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    public final int readInt$okhttp(@NotNull BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        try {
            long l = bufferedSource.readDecimalLong();
            String string = bufferedSource.readUtf8LineStrict();
            if (l < 0L || l > Integer.MAX_VALUE || ((CharSequence)string).length() > 0) {
                throw new IOException("expected an int but was \"" + l + string + '\"');
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    public final boolean varyMatches(@NotNull Response response, @NotNull Headers headers, @NotNull Request request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(response, "cachedResponse");
            Intrinsics.checkNotNullParameter(headers, "cachedRequest");
            Intrinsics.checkNotNullParameter(request, "newRequest");
            Iterable iterable = this.varyFields(response.headers());
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(headers.values(string), request.headers(string)))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean hasVaryAll(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "<this>");
        return this.varyFields(response.headers()).contains("*");
    }

    private final Set<String> varyFields(Headers headers) {
        Set set = null;
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals("Vary", headers.name(i), true)) continue;
            String string = headers.value(i);
            if (set == null) {
                set = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            }
            Object object = new char[]{','};
            Iterator iterator2 = StringsKt.split$default((CharSequence)string, object, false, 0, 6, null).iterator();
            while (iterator2.hasNext()) {
                object = (String)iterator2.next();
                set.add(((Object)StringsKt.trim((CharSequence)object)).toString());
            }
        }
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    @NotNull
    public final Headers varyHeaders(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, "<this>");
        Response response2 = response.networkResponse();
        Intrinsics.checkNotNull(response2);
        Headers headers = response2.request().headers();
        Headers headers2 = response.headers();
        return this.varyHeaders(headers, headers2);
    }

    private final Headers varyHeaders(Headers headers, Headers headers2) {
        Set<String> set = this.varyFields(headers2);
        if (set.isEmpty()) {
            return Util.EMPTY_HEADERS;
        }
        Headers$Builder headers$Builder = new Headers$Builder();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            String string = headers.name(i);
            if (!set.contains(string)) continue;
            headers$Builder.add(string, headers.value(i));
        }
        return headers$Builder.build();
    }

    public /* synthetic */ Cache$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

