/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import okio.ByteString$Companion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\n*\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "()V", "DEFAULT", "Lokhttp3/CertificatePinner;", "pin", "", "certificate", "Ljava/security/cert/Certificate;", "sha1Hash", "Lokio/ByteString;", "Ljava/security/cert/X509Certificate;", "sha256Hash", "okhttp"})
@SourceDebugExtension(value={"SMAP\nCertificatePinner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class CertificatePinner$Companion {
    private CertificatePinner$Companion() {
    }

    @JvmStatic
    @NotNull
    public final ByteString sha1Hash(@NotNull X509Certificate x509Certificate) {
        Intrinsics.checkNotNullParameter(x509Certificate, "<this>");
        byte[] byArray = x509Certificate.getPublicKey().getEncoded();
        Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
        return ByteString$Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha1();
    }

    @JvmStatic
    @NotNull
    public final ByteString sha256Hash(@NotNull X509Certificate x509Certificate) {
        Intrinsics.checkNotNullParameter(x509Certificate, "<this>");
        byte[] byArray = x509Certificate.getPublicKey().getEncoded();
        Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
        return ByteString$Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha256();
    }

    @JvmStatic
    @NotNull
    public final String pin(@NotNull Certificate certificate) {
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        if (!(certificate instanceof X509Certificate)) {
            boolean bl = false;
            String string = "Certificate pinning requires X509 certificates";
            throw new IllegalArgumentException(string.toString());
        }
        return "sha256/" + this.sha256Hash((X509Certificate)certificate).base64();
    }

    public /* synthetic */ CertificatePinner$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

