/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartReader$Companion;
import okhttp3.MultipartReader$Part;
import okhttp3.MultipartReader$PartSource;
import okhttp3.ResponseBody;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokhttp3/MultipartReader;", "Ljava/io/Closeable;", "response", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;)V", "source", "Lokio/BufferedSource;", "boundary", "", "(Lokio/BufferedSource;Ljava/lang/String;)V", "()Ljava/lang/String;", "closed", "", "crlfDashDashBoundary", "Lokio/ByteString;", "currentPart", "Lokhttp3/MultipartReader$PartSource;", "dashDashBoundary", "noMoreParts", "partCount", "", "close", "", "currentPartBytesRemaining", "", "maxResult", "nextPart", "Lokhttp3/MultipartReader$Part;", "Companion", "Part", "PartSource", "okhttp"})
@SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\nokhttp3/MultipartReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class MultipartReader
implements Closeable {
    @NotNull
    public static final MultipartReader$Companion Companion = new MultipartReader$Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final String boundary;
    @NotNull
    private final ByteString dashDashBoundary;
    @NotNull
    private final ByteString crlfDashDashBoundary;
    private int partCount;
    private boolean closed;
    private boolean noMoreParts;
    @Nullable
    private MultipartReader$PartSource currentPart;
    @NotNull
    private static final Options afterBoundaryOptions;

    public MultipartReader(@NotNull BufferedSource bufferedSource, @NotNull String string) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(string, "boundary");
        this.source = bufferedSource;
        this.boundary = string;
        this.dashDashBoundary = new Buffer().writeUtf8("--").writeUtf8(this.boundary).readByteString();
        this.crlfDashDashBoundary = new Buffer().writeUtf8("\r\n--").writeUtf8(this.boundary).readByteString();
    }

    @JvmName(name="boundary")
    @NotNull
    public final String boundary() {
        return this.boundary;
    }

    public MultipartReader(@NotNull ResponseBody responseBody) {
        Intrinsics.checkNotNullParameter(responseBody, "response");
        Object object = responseBody.contentType();
        if (object == null || (object = ((MediaType)object).parameter("boundary")) == null) {
            throw new ProtocolException("expected the Content-Type to have a boundary parameter");
        }
        this(responseBody.source(), (String)object);
    }

    @Nullable
    public final MultipartReader$Part nextPart() {
        MultipartReader$PartSource multipartReader$PartSource;
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (this.noMoreParts) {
            return null;
        }
        if (this.partCount == 0 && this.source.rangeEquals(0L, this.dashDashBoundary)) {
            this.source.skip(this.dashDashBoundary.size());
        } else {
            long l;
            while ((l = this.currentPartBytesRemaining(8192L)) != 0L) {
                this.source.skip(l);
            }
            this.source.skip(this.crlfDashDashBoundary.size());
        }
        boolean bl = false;
        block7: while (true) {
            switch (this.source.select(afterBoundaryOptions)) {
                case 0: {
                    int n = this.partCount;
                    this.partCount = n + 1;
                    break block7;
                }
                case 1: {
                    if (bl) {
                        throw new ProtocolException("unexpected characters after boundary");
                    }
                    if (this.partCount == 0) {
                        throw new ProtocolException("expected at least 1 part");
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 2: 
                case 3: {
                    bl = true;
                    continue block7;
                }
                case -1: {
                    throw new ProtocolException("unexpected characters after boundary");
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        Headers headers = new HeadersReader(this.source).readHeaders();
        this.currentPart = multipartReader$PartSource = new MultipartReader$PartSource(this);
        return new MultipartReader$Part(headers, Okio.buffer(multipartReader$PartSource));
    }

    private final long currentPartBytesRemaining(long l) {
        this.source.require(this.crlfDashDashBoundary.size());
        long l2 = this.source.getBuffer().indexOf(this.crlfDashDashBoundary);
        return l2 == -1L ? Math.min(l, this.source.getBuffer().size() - (long)this.crlfDashDashBoundary.size() + 1L) : Math.min(l, l2);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentPart = null;
        this.source.close();
    }

    public static final /* synthetic */ MultipartReader$PartSource access$getCurrentPart$p(MultipartReader multipartReader) {
        return multipartReader.currentPart;
    }

    public static final /* synthetic */ void access$setCurrentPart$p(MultipartReader multipartReader, MultipartReader$PartSource multipartReader$PartSource) {
        multipartReader.currentPart = multipartReader$PartSource;
    }

    public static final /* synthetic */ BufferedSource access$getSource$p(MultipartReader multipartReader) {
        return multipartReader.source;
    }

    public static final /* synthetic */ long access$currentPartBytesRemaining(MultipartReader multipartReader, long l) {
        return multipartReader.currentPartBytesRemaining(l);
    }

    public static final /* synthetic */ Options access$getAfterBoundaryOptions$cp() {
        return afterBoundaryOptions;
    }

    static {
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.encodeUtf8("\r\n"), ByteString.Companion.encodeUtf8("--"), ByteString.Companion.encodeUtf8(" "), ByteString.Companion.encodeUtf8("\t")};
        afterBoundaryOptions = Options.Companion.of(byteStringArray);
    }
}

