/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.connection.RouteSelector$Selection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J8\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0002J\u0006\u0010'\u001a\u00020$J\n\u0010(\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;)V", "getAddress$okhttp", "()Lokhttp3/Address;", "connectionShutdownCount", "", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "find", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "findConnection", "Lokhttp3/internal/connection/RealConnection;", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "", "findHealthyConnection", "doExtensiveHealthChecks", "retryAfterFailure", "retryRoute", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "trackFailure", "", "e", "Ljava/io/IOException;", "okhttp"})
public final class ExchangeFinder {
    @NotNull
    private final RealConnectionPool connectionPool;
    @NotNull
    private final Address address;
    @NotNull
    private final RealCall call;
    @NotNull
    private final EventListener eventListener;
    @Nullable
    private RouteSelector$Selection routeSelection;
    @Nullable
    private RouteSelector routeSelector;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    @Nullable
    private Route nextRouteToTry;

    public ExchangeFinder(@NotNull RealConnectionPool realConnectionPool, @NotNull Address address, @NotNull RealCall realCall, @NotNull EventListener eventListener) {
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = realCall;
        this.eventListener = eventListener;
    }

    @NotNull
    public final Address getAddress$okhttp() {
        return this.address;
    }

    @NotNull
    public final ExchangeCodec find(@NotNull OkHttpClient okHttpClient, @NotNull RealInterceptorChain realInterceptorChain) {
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        try {
            RealConnection realConnection = this.findHealthyConnection(realInterceptorChain.getConnectTimeoutMillis$okhttp(), realInterceptorChain.getReadTimeoutMillis$okhttp(), realInterceptorChain.getWriteTimeoutMillis$okhttp(), okHttpClient.pingIntervalMillis(), okHttpClient.retryOnConnectionFailure(), !Intrinsics.areEqual(realInterceptorChain.getRequest$okhttp().method(), "GET"));
            return realConnection.newCodec$okhttp(okHttpClient, realInterceptorChain);
        }
        catch (RouteException routeException) {
            this.trackFailure(routeException.getLastConnectException());
            throw routeException;
        }
        catch (IOException iOException) {
            this.trackFailure(iOException);
            throw new RouteException(iOException);
        }
    }

    private final RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        while (true) {
            RealConnection realConnection;
            if ((realConnection = this.findConnection(n, n2, n3, n4, bl)).isHealthy(bl2)) {
                return realConnection;
            }
            realConnection.noNewExchanges$okhttp();
            if (this.nextRouteToTry != null) continue;
            RouteSelector$Selection routeSelector$Selection = this.routeSelection;
            boolean bl3 = routeSelector$Selection != null ? routeSelector$Selection.hasNext() : true;
            if (bl3) continue;
            RouteSelector routeSelector = this.routeSelector;
            boolean bl4 = routeSelector != null ? routeSelector.hasNext() : true;
            if (!bl4) break;
        }
        throw new IOException("exhausted all routes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final RealConnection findConnection(int var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block24: {
            block23: {
                if (this.call.isCanceled()) {
                    throw new IOException("Canceled");
                }
                var6_6 = this.call.getConnection();
                if (var6_6 != null) {
                    var7_7 = null;
                    var8_8 = var6_6;
                    synchronized (var8_8) {
                        var9_9 = false;
                        if (var6_6.getNoNewExchanges() || !this.sameHostAndPort(var6_6.route().address().url())) {
                            var7_7 = this.call.releaseConnectionNoEvents$okhttp();
                        }
                        var9_10 = Unit.INSTANCE;
                    }
                    if (this.call.getConnection() != null) {
                        if (!(var7_7 == null)) {
                            var9_10 = "Check failed.";
                            throw new IllegalStateException(var9_10.toString());
                        }
                        return var6_6;
                    }
                    v0 = var7_7;
                    if (v0 != null) {
                        Util.closeQuietly((Socket)v0);
                    }
                    this.eventListener.connectionReleased(this.call, var6_6);
                }
                this.refusedStreamCount = 0;
                this.connectionShutdownCount = 0;
                this.otherFailureCount = 0;
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                    v1 = this.call.getConnection();
                    Intrinsics.checkNotNull(v1);
                    var7_7 = v1;
                    this.eventListener.connectionAcquired(this.call, (Connection)var7_7);
                    return var7_7;
                }
                var7_7 = null;
                var8_8 = null;
                if (this.nextRouteToTry == null) break block23;
                var7_7 = null;
                v2 = this.nextRouteToTry;
                Intrinsics.checkNotNull(v2);
                var8_8 = v2;
                this.nextRouteToTry = null;
                break block24;
            }
            if (this.routeSelection == null) ** GOTO lbl-1000
            v3 = this.routeSelection;
            Intrinsics.checkNotNull(v3);
            if (v3.hasNext()) {
                var7_7 = null;
                v4 = this.routeSelection;
                Intrinsics.checkNotNull(v4);
                var8_8 = v4.next();
            } else lbl-1000:
            // 2 sources

            {
                if ((var9_10 = this.routeSelector) == null) {
                    this.routeSelector = var9_10 = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
                }
                var10_12 = var9_10.next();
                this.routeSelection = var10_12;
                var7_7 = var10_12.getRoutes();
                if (this.call.isCanceled()) {
                    throw new IOException("Canceled");
                }
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, var7_7, false)) {
                    v5 = this.call.getConnection();
                    Intrinsics.checkNotNull(v5);
                    var11_14 = v5;
                    this.eventListener.connectionAcquired(this.call, var11_14);
                    return var11_14;
                }
                var8_8 = var10_12.next();
            }
        }
        var9_10 = new RealConnection(this.connectionPool, (Route)var8_8);
        this.call.setConnectionToCancel((RealConnection)var9_10);
        try {
            var9_10.connect(var1_1, var2_2, var3_3, var4_4, var5_5, this.call, this.eventListener);
        }
        finally {
            this.call.setConnectionToCancel(null);
        }
        this.call.getClient().getRouteDatabase().connected(var9_10.route());
        if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, var7_7, true)) {
            v6 = this.call.getConnection();
            Intrinsics.checkNotNull(v6);
            var10_12 = v6;
            this.nextRouteToTry = var8_8;
            Util.closeQuietly(var9_10.socket());
            this.eventListener.connectionAcquired(this.call, (Connection)var10_12);
            return var10_12;
        }
        var10_12 = var9_10;
        synchronized (var10_12) {
            var11_15 = false;
            this.connectionPool.put((RealConnection)var9_10);
            this.call.acquireConnectionNoEvents((RealConnection)var9_10);
            var11_16 = Unit.INSTANCE;
        }
        this.eventListener.connectionAcquired(this.call, (Connection)var9_10);
        return var9_10;
    }

    public final void trackFailure(@NotNull IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.nextRouteToTry = null;
        if (iOException instanceof StreamResetException && ((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
            int n = this.refusedStreamCount;
            this.refusedStreamCount = n + 1;
        } else if (iOException instanceof ConnectionShutdownException) {
            int n = this.connectionShutdownCount;
            this.connectionShutdownCount = n + 1;
        } else {
            int n = this.otherFailureCount;
            this.otherFailureCount = n + 1;
        }
    }

    public final boolean retryAfterFailure() {
        if (this.refusedStreamCount == 0 && this.connectionShutdownCount == 0 && this.otherFailureCount == 0) {
            return false;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        Route route = this.retryRoute();
        if (route != null) {
            this.nextRouteToTry = route;
            return true;
        }
        RouteSelector$Selection routeSelector$Selection = this.routeSelection;
        boolean bl = routeSelector$Selection != null ? routeSelector$Selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector routeSelector2 = routeSelector;
        return routeSelector2.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute() {
        RealConnection realConnection;
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return null;
        }
        RealConnection realConnection2 = this.call.getConnection();
        if (realConnection2 == null) {
            return null;
        }
        RealConnection realConnection3 = realConnection = realConnection2;
        synchronized (realConnection3) {
            block8: {
                block7: {
                    boolean bl = false;
                    if (realConnection.getRouteFailureCount$okhttp() == 0) break block7;
                    Route route = null;
                    return route;
                }
                if (Util.canReuseConnectionFor(realConnection.route().address().url(), this.address.url())) break block8;
                Route route = null;
                return route;
            }
            Route route = realConnection.route();
            return route;
        }
    }

    public final boolean sameHostAndPort(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        HttpUrl httpUrl2 = this.address.url();
        return httpUrl.port() == httpUrl2.port() && Intrinsics.areEqual(httpUrl.host(), httpUrl2.host());
    }
}

