/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealCall$CallReference;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool$Companion;
import okhttp3.internal.connection.RealConnectionPool$cleanupTask$1;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;)V", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "callAcquirePooledConnection", "", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "routes", "", "Lokhttp3/Route;", "requireMultiplexed", "cleanup", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "pruneAndGetAllocationCount", "put", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,250:1\n1#2:251\n1774#3,4:252\n608#4,4:256\n608#4,4:260\n608#4,4:264\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n60#1:252,4\n95#1:256,4\n106#1:260,4\n215#1:264,4\n*E\n"})
public final class RealConnectionPool {
    @NotNull
    public static final RealConnectionPool$Companion Companion = new RealConnectionPool$Companion(null);
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    @NotNull
    private final TaskQueue cleanupQueue;
    @NotNull
    private final RealConnectionPool$cleanupTask$1 cleanupTask;
    @NotNull
    private final ConcurrentLinkedQueue<RealConnection> connections;

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int n, long l, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = n;
        this.keepAliveDurationNs = timeUnit.toNanos(l);
        this.cleanupQueue = taskRunner.newQueue();
        String string = Util.okHttpName + " ConnectionPool";
        this.cleanupTask = new RealConnectionPool$cleanupTask$1(this, string);
        this.connections = new ConcurrentLinkedQueue();
        if (!(l > 0L)) {
            boolean bl = false;
            String string2 = "keepAliveDuration <= 0: " + l;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int idleConnectionCount() {
        int n;
        Iterable iterable = this.connections;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            n = 0;
        } else {
            int n2 = 0;
            for (Object t : iterable) {
                boolean bl2;
                RealConnection realConnection = (RealConnection)t;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(realConnection, "it");
                RealConnection realConnection2 = realConnection;
                synchronized (realConnection2) {
                    bl2 = false;
                    bl2 = realConnection.getCalls().isEmpty();
                }
                if (!bl2 || ++n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = n2;
        }
        return n;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean callAcquirePooledConnection(@NotNull Address address, @NotNull RealCall realCall, @Nullable List<Route> list, boolean bl) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(realCall, "call");
        for (RealConnection realConnection : this.connections) {
            Intrinsics.checkNotNullExpressionValue(realConnection, "connection");
            RealConnection realConnection2 = realConnection;
            synchronized (realConnection2) {
                block5: {
                    boolean bl2 = false;
                    if (bl && !realConnection.isMultiplexed$okhttp() || !realConnection.isEligible$okhttp(address, list)) break block5;
                    realCall.acquireConnectionNoEvents(realConnection);
                    boolean bl3 = true;
                    return bl3;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return false;
    }

    public final void put(@NotNull RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection2));
        }
        this.connections.add(realConnection);
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection realConnection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl2 = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection2));
        }
        if (realConnection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            realConnection.setNoNewExchanges(true);
            this.connections.remove(realConnection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        } else {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "connections.iterator()");
        Iterator<RealConnection> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Socket socket;
            Socket socket2;
            RealConnection realConnection = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(realConnection, "connection");
            RealConnection realConnection2 = realConnection;
            synchronized (realConnection2) {
                Socket socket3;
                boolean bl = false;
                if (realConnection.getCalls().isEmpty()) {
                    iterator3.remove();
                    realConnection.setNoNewExchanges(true);
                    socket3 = realConnection.socket();
                } else {
                    socket3 = null;
                }
                socket2 = socket3;
            }
            Socket socket4 = socket = socket2;
            if (socket4 == null) continue;
            Util.closeQuietly(socket4);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long cleanup(long l) {
        int n = 0;
        int n2 = 0;
        RealConnection object = null;
        long l2 = 0L;
        l2 = Long.MIN_VALUE;
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        while (iterator2.hasNext()) {
            RealConnection object2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(object2, "connection");
            RealConnection l5 = object2;
            synchronized (l5) {
                Object object3;
                boolean bl = false;
                if (this.pruneAndGetAllocationCount(object2, l) > 0) {
                    int l4 = n;
                    n = l4 + 1;
                    object3 = l4;
                } else {
                    ++n2;
                    long l3 = l - object2.getIdleAtNs$okhttp();
                    if (l3 > l2) {
                        l2 = l3;
                        object = object2;
                    }
                    object3 = Unit.INSTANCE;
                }
                Integer bl2 = object3;
            }
        }
        if (l2 >= this.keepAliveDurationNs || n2 > this.maxIdleConnections) {
            RealConnection realConnection = object;
            Intrinsics.checkNotNull(realConnection);
            Iterator<RealConnection> iterator3 = iterator2 = realConnection;
            synchronized (iterator3) {
                boolean bl;
                block17: {
                    block16: {
                        bl = false;
                        if (!(!((Collection)((RealConnection)((Object)iterator2)).getCalls()).isEmpty())) break block16;
                        long l4 = 0L;
                        return l4;
                    }
                    if (((RealConnection)((Object)iterator2)).getIdleAtNs$okhttp() + l2 == l) break block17;
                    long l5 = 0L;
                    return l5;
                }
                ((RealConnection)((Object)iterator2)).setNoNewExchanges(true);
                bl = this.connections.remove(object);
            }
            Util.closeQuietly(((RealConnection)((Object)iterator2)).socket());
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (n2 > 0) {
            return this.keepAliveDurationNs - l2;
        }
        if (n > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        Object object = realConnection;
        int n = 0;
        if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
        }
        object = realConnection.getCalls();
        n = 0;
        while (n < object.size()) {
            Reference reference = (Reference)object.get(n);
            if (reference.get() != null) {
                ++n;
                continue;
            }
            Intrinsics.checkNotNull(reference, "null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall$CallReference realCall$CallReference = (RealCall$CallReference)reference;
            String string = "A connection to " + realConnection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(string, realCall$CallReference.getCallStackTrace());
            object.remove(n);
            realConnection.setNoNewExchanges(true);
            if (!object.isEmpty()) continue;
            realConnection.setIdleAtNs$okhttp(l - this.keepAliveDurationNs);
            return 0;
        }
        return object.size();
    }
}

