/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec$AbstractSource;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "bytesRemaining", "", "(Lokhttp3/internal/http1/Http1ExchangeCodec;J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1#2:506\n*E\n"})
final class Http1ExchangeCodec$FixedLengthSource
extends Http1ExchangeCodec$AbstractSource {
    private long bytesRemaining;
    final /* synthetic */ Http1ExchangeCodec this$0;

    public Http1ExchangeCodec$FixedLengthSource(Http1ExchangeCodec http1ExchangeCodec, long l) {
        this.this$0 = http1ExchangeCodec;
        super(http1ExchangeCodec);
        this.bytesRemaining = l;
        if (this.bytesRemaining == 0L) {
            this.responseBodyComplete();
        }
    }

    @Override
    public long read(@NotNull Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (!(l >= 0L)) {
            boolean bl = false;
            String string = "byteCount < 0: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.getClosed())) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (this.bytesRemaining == 0L) {
            return -1L;
        }
        long l2 = super.read(buffer, Math.min(this.bytesRemaining, l));
        if (l2 == -1L) {
            this.this$0.getConnection().noNewExchanges$okhttp();
            ProtocolException protocolException = new ProtocolException("unexpected end of stream");
            this.responseBodyComplete();
            throw protocolException;
        }
        this.bytesRemaining -= l2;
        if (this.bytesRemaining == 0L) {
            this.responseBodyComplete();
        }
        return l2;
    }

    @Override
    public void close() {
        if (this.getClosed()) {
            return;
        }
        if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
            this.this$0.getConnection().noNewExchanges$okhttp();
            this.responseBodyComplete();
        }
        this.setClosed(true);
    }
}

