/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010!\u001a\u00020\u0005H\u0002J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002R\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lokhttp3/internal/http2/Hpack$Reader;", "", "source", "Lokio/Source;", "headerTableSizeSetting", "", "maxDynamicTableByteCount", "(Lokio/Source;II)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "headerCount", "headerList", "", "nextHeaderIndex", "Lokio/BufferedSource;", "adjustDynamicTableByteCount", "", "clearDynamicTable", "dynamicTableIndex", "index", "evictToRecoverBytes", "bytesToRecover", "getAndResetHeaderList", "", "getName", "Lokio/ByteString;", "insertIntoDynamicTable", "entry", "isStaticHeader", "", "readByte", "readByteString", "readHeaders", "readIndexedHeader", "readInt", "firstByte", "prefixMask", "readLiteralHeaderWithIncrementalIndexingIndexedName", "nameIndex", "readLiteralHeaderWithIncrementalIndexingNewName", "readLiteralHeaderWithoutIndexingIndexedName", "readLiteralHeaderWithoutIndexingNewName", "okhttp"})
public final class Hpack$Reader {
    private final int headerTableSizeSetting;
    private int maxDynamicTableByteCount;
    @NotNull
    private final List<Header> headerList;
    @NotNull
    private final BufferedSource source;
    @JvmField
    @NotNull
    public Header[] dynamicTable;
    private int nextHeaderIndex;
    @JvmField
    public int headerCount;
    @JvmField
    public int dynamicTableByteCount;

    @JvmOverloads
    public Hpack$Reader(@NotNull Source source2, int n, int n2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this.headerTableSizeSetting = n;
        this.maxDynamicTableByteCount = n2;
        this.headerList = new ArrayList();
        this.source = Okio.buffer(source2);
        this.dynamicTable = new Header[8];
        this.nextHeaderIndex = this.dynamicTable.length - 1;
    }

    public /* synthetic */ Hpack$Reader(Source source2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        this(source2, n, n2);
    }

    @NotNull
    public final List<Header> getAndResetHeaderList() {
        List<Header> list = CollectionsKt.toList((Iterable)this.headerList);
        this.headerList.clear();
        return list;
    }

    public final int maxDynamicTableByteCount() {
        return this.maxDynamicTableByteCount;
    }

    private final void adjustDynamicTableByteCount() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.clearDynamicTable();
            } else {
                this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }
    }

    private final void clearDynamicTable() {
        ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
        this.nextHeaderIndex = this.dynamicTable.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private final int evictToRecoverBytes(int n) {
        int n2 = n;
        int n3 = 0;
        if (n2 > 0) {
            for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n2 > 0; --i) {
                Header header;
                Intrinsics.checkNotNull(this.dynamicTable[i]);
                n2 -= header.hpackSize;
                this.dynamicTableByteCount -= header.hpackSize;
                int n4 = this.headerCount;
                this.headerCount = n4 + -1;
                ++n3;
            }
            System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
            this.nextHeaderIndex += n3;
        }
        return n3;
    }

    public final void readHeaders() {
        while (!this.source.exhausted()) {
            int n;
            int n2 = Util.and(this.source.readByte(), 255);
            if (n2 == 128) {
                throw new IOException("index == 0");
            }
            if ((n2 & 0x80) == 128) {
                n = this.readInt(n2, 127);
                this.readIndexedHeader(n - 1);
                continue;
            }
            if (n2 == 64) {
                this.readLiteralHeaderWithIncrementalIndexingNewName();
                continue;
            }
            if ((n2 & 0x40) == 64) {
                n = this.readInt(n2, 63);
                this.readLiteralHeaderWithIncrementalIndexingIndexedName(n - 1);
                continue;
            }
            if ((n2 & 0x20) == 32) {
                this.maxDynamicTableByteCount = this.readInt(n2, 31);
                if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                    throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                }
                this.adjustDynamicTableByteCount();
                continue;
            }
            if (n2 == 16 || n2 == 0) {
                this.readLiteralHeaderWithoutIndexingNewName();
                continue;
            }
            n = this.readInt(n2, 15);
            this.readLiteralHeaderWithoutIndexingIndexedName(n - 1);
        }
    }

    private final void readIndexedHeader(int n) {
        if (this.isStaticHeader(n)) {
            Header header = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n];
            this.headerList.add(header);
        } else {
            int n2 = this.dynamicTableIndex(n - Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length);
            if (n2 < 0 || n2 >= this.dynamicTable.length) {
                throw new IOException("Header index too large " + (n + 1));
            }
            Collection collection = this.headerList;
            Header header = this.dynamicTable[n2];
            Intrinsics.checkNotNull(header);
            collection.add(header);
        }
    }

    private final int dynamicTableIndex(int n) {
        return this.nextHeaderIndex + 1 + n;
    }

    private final void readLiteralHeaderWithoutIndexingIndexedName(int n) {
        ByteString byteString = this.getName(n);
        ByteString byteString2 = this.readByteString();
        this.headerList.add(new Header(byteString, byteString2));
    }

    private final void readLiteralHeaderWithoutIndexingNewName() {
        ByteString byteString = Hpack.INSTANCE.checkLowercase(this.readByteString());
        ByteString byteString2 = this.readByteString();
        this.headerList.add(new Header(byteString, byteString2));
    }

    private final void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) {
        ByteString byteString = this.getName(n);
        ByteString byteString2 = this.readByteString();
        this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
    }

    private final void readLiteralHeaderWithIncrementalIndexingNewName() {
        ByteString byteString = Hpack.INSTANCE.checkLowercase(this.readByteString());
        ByteString byteString2 = this.readByteString();
        this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
    }

    private final ByteString getName(int n) {
        ByteString byteString;
        if (this.isStaticHeader(n)) {
            byteString = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n].name;
        } else {
            int n2 = this.dynamicTableIndex(n - Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length);
            if (n2 < 0 || n2 >= this.dynamicTable.length) {
                throw new IOException("Header index too large " + (n + 1));
            }
            Header header = this.dynamicTable[n2];
            Intrinsics.checkNotNull(header);
            byteString = header.name;
        }
        return byteString;
    }

    private final boolean isStaticHeader(int n) {
        return n >= 0 && n <= Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length - 1;
    }

    private final void insertIntoDynamicTable(int n, Header header) {
        int n2 = n;
        this.headerList.add(header);
        int n3 = header.hpackSize;
        if (n2 != -1) {
            Header header2 = this.dynamicTable[this.dynamicTableIndex(n2)];
            Intrinsics.checkNotNull(header2);
            n3 -= header2.hpackSize;
        }
        if (n3 > this.maxDynamicTableByteCount) {
            this.clearDynamicTable();
            return;
        }
        int n4 = this.dynamicTableByteCount + n3 - this.maxDynamicTableByteCount;
        int n5 = this.evictToRecoverBytes(n4);
        if (n2 == -1) {
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            int n6 = this.nextHeaderIndex;
            this.nextHeaderIndex = n6 + -1;
            n2 = n6;
            this.dynamicTable[n2] = header;
            n6 = this.headerCount;
            this.headerCount = n6 + 1;
        } else {
            n2 += this.dynamicTableIndex(n2) + n5;
            this.dynamicTable[n2] = header;
        }
        this.dynamicTableByteCount += n3;
    }

    private final int readByte() {
        return Util.and(this.source.readByte(), 255);
    }

    public final int readInt(int n, int n2) {
        int n3;
        int n4 = n & n2;
        if (n4 < n2) {
            return n4;
        }
        int n5 = n2;
        int n6 = 0;
        while (((n3 = this.readByte()) & 0x80) != 0) {
            n5 += (n3 & 0x7F) << n6;
            n6 += 7;
        }
        return n5 += n3 << n6;
    }

    @NotNull
    public final ByteString readByteString() {
        ByteString byteString;
        int n = this.readByte();
        boolean bl = (n & 0x80) == 128;
        long l = this.readInt(n, 127);
        if (bl) {
            Buffer buffer = new Buffer();
            Huffman.INSTANCE.decode(this.source, l, buffer);
            byteString = buffer.readByteString();
        } else {
            byteString = this.source.readByteString(l);
        }
        return byteString;
    }

    @JvmOverloads
    public Hpack$Reader(@NotNull Source source2, int n) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this(source2, n, 0, 4, null);
    }
}

