/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack$Reader;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Http2Reader$Companion;
import okhttp3.internal.http2.Http2Reader$ContinuationSource;
import okhttp3.internal.http2.Http2Reader$Handler;
import okhttp3.internal.http2.Settings;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010!\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lokhttp3/internal/http2/Http2Reader;", "Ljava/io/Closeable;", "source", "Lokio/BufferedSource;", "client", "", "(Lokio/BufferedSource;Z)V", "continuation", "Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "hpackReader", "Lokhttp3/internal/http2/Hpack$Reader;", "close", "", "nextFrame", "requireSettings", "handler", "Lokhttp3/internal/http2/Http2Reader$Handler;", "readConnectionPreface", "readData", "length", "", "flags", "streamId", "readGoAway", "readHeaderBlock", "", "Lokhttp3/internal/http2/Header;", "padding", "readHeaders", "readPing", "readPriority", "readPushPromise", "readRstStream", "readSettings", "readWindowUpdate", "Companion", "ContinuationSource", "Handler", "okhttp"})
public final class Http2Reader
implements Closeable {
    @NotNull
    public static final Http2Reader$Companion Companion = new Http2Reader$Companion(null);
    @NotNull
    private final BufferedSource source;
    private final boolean client;
    @NotNull
    private final Http2Reader$ContinuationSource continuation;
    @NotNull
    private final Hpack$Reader hpackReader;
    @NotNull
    private static final Logger logger;

    public Http2Reader(@NotNull BufferedSource bufferedSource, boolean bl) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        this.source = bufferedSource;
        this.client = bl;
        this.continuation = new Http2Reader$ContinuationSource(this.source);
        this.hpackReader = new Hpack$Reader(this.continuation, 4096, 0, 4, null);
    }

    public final void readConnectionPreface(@NotNull Http2Reader$Handler http2Reader$Handler) {
        Intrinsics.checkNotNullParameter(http2Reader$Handler, "handler");
        if (this.client) {
            if (!this.nextFrame(true, http2Reader$Handler)) {
                throw new IOException("Required SETTINGS preface not received");
            }
        } else {
            ByteString byteString = this.source.readByteString(Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format("<< CONNECTION " + byteString.hex(), new Object[0]));
            }
            if (!Intrinsics.areEqual(Http2.CONNECTION_PREFACE, byteString)) {
                throw new IOException("Expected a connection header but was " + byteString.utf8());
            }
        }
    }

    public final boolean nextFrame(boolean bl, @NotNull Http2Reader$Handler http2Reader$Handler) {
        Intrinsics.checkNotNullParameter(http2Reader$Handler, "handler");
        try {
            this.source.require(9L);
        }
        catch (EOFException eOFException) {
            return false;
        }
        int n = Util.readMedium(this.source);
        if (n > 16384) {
            throw new IOException("FRAME_SIZE_ERROR: " + n);
        }
        int n2 = Util.and(this.source.readByte(), 255);
        int n3 = Util.and(this.source.readByte(), 255);
        int n4 = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(true, n4, n, n2, n3));
        }
        if (bl && n2 != 4) {
            throw new IOException("Expected a SETTINGS frame but was " + Http2.INSTANCE.formattedType$okhttp(n2));
        }
        switch (n2) {
            case 0: {
                this.readData(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 1: {
                this.readHeaders(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 2: {
                this.readPriority(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 3: {
                this.readRstStream(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 4: {
                this.readSettings(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 5: {
                this.readPushPromise(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 6: {
                this.readPing(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 7: {
                this.readGoAway(http2Reader$Handler, n, n3, n4);
                break;
            }
            case 8: {
                this.readWindowUpdate(http2Reader$Handler, n, n3, n4);
                break;
            }
            default: {
                this.source.skip(n);
            }
        }
        return true;
    }

    private final void readHeaders(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
        }
        boolean bl = (n2 & 1) != 0;
        int n4 = (n2 & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int n5 = n;
        if ((n2 & 0x20) != 0) {
            this.readPriority(http2Reader$Handler, n3);
            n5 -= 5;
        }
        n5 = Companion.lengthWithoutPadding(n5, n2, n4);
        List<Header> list = this.readHeaderBlock(n5, n4, n2, n3);
        http2Reader$Handler.headers(bl, n3, -1, list);
    }

    private final List<Header> readHeaderBlock(int n, int n2, int n3, int n4) {
        this.continuation.setLeft(n);
        this.continuation.setLength(this.continuation.getLeft());
        this.continuation.setPadding(n2);
        this.continuation.setFlags(n3);
        this.continuation.setStreamId(n4);
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private final void readData(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        boolean bl;
        if (n3 == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
        }
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = bl = (n2 & 0x20) != 0;
        if (bl) {
            throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
        }
        int n4 = (n2 & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int n5 = Companion.lengthWithoutPadding(n, n2, n4);
        http2Reader$Handler.data(bl2, n3, this.source, n5);
        this.source.skip(n4);
    }

    private final void readPriority(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n != 5) {
            throw new IOException("TYPE_PRIORITY length: " + n + " != 5");
        }
        if (n3 == 0) {
            throw new IOException("TYPE_PRIORITY streamId == 0");
        }
        this.readPriority(http2Reader$Handler, n3);
    }

    private final void readPriority(Http2Reader$Handler http2Reader$Handler, int n) {
        int n2 = this.source.readInt();
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        int n3 = n2 & Integer.MAX_VALUE;
        int n4 = Util.and(this.source.readByte(), 255) + 1;
        http2Reader$Handler.priority(n, n3, n4, bl);
    }

    private final void readRstStream(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n != 4) {
            throw new IOException("TYPE_RST_STREAM length: " + n + " != 4");
        }
        if (n3 == 0) {
            throw new IOException("TYPE_RST_STREAM streamId == 0");
        }
        int n4 = this.source.readInt();
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n4);
        if (errorCode == null) {
            throw new IOException("TYPE_RST_STREAM unexpected error code: " + n4);
        }
        ErrorCode errorCode2 = errorCode;
        http2Reader$Handler.rstStream(n3, errorCode2);
    }

    private final void readSettings(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 != 0) {
            throw new IOException("TYPE_SETTINGS streamId != 0");
        }
        if ((n2 & 1) != 0) {
            if (n != 0) {
                throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
            }
            http2Reader$Handler.ackSettings();
            return;
        }
        if (n % 6 != 0) {
            throw new IOException("TYPE_SETTINGS length % 6 != 0: " + n);
        }
        Settings settings = new Settings();
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, n), 6);
        int n4 = intProgression.getFirst();
        int n5 = intProgression.getLast();
        int n6 = intProgression.getStep();
        if (n6 > 0 && n4 <= n5 || n6 < 0 && n5 <= n4) {
            while (true) {
                int n7 = Util.and(this.source.readShort(), 65535);
                int n8 = this.source.readInt();
                switch (n7) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (n8 == 0 || n8 == 1) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                    }
                    case 3: {
                        n7 = 4;
                        break;
                    }
                    case 4: {
                        n7 = 7;
                        if (n8 >= 0) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                    }
                    case 5: {
                        if (n8 >= 16384 && n8 <= 0xFFFFFF) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: " + n8);
                    }
                }
                settings.set(n7, n8);
                if (n4 == n5) break;
                n4 += n6;
            }
        }
        http2Reader$Handler.settings(false, settings);
    }

    private final void readPushPromise(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 == 0) {
            throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
        }
        int n4 = (n2 & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
        int n5 = this.source.readInt() & Integer.MAX_VALUE;
        int n6 = Companion.lengthWithoutPadding(n - 4, n2, n4);
        List<Header> list = this.readHeaderBlock(n6, n4, n2, n3);
        http2Reader$Handler.pushPromise(n3, n5, list);
    }

    private final void readPing(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n != 8) {
            throw new IOException("TYPE_PING length != 8: " + n);
        }
        if (n3 != 0) {
            throw new IOException("TYPE_PING streamId != 0");
        }
        int n4 = this.source.readInt();
        int n5 = this.source.readInt();
        boolean bl = (n2 & 1) != 0;
        http2Reader$Handler.ping(bl, n4, n5);
    }

    private final void readGoAway(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n < 8) {
            throw new IOException("TYPE_GOAWAY length < 8: " + n);
        }
        if (n3 != 0) {
            throw new IOException("TYPE_GOAWAY streamId != 0");
        }
        int n4 = this.source.readInt();
        int n5 = this.source.readInt();
        int n6 = n - 8;
        ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n5);
        if (errorCode == null) {
            throw new IOException("TYPE_GOAWAY unexpected error code: " + n5);
        }
        ErrorCode errorCode2 = errorCode;
        ByteString byteString = ByteString.EMPTY;
        if (n6 > 0) {
            byteString = this.source.readByteString(n6);
        }
        http2Reader$Handler.goAway(n4, errorCode2, byteString);
    }

    private final void readWindowUpdate(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n != 4) {
            throw new IOException("TYPE_WINDOW_UPDATE length !=4: " + n);
        }
        long l = Util.and(this.source.readInt(), Integer.MAX_VALUE);
        if (l == 0L) {
            throw new IOException("windowSizeIncrement was 0");
        }
        http2Reader$Handler.windowUpdate(n3, l);
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(Http2::class.java.name)");
        Http2Reader.logger = logger;
    }
}

