/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.StreamResetException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001d\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lokhttp3/internal/http2/Http2Stream$FramingSource;", "Lokio/Source;", "maxByteCount", "", "finished", "", "(Lokhttp3/internal/http2/Http2Stream;JZ)V", "closed", "getClosed$okhttp", "()Z", "setClosed$okhttp", "(Z)V", "getFinished$okhttp", "setFinished$okhttp", "readBuffer", "Lokio/Buffer;", "getReadBuffer", "()Lokio/Buffer;", "receiveBuffer", "getReceiveBuffer", "trailers", "Lokhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "close", "", "read", "sink", "byteCount", "receive", "source", "Lokio/BufferedSource;", "receive$okhttp", "timeout", "Lokio/Timeout;", "updateConnectionFlowControl", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Stream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n*L\n1#1,688:1\n1#2:689\n615#3,4:690\n615#3,4:694\n563#3:698\n563#3:699\n*S KotlinDebug\n*F\n+ 1 Http2Stream.kt\nokhttp3/internal/http2/Http2Stream$FramingSource\n*L\n407#1:690,4\n418#1:694,4\n458#1:698\n480#1:699\n*E\n"})
public final class Http2Stream$FramingSource
implements Source {
    private final long maxByteCount;
    private boolean finished;
    @NotNull
    private final Buffer receiveBuffer;
    @NotNull
    private final Buffer readBuffer;
    @Nullable
    private Headers trailers;
    private boolean closed;
    final /* synthetic */ Http2Stream this$0;

    public Http2Stream$FramingSource(Http2Stream http2Stream, long l, boolean bl) {
        this.this$0 = http2Stream;
        this.maxByteCount = l;
        this.finished = bl;
        this.receiveBuffer = new Buffer();
        this.readBuffer = new Buffer();
    }

    public final boolean getFinished$okhttp() {
        return this.finished;
    }

    public final void setFinished$okhttp(boolean bl) {
        this.finished = bl;
    }

    @NotNull
    public final Buffer getReceiveBuffer() {
        return this.receiveBuffer;
    }

    @NotNull
    public final Buffer getReadBuffer() {
        return this.readBuffer;
    }

    @Nullable
    public final Headers getTrailers() {
        return this.trailers;
    }

    public final void setTrailers(@Nullable Headers headers) {
        this.trailers = headers;
    }

    public final boolean getClosed$okhttp() {
        return this.closed;
    }

    public final void setClosed$okhttp(boolean bl) {
        this.closed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(@NotNull Buffer buffer, long l) {
        IOException iOException;
        long l2;
        boolean bl;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (!(l >= 0L)) {
            boolean bl2 = false;
            String string = "byteCount < 0: " + l;
            throw new IllegalArgumentException(string.toString());
        }
        do {
            bl = false;
            l2 = 0L;
            l2 = -1L;
            iOException = null;
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            Http2Stream http2Stream3 = http2Stream;
            synchronized (http2Stream3) {
                boolean bl3 = false;
                http2Stream2.getReadTimeout$okhttp().enter();
                try {
                    IOException iOException2;
                    if (http2Stream2.getErrorCode$okhttp() != null && !this.finished && (iOException2 = http2Stream2.getErrorException$okhttp()) == null) {
                        ErrorCode errorCode = http2Stream2.getErrorCode$okhttp();
                        Intrinsics.checkNotNull((Object)errorCode);
                        iOException2 = iOException = (IOException)new StreamResetException(errorCode);
                    }
                    if (this.closed) {
                        throw new IOException("stream closed");
                    }
                    if (this.readBuffer.size() > 0L) {
                        l2 = this.readBuffer.read(buffer, Math.min(l, this.readBuffer.size()));
                        http2Stream2.setReadBytesTotal$okhttp(http2Stream2.getReadBytesTotal() + l2);
                        long l3 = http2Stream2.getReadBytesTotal() - http2Stream2.getReadBytesAcknowledged();
                        if (iOException == null && l3 >= (long)(http2Stream2.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                            http2Stream2.getConnection().writeWindowUpdateLater$okhttp(http2Stream2.getId(), l3);
                            http2Stream2.setReadBytesAcknowledged$okhttp(http2Stream2.getReadBytesTotal());
                        }
                    } else if (!this.finished && iOException == null) {
                        http2Stream2.waitForIo$okhttp();
                        bl = true;
                    }
                }
                finally {
                    http2Stream2.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                Unit unit = Unit.INSTANCE;
            }
        } while (bl);
        if (l2 != -1L) {
            return l2;
        }
        if (iOException != null) {
            throw (Throwable)iOException;
        }
        return -1L;
    }

    private final void updateConnectionFlowControl(long l) {
        Http2Stream http2Stream = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        this.this$0.getConnection().updateConnectionFlowControl$okhttp(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receive$okhttp(@NotNull BufferedSource bufferedSource, long l) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Http2Stream http2Stream = this.this$0;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        long l2 = 0L;
        l2 = l;
        while (l2 > 0L) {
            Object object;
            bl = false;
            boolean bl2 = false;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream2) {
                boolean bl3 = false;
                bl = this.finished;
                bl2 = l2 + this.readBuffer.size() > this.maxByteCount;
                object = Unit.INSTANCE;
            }
            if (bl2) {
                bufferedSource.skip(l2);
                this.this$0.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                return;
            }
            if (bl) {
                bufferedSource.skip(l2);
                return;
            }
            long l3 = bufferedSource.read(this.receiveBuffer, l2);
            if (l3 == -1L) {
                throw new EOFException();
            }
            l2 -= l3;
            object = this.this$0;
            Http2Stream http2Stream3 = this.this$0;
            Object object2 = object;
            synchronized (object2) {
                boolean bl4 = false;
                if (this.closed) {
                    this.receiveBuffer.clear();
                } else {
                    boolean bl5 = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (bl5) {
                        Http2Stream http2Stream4 = http2Stream3;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull(http2Stream4, "null cannot be cast to non-null type java.lang.Object");
                        ((Object)http2Stream4).notifyAll();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        this.updateConnectionFlowControl(l);
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.this$0.getReadTimeout$okhttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long l = 0L;
        Http2Stream http2Stream = this.this$0;
        Http2Stream http2Stream2 = this.this$0;
        Http2Stream http2Stream3 = http2Stream;
        synchronized (http2Stream3) {
            boolean bl = false;
            this.closed = true;
            l = this.readBuffer.size();
            this.readBuffer.clear();
            Http2Stream http2Stream4 = http2Stream2;
            boolean bl2 = false;
            Intrinsics.checkNotNull(http2Stream4, "null cannot be cast to non-null type java.lang.Object");
            ((Object)http2Stream4).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        if (l > 0L) {
            this.updateConnectionFlowControl(l);
        }
        this.this$0.cancelStreamIfNecessary$okhttp();
    }
}

