/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.FileHandle$FileHandleSink;
import okio.FileHandle$FileHandleSource;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio._JvmPlatformKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002-.B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0013H$J\b\u0010\u001b\u001a\u00020\u0013H$J(\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH$J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0016H$J\b\u0010$\u001a\u00020\u0016H$J(\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH$J&\u0010&\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rJ\u001e\u0010&\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0016J \u0010(\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0016J&\u0010+\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rJ\u001e\u0010+\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0016J \u0010,\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lokio/FileHandle;", "Ljava/io/Closeable;", "Lokio/Closeable;", "readWrite", "", "(Z)V", "closed", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lokio/Lock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "openStreamCount", "", "getReadWrite", "()Z", "appendingSink", "Lokio/Sink;", "close", "", "flush", "position", "", "sink", "source", "Lokio/Source;", "protectedClose", "protectedFlush", "protectedRead", "fileOffset", "array", "", "arrayOffset", "byteCount", "protectedResize", "size", "protectedSize", "protectedWrite", "read", "Lokio/Buffer;", "readNoCloseCheck", "reposition", "resize", "write", "writeNoCloseCheck", "FileHandleSink", "FileHandleSource", "okio"})
@SourceDebugExtension(value={"SMAP\nFileHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHandle.kt\nokio/FileHandle\n+ 2 -JvmPlatform.kt\nokio/_JvmPlatformKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RealBufferedSource.kt\nokio/RealBufferedSource\n+ 5 RealBufferedSink.kt\nokio/RealBufferedSink\n+ 6 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,444:1\n33#2:445\n33#2:447\n33#2:448\n33#2:449\n33#2:450\n33#2:451\n33#2:452\n33#2:453\n33#2:457\n33#2:459\n1#3:446\n62#4:454\n62#4:455\n62#4:456\n51#5:458\n86#6:460\n86#6:461\n*S KotlinDebug\n*F\n+ 1 FileHandle.kt\nokio/FileHandle\n*L\n69#1:445\n81#1:447\n92#1:448\n105#1:449\n119#1:450\n129#1:451\n139#1:452\n151#1:453\n221#1:457\n287#1:459\n169#1:454\n195#1:455\n202#1:456\n248#1:458\n345#1:460\n374#1:461\n*E\n"})
public abstract class FileHandle
implements Closeable {
    private final boolean readWrite;
    private boolean closed;
    private int openStreamCount;
    @NotNull
    private final ReentrantLock lock;

    public FileHandle(boolean bl) {
        this.readWrite = bl;
        this.lock = _JvmPlatformKt.newLock();
    }

    public final boolean getReadWrite() {
        return this.readWrite;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(long l, @NotNull byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(byArray, "array");
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return this.protectedRead(l, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long read(long l, @NotNull Buffer buffer, long l2) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return this.readNoCloseCheck(l, buffer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long size() {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return this.protectedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resize(long l) {
        if (!this.readWrite) {
            boolean bl = false;
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.protectedResize(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(long l, @NotNull byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(byArray, "array");
        if (!this.readWrite) {
            boolean bl = false;
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.protectedWrite(l, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(long l, @NotNull Buffer buffer, long l2) {
        Intrinsics.checkNotNullParameter(buffer, "source");
        if (!this.readWrite) {
            boolean bl = false;
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.writeNoCloseCheck(l, buffer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (!this.readWrite) {
            boolean bl = false;
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (!(!this.closed)) {
                boolean bl3 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.protectedFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Source source(long l) {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            int n = 0;
            if (!(!this.closed)) {
                boolean bl2 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            int n2 = this.openStreamCount;
            this.openStreamCount = n2 + 1;
            n = n2;
        }
        finally {
            lock.unlock();
        }
        return new FileHandle$FileHandleSource(this, l);
    }

    public static /* synthetic */ Source source$default(FileHandle fileHandle, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: source");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.source(l);
    }

    public final long position(@NotNull Source source2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(source2, "source");
        Source source3 = source2;
        long l = 0L;
        if (source3 instanceof RealBufferedSource) {
            RealBufferedSource realBufferedSource = (RealBufferedSource)source3;
            bl = false;
            l = realBufferedSource.bufferField.size();
            source3 = ((RealBufferedSource)source3).source;
        }
        if (!(source3 instanceof FileHandle$FileHandleSource && ((FileHandle$FileHandleSource)source3).getFileHandle() == this)) {
            bl = false;
            String string = "source was not created by this FileHandle";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!((FileHandle$FileHandleSource)source3).getClosed())) {
            bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        return ((FileHandle$FileHandleSource)source3).getPosition() - l;
    }

    public final void reposition(@NotNull Source source2, long l) {
        Intrinsics.checkNotNullParameter(source2, "source");
        if (source2 instanceof RealBufferedSource) {
            Source source3 = ((RealBufferedSource)source2).source;
            if (!(source3 instanceof FileHandle$FileHandleSource && ((FileHandle$FileHandleSource)source3).getFileHandle() == this)) {
                boolean bl = false;
                String string = "source was not created by this FileHandle";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((FileHandle$FileHandleSource)source3).getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            RealBufferedSource realBufferedSource = (RealBufferedSource)source2;
            boolean bl = false;
            long l2 = realBufferedSource.bufferField.size();
            long l3 = l - (((FileHandle$FileHandleSource)source3).getPosition() - l2);
            boolean bl2 = 0L <= l3 ? l3 < l2 : false;
            if (bl2) {
                ((RealBufferedSource)source2).skip(l3);
            } else {
                RealBufferedSource realBufferedSource2 = (RealBufferedSource)source2;
                boolean bl3 = false;
                realBufferedSource2.bufferField.clear();
                ((FileHandle$FileHandleSource)source3).setPosition(l);
            }
        } else {
            if (!(source2 instanceof FileHandle$FileHandleSource && ((FileHandle$FileHandleSource)source2).getFileHandle() == this)) {
                boolean bl = false;
                String string = "source was not created by this FileHandle";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((FileHandle$FileHandleSource)source2).getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            ((FileHandle$FileHandleSource)source2).setPosition(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Sink sink(long l) {
        if (!this.readWrite) {
            boolean bl = false;
            String string = "file handle is read-only";
            throw new IllegalStateException(string.toString());
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            int n = 0;
            if (!(!this.closed)) {
                boolean bl2 = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            int n2 = this.openStreamCount;
            this.openStreamCount = n2 + 1;
            n = n2;
        }
        finally {
            lock.unlock();
        }
        return new FileHandle$FileHandleSink(this, l);
    }

    public static /* synthetic */ Sink sink$default(FileHandle fileHandle, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sink");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.sink(l);
    }

    @NotNull
    public final Sink appendingSink() {
        return this.sink(this.size());
    }

    public final long position(@NotNull Sink sink2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Sink sink3 = sink2;
        long l = 0L;
        if (sink3 instanceof RealBufferedSink) {
            RealBufferedSink realBufferedSink = (RealBufferedSink)sink3;
            bl = false;
            l = realBufferedSink.bufferField.size();
            sink3 = ((RealBufferedSink)sink3).sink;
        }
        if (!(sink3 instanceof FileHandle$FileHandleSink && ((FileHandle$FileHandleSink)sink3).getFileHandle() == this)) {
            bl = false;
            String string = "sink was not created by this FileHandle";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!((FileHandle$FileHandleSink)sink3).getClosed())) {
            bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        return ((FileHandle$FileHandleSink)sink3).getPosition() + l;
    }

    public final void reposition(@NotNull Sink sink2, long l) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (sink2 instanceof RealBufferedSink) {
            Sink sink3 = ((RealBufferedSink)sink2).sink;
            if (!(sink3 instanceof FileHandle$FileHandleSink && ((FileHandle$FileHandleSink)sink3).getFileHandle() == this)) {
                boolean bl = false;
                String string = "sink was not created by this FileHandle";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((FileHandle$FileHandleSink)sink3).getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            ((RealBufferedSink)sink2).emit();
            ((FileHandle$FileHandleSink)sink3).setPosition(l);
        } else {
            if (!(sink2 instanceof FileHandle$FileHandleSink && ((FileHandle$FileHandleSink)sink2).getFileHandle() == this)) {
                boolean bl = false;
                String string = "sink was not created by this FileHandle";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((FileHandle$FileHandleSink)sink2).getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            ((FileHandle$FileHandleSink)sink2).setPosition(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        Lock lock = reentrantLock;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.openStreamCount != 0) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.protectedClose();
    }

    protected abstract int protectedRead(long var1, @NotNull byte[] var3, int var4, int var5);

    protected abstract void protectedWrite(long var1, @NotNull byte[] var3, int var4, int var5);

    protected abstract void protectedFlush();

    protected abstract void protectedResize(long var1);

    protected abstract long protectedSize();

    protected abstract void protectedClose();

    private final long readNoCloseCheck(long l, Buffer buffer, long l2) {
        long l3;
        int n;
        if (!(l2 >= 0L)) {
            boolean bl = false;
            String string = "byteCount < 0: " + l2;
            throw new IllegalArgumentException(string.toString());
        }
        long l4 = l + l2;
        for (l3 = l; l3 < l4; l3 += (long)n) {
            Segment segment = buffer.writableSegment$okio(1);
            long l5 = l4 - l3;
            int n2 = 8192 - segment.limit;
            boolean bl = false;
            n = this.protectedRead(l3, segment.data, segment.limit, (int)Math.min(l5, (long)n2));
            if (n == -1) {
                if (segment.pos == segment.limit) {
                    buffer.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                if (l != l3) break;
                return -1L;
            }
            segment.limit += n;
            buffer.setSize$okio(buffer.size() + (long)n);
        }
        return l3 - l;
    }

    private final void writeNoCloseCheck(long l, Buffer buffer, long l2) {
        int n;
        -SegmentedByteString.checkOffsetAndCount(buffer.size(), 0L, l2);
        long l3 = l + l2;
        for (long i = l; i < l3; i += (long)n) {
            Segment segment;
            Intrinsics.checkNotNull(buffer.head);
            long l4 = l3 - i;
            int n2 = segment.limit - segment.pos;
            boolean bl = false;
            n = (int)Math.min(l4, (long)n2);
            this.protectedWrite(i, segment.data, segment.pos, n);
            segment.pos += n;
            buffer.setSize$okio(buffer.size() - (long)n);
            if (segment.pos != segment.limit) continue;
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    public static final /* synthetic */ void access$writeNoCloseCheck(FileHandle fileHandle, long l, Buffer buffer, long l2) {
        fileHandle.writeNoCloseCheck(l, buffer, l2);
    }

    public static final /* synthetic */ int access$getOpenStreamCount$p(FileHandle fileHandle) {
        return fileHandle.openStreamCount;
    }

    public static final /* synthetic */ void access$setOpenStreamCount$p(FileHandle fileHandle, int n) {
        fileHandle.openStreamCount = n;
    }

    public static final /* synthetic */ boolean access$getClosed$p(FileHandle fileHandle) {
        return fileHandle.closed;
    }

    public static final /* synthetic */ long access$readNoCloseCheck(FileHandle fileHandle, long l, Buffer buffer, long l2) {
        return fileHandle.readNoCloseCheck(l, buffer, l2);
    }
}

