/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.JvmFileHandle;
import okio.Okio;
import okio.Path;
import okio.Path$Companion;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\"\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lokio/JvmSystemFileSystem;", "Lokio/FileSystem;", "()V", "appendingSink", "Lokio/Sink;", "file", "Lokio/Path;", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "toString", "", "requireCreate", "requireExist", "okio"})
@SourceDebugExtension(value={"SMAP\nJvmSystemFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n11400#2,3:159\n*S KotlinDebug\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n*L\n77#1:159,3\n*E\n"})
public class JvmSystemFileSystem
extends FileSystem {
    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File file = path.toFile().getCanonicalFile();
        if (!file.exists()) {
            throw new FileNotFoundException("no such file");
        }
        Intrinsics.checkNotNull(file);
        return Path$Companion.get$default(Path.Companion, file, false, 1, null);
    }

    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File file = path.toFile();
        boolean bl = file.isFile();
        boolean bl2 = file.isDirectory();
        long l = file.lastModified();
        long l2 = file.length();
        if (!(bl || bl2 || l != 0L || l2 != 0L || file.exists())) {
            return null;
        }
        return new FileMetadata(bl, bl2, null, l2, null, l, null, null, 128, null);
    }

    @Override
    @NotNull
    public List<Path> list(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "dir");
        List<Path> list = this.list(path, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @Nullable
    public List<Path> listOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "dir");
        return this.list(path, false);
    }

    private final List<Path> list(Path path, boolean bl) {
        File file = path.toFile();
        String[] stringArray = file.list();
        if (stringArray == null) {
            if (bl) {
                if (!file.exists()) {
                    throw new FileNotFoundException("no such file: " + path);
                }
                throw new IOException("failed to list " + path);
            }
            return null;
        }
        String[] stringArray2 = stringArray;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray2[i];
            Collection collection2 = collection;
            boolean bl3 = false;
            Intrinsics.checkNotNull(string2);
            collection2.add(path.resolve(string2));
        }
        List list = (List)collection;
        CollectionsKt.sort(list);
        return list;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "file");
        return new JvmFileHandle(false, new RandomAccessFile(path.toFile(), "r"));
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path path, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(path, "file");
        if (!(!bl || !bl2)) {
            boolean bl3 = false;
            String string = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException(string.toString());
        }
        if (bl) {
            this.requireCreate(path);
        }
        if (bl2) {
            this.requireExist(path);
        }
        return new JvmFileHandle(true, new RandomAccessFile(path.toFile(), "rw"));
    }

    @Override
    @NotNull
    public Source source(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "file");
        return Okio.source(path.toFile());
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "file");
        if (bl) {
            this.requireCreate(path);
        }
        return Okio.sink$default(path.toFile(), false, 1, null);
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "file");
        if (bl) {
            this.requireExist(path);
        }
        return Okio.sink(path.toFile(), true);
    }

    @Override
    public void createDirectory(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "dir");
        if (!path.toFile().mkdir()) {
            boolean bl2;
            FileMetadata fileMetadata = this.metadataOrNull(path);
            boolean bl3 = fileMetadata != null ? fileMetadata.isDirectory() : (bl2 = false);
            if (bl2) {
                if (bl) {
                    throw new IOException(path + " already exists.");
                }
                return;
            }
            throw new IOException("failed to create directory: " + path);
        }
    }

    @Override
    public void atomicMove(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter(path, "source");
        Intrinsics.checkNotNullParameter(path2, "target");
        boolean bl = path.toFile().renameTo(path2.toFile());
        if (!bl) {
            throw new IOException("failed to move " + path + " to " + path2);
        }
    }

    @Override
    public void delete(@NotNull Path path, boolean bl) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        File file = path.toFile();
        boolean bl2 = file.delete();
        if (!bl2) {
            if (file.exists()) {
                throw new IOException("failed to delete " + path);
            }
            if (bl) {
                throw new FileNotFoundException("no such file: " + path);
            }
        }
    }

    @Override
    public void createSymlink(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter(path, "source");
        Intrinsics.checkNotNullParameter(path2, "target");
        throw new IOException("unsupported");
    }

    @NotNull
    public String toString() {
        return "JvmSystemFileSystem";
    }

    private final void requireExist(Path path) {
        if (!this.exists(path)) {
            throw new IOException(path + " doesn't exist.");
        }
    }

    private final void requireCreate(Path path) {
        if (this.exists(path)) {
            throw new IOException(path + " already exists.");
        }
    }
}

