/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;

class ThreadMonitor
implements Runnable {
    private final Thread thread;
    private final Duration timeout;

    static Thread start(Duration duration) {
        return ThreadMonitor.start(Thread.currentThread(), duration);
    }

    static Thread start(Thread thread2, Duration duration) {
        if (duration.isZero() || duration.isNegative()) {
            return null;
        }
        ThreadMonitor threadMonitor = new ThreadMonitor(thread2, duration);
        Thread thread3 = new Thread((Runnable)threadMonitor, ThreadMonitor.class.getSimpleName());
        thread3.setDaemon(true);
        thread3.start();
        return thread3;
    }

    static void stop(Thread thread2) {
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    private ThreadMonitor(Thread thread2, Duration duration) {
        this.thread = thread2;
        this.timeout = duration;
    }

    @Override
    public void run() {
        try {
            ThreadMonitor.sleep(this.timeout);
            this.thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sleep(Duration duration) {
        long l = duration.toMillis();
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        do {
            Thread.sleep(l3);
        } while ((l3 = l2 - System.currentTimeMillis()) > 0L);
    }
}

