/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -2132740084016138541L;
    private final boolean acceptOlder;
    private final long cutoffMillis;

    public AgeFileFilter(Date date) {
        this(date, true);
    }

    public AgeFileFilter(Date date, boolean bl) {
        this(date.getTime(), bl);
    }

    public AgeFileFilter(File file) {
        this(file, true);
    }

    public AgeFileFilter(File file, boolean bl) {
        this(FileUtils.lastModifiedUnchecked(file), bl);
    }

    public AgeFileFilter(long l) {
        this(l, true);
    }

    public AgeFileFilter(long l, boolean bl) {
        this.acceptOlder = bl;
        this.cutoffMillis = l;
    }

    @Override
    public boolean accept(File file) {
        boolean bl = FileUtils.isFileNewer(file, this.cutoffMillis);
        return this.acceptOlder != bl;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        boolean bl;
        try {
            bl = PathUtils.isNewer(path, this.cutoffMillis, new LinkOption[0]);
        }
        catch (IOException iOException) {
            return this.handle(iOException);
        }
        return AgeFileFilter.toFileVisitResult(this.acceptOlder != bl, path);
    }

    @Override
    public String toString() {
        String string = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + string + this.cutoffMillis + ")";
    }
}

