/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReadAheadInputStream
extends InputStream {
    private static final ThreadLocal<byte[]> oneByte = ThreadLocal.withInitial(() -> new byte[1]);
    private final ReentrantLock stateChangeLock = new ReentrantLock();
    private ByteBuffer activeBuffer;
    private ByteBuffer readAheadBuffer;
    private boolean endOfStream;
    private boolean readInProgress;
    private boolean readAborted;
    private Throwable readException;
    private boolean isClosed;
    private boolean isUnderlyingInputStreamBeingClosed;
    private boolean isReading;
    private final AtomicBoolean isWaiting = new AtomicBoolean(false);
    private final InputStream underlyingInputStream;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final Condition asyncReadComplete = this.stateChangeLock.newCondition();

    private static ExecutorService newExecutorService() {
        return Executors.newSingleThreadExecutor(ReadAheadInputStream::newThread);
    }

    private static Thread newThread(Runnable runnable2) {
        Thread thread2 = new Thread(runnable2, "commons-io-read-ahead");
        thread2.setDaemon(true);
        return thread2;
    }

    public ReadAheadInputStream(InputStream inputStream2, int n) {
        this(inputStream2, n, ReadAheadInputStream.newExecutorService(), true);
    }

    public ReadAheadInputStream(InputStream inputStream2, int n, ExecutorService executorService) {
        this(inputStream2, n, executorService, false);
    }

    private ReadAheadInputStream(InputStream inputStream2, int n, ExecutorService executorService, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("bufferSizeInBytes should be greater than 0, but the value is " + n);
        }
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.underlyingInputStream = Objects.requireNonNull(inputStream2, "inputStream");
        this.shutdownExecutorService = bl;
        this.activeBuffer = ByteBuffer.allocate(n);
        this.readAheadBuffer = ByteBuffer.allocate(n);
        this.activeBuffer.flip();
        this.readAheadBuffer.flip();
    }

    @Override
    public int available() {
        this.stateChangeLock.lock();
        try {
            int n = (int)Math.min(Integer.MAX_VALUE, (long)this.activeBuffer.remaining() + (long)this.readAheadBuffer.remaining());
            return n;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private void checkReadException() {
        if (this.readAborted) {
            if (this.readException instanceof IOException) {
                throw (IOException)this.readException;
            }
            throw new IOException(this.readException);
        }
    }

    @Override
    public void close() {
        boolean bl = false;
        this.stateChangeLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (!this.isReading) {
                bl = true;
                this.isUnderlyingInputStreamBeingClosed = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (this.shutdownExecutorService) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                interruptedIOException.initCause(interruptedException);
                throw interruptedIOException;
            }
            finally {
                if (bl) {
                    this.underlyingInputStream.close();
                }
            }
        }
    }

    private void closeUnderlyingInputStreamIfNecessary() {
        boolean bl = false;
        this.stateChangeLock.lock();
        try {
            this.isReading = false;
            if (this.isClosed && !this.isUnderlyingInputStreamBeingClosed) {
                bl = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (bl) {
            try {
                this.underlyingInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isEndOfStream() {
        return !this.activeBuffer.hasRemaining() && !this.readAheadBuffer.hasRemaining() && this.endOfStream;
    }

    @Override
    public int read() {
        if (this.activeBuffer.hasRemaining()) {
            return this.activeBuffer.get() & 0xFF;
        }
        byte[] byArray = oneByte.get();
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.activeBuffer.hasRemaining()) {
            this.stateChangeLock.lock();
            try {
                this.waitForAsyncReadComplete();
                if (!this.readAheadBuffer.hasRemaining()) {
                    this.readAsync();
                    this.waitForAsyncReadComplete();
                    if (this.isEndOfStream()) {
                        int n3 = -1;
                        return n3;
                    }
                }
                this.swapBuffers();
                this.readAsync();
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        n2 = Math.min(n2, this.activeBuffer.remaining());
        this.activeBuffer.get(byArray, n, n2);
        return n2;
    }

    private void readAsync() {
        byte[] byArray;
        this.stateChangeLock.lock();
        try {
            byArray = this.readAheadBuffer.array();
            if (this.endOfStream || this.readInProgress) {
                return;
            }
            this.checkReadException();
            this.readAheadBuffer.position(0);
            this.readAheadBuffer.flip();
            this.readInProgress = true;
        }
        finally {
            this.stateChangeLock.unlock();
        }
        this.executorService.execute(() -> {
            this.stateChangeLock.lock();
            try {
                if (this.isClosed) {
                    this.readInProgress = false;
                    return;
                }
                this.isReading = true;
            }
            finally {
                this.stateChangeLock.unlock();
            }
            int n = 0;
            int n2 = 0;
            int n3 = byArray.length;
            Throwable throwable = null;
            try {
                do {
                    if ((n = this.underlyingInputStream.read(byArray, n2, n3)) <= 0) {
                        break;
                    }
                    n2 += n;
                } while ((n3 -= n) > 0 && !this.isWaiting.get());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                if (throwable2 instanceof Error) {
                    throw (Error)throwable2;
                }
            }
            finally {
                this.stateChangeLock.lock();
                try {
                    this.readAheadBuffer.limit(n2);
                    if (n < 0 || throwable instanceof EOFException) {
                        this.endOfStream = true;
                    } else if (throwable != null) {
                        this.readAborted = true;
                        this.readException = throwable;
                    }
                    this.readInProgress = false;
                    this.signalAsyncReadComplete();
                }
                finally {
                    this.stateChangeLock.unlock();
                }
                this.closeUnderlyingInputStreamIfNecessary();
            }
        });
    }

    private void signalAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.asyncReadComplete.signalAll();
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) {
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        if (l <= (long)this.activeBuffer.remaining()) {
            this.activeBuffer.position((int)l + this.activeBuffer.position());
            return l;
        }
        this.stateChangeLock.lock();
        try {
            l2 = this.skipInternal(l);
        }
        finally {
            this.stateChangeLock.unlock();
        }
        return l2;
    }

    private long skipInternal(long l) {
        assert (this.stateChangeLock.isLocked());
        this.waitForAsyncReadComplete();
        if (this.isEndOfStream()) {
            return 0L;
        }
        if ((long)this.available() >= l) {
            int n = (int)l;
            assert ((n -= this.activeBuffer.remaining()) > 0);
            this.activeBuffer.position(0);
            this.activeBuffer.flip();
            this.readAheadBuffer.position(n + this.readAheadBuffer.position());
            this.swapBuffers();
            this.readAsync();
            return l;
        }
        int n = this.available();
        long l2 = l - (long)n;
        this.activeBuffer.position(0);
        this.activeBuffer.flip();
        this.readAheadBuffer.position(0);
        this.readAheadBuffer.flip();
        long l3 = this.underlyingInputStream.skip(l2);
        this.readAsync();
        return (long)n + l3;
    }

    private void swapBuffers() {
        ByteBuffer byteBuffer = this.activeBuffer;
        this.activeBuffer = this.readAheadBuffer;
        this.readAheadBuffer = byteBuffer;
    }

    private void waitForAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.isWaiting.set(true);
            while (this.readInProgress) {
                this.asyncReadComplete.await();
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        finally {
            this.isWaiting.set(false);
            this.stateChangeLock.unlock();
        }
        this.checkReadException();
    }
}

