/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;

public class ByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.writeImpl(byArray, n, n2);
        }
    }

    @Override
    public synchronized void write(int n) {
        this.writeImpl(n);
    }

    @Override
    public synchronized int write(InputStream inputStream2) {
        return this.writeImpl(inputStream2);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized void reset() {
        this.resetImpl();
    }

    @Override
    public synchronized void writeTo(OutputStream outputStream2) {
        this.writeToImpl(outputStream2);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream2) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream2, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream2, int n) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);){
            byteArrayOutputStream.write(inputStream2);
            InputStream inputStream3 = byteArrayOutputStream.toInputStream();
            return inputStream3;
        }
    }

    @Override
    public synchronized InputStream toInputStream() {
        return this.toInputStream(ByteArrayInputStream::new);
    }

    @Override
    public synchronized byte[] toByteArray() {
        return this.toByteArrayImpl();
    }
}

