/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder$1;
import org.apache.commons.lang3.builder.DiffBuilder$10;
import org.apache.commons.lang3.builder.DiffBuilder$11;
import org.apache.commons.lang3.builder.DiffBuilder$12;
import org.apache.commons.lang3.builder.DiffBuilder$13;
import org.apache.commons.lang3.builder.DiffBuilder$14;
import org.apache.commons.lang3.builder.DiffBuilder$15;
import org.apache.commons.lang3.builder.DiffBuilder$16;
import org.apache.commons.lang3.builder.DiffBuilder$17;
import org.apache.commons.lang3.builder.DiffBuilder$18;
import org.apache.commons.lang3.builder.DiffBuilder$2;
import org.apache.commons.lang3.builder.DiffBuilder$3;
import org.apache.commons.lang3.builder.DiffBuilder$4;
import org.apache.commons.lang3.builder.DiffBuilder$5;
import org.apache.commons.lang3.builder.DiffBuilder$6;
import org.apache.commons.lang3.builder.DiffBuilder$7;
import org.apache.commons.lang3.builder.DiffBuilder$8;
import org.apache.commons.lang3.builder.DiffBuilder$9;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final List<Diff<?>> diffs;
    private final boolean objectsTriviallyEqual;
    private final T left;
    private final T right;
    private final ToStringStyle style;

    public DiffBuilder(T t, T t2, ToStringStyle toStringStyle, boolean bl) {
        Validate.notNull(t, "lhs", new Object[0]);
        Validate.notNull(t2, "rhs", new Object[0]);
        this.diffs = new ArrayList();
        this.left = t;
        this.right = t2;
        this.style = toStringStyle;
        this.objectsTriviallyEqual = bl && (t == t2 || t.equals(t2));
    }

    public DiffBuilder(T t, T t2, ToStringStyle toStringStyle) {
        this(t, t2, toStringStyle, true);
    }

    public DiffBuilder<T> append(String string, boolean bl, boolean bl2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (bl != bl2) {
            this.diffs.add(new DiffBuilder$1(this, string, bl, bl2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, boolean[] blArray, boolean[] blArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(blArray, blArray2)) {
            this.diffs.add(new DiffBuilder$2(this, string, blArray, blArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, byte by, byte by2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (by != by2) {
            this.diffs.add(new DiffBuilder$3(this, string, by, by2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, byte[] byArray, byte[] byArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(byArray, byArray2)) {
            this.diffs.add(new DiffBuilder$4(this, string, byArray, byArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, char c, char c2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (c != c2) {
            this.diffs.add(new DiffBuilder$5(this, string, c, c2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, char[] cArray, char[] cArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(cArray, cArray2)) {
            this.diffs.add(new DiffBuilder$6(this, string, cArray, cArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, double d, double d2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(d) != Double.doubleToLongBits(d2)) {
            this.diffs.add(new DiffBuilder$7(this, string, d, d2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, double[] dArray, double[] dArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(dArray, dArray2)) {
            this.diffs.add(new DiffBuilder$8(this, string, dArray, dArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, float f, float f2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(f) != Float.floatToIntBits(f2)) {
            this.diffs.add(new DiffBuilder$9(this, string, f, f2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, float[] fArray, float[] fArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(fArray, fArray2)) {
            this.diffs.add(new DiffBuilder$10(this, string, fArray, fArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, int n, int n2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (n != n2) {
            this.diffs.add(new DiffBuilder$11(this, string, n, n2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, int[] nArray, int[] nArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(nArray, nArray2)) {
            this.diffs.add(new DiffBuilder$12(this, string, nArray, nArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, long l, long l2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (l != l2) {
            this.diffs.add(new DiffBuilder$13(this, string, l, l2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, long[] lArray, long[] lArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lArray, lArray2)) {
            this.diffs.add(new DiffBuilder$14(this, string, lArray, lArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, short s, short s2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (s != s2) {
            this.diffs.add(new DiffBuilder$15(this, string, s, s2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, short[] sArray, short[] sArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(sArray, sArray2)) {
            this.diffs.add(new DiffBuilder$16(this, string, sArray, sArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, Object object, Object object2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        Object object3 = object != null ? object : object2;
        if (object3.getClass().isArray()) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        if (object != null && object.equals(object2)) {
            return this;
        }
        this.diffs.add(new DiffBuilder$17(this, string, object, object2));
        return this;
    }

    public DiffBuilder<T> append(String string, Object[] objectArray, Object[] objectArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(objectArray, objectArray2)) {
            this.diffs.add(new DiffBuilder$18(this, string, objectArray, objectArray2));
        }
        return this;
    }

    public DiffBuilder<T> append(String string, DiffResult<T> diffResult) {
        this.validateFieldNameNotNull(string);
        Validate.notNull(diffResult, "diffResult", new Object[0]);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Diff<?> diff : diffResult.getDiffs()) {
            this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight());
        }
        return this;
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs, this.style);
    }

    private void validateFieldNameNotNull(String string) {
        Validate.notNull(string, "fieldName", new Object[0]);
    }
}

